% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/seriate_GSA.R
\name{LS}
\alias{LS}
\alias{LS_swap}
\alias{LS_insert}
\alias{LS_reverse}
\alias{LS_mixed}
\title{Neighborhood functions for Seriation Method SA}
\usage{
LS_swap(o, pos = sample.int(length(o), 2))

LS_insert(o, pos = sample.int(length(o), 2))

LS_reverse(o, pos = sample.int(length(o), 2))

LS_mixed(o, pos = sample.int(length(o), 2))
}
\arguments{
\item{o}{an integer vector with the order}

\item{pos}{random positions used for the local move.}
}
\value{
returns the new order vector representing the random neighbor.
}
\description{
Definition of different local neighborhood functions for the method \code{"SA"} for \code{\link[=seriate]{seriate()}}.
}
\details{
Local neighborhood functions are \code{LS_insert}, \code{LS_swap}, \code{LS_reverse}, and \code{LS_mix}
(1/3 insertion, 1/3 swap and 1/3 reverse). Any neighborhood function can be defined.
}
