% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lento.R
\name{lento}
\alias{lento}
\title{Lento plot}
\usage{
lento(obj, xlim = NULL, ylim = NULL, main = "Lento plot", sub = NULL,
  xlab = NULL, ylab = NULL, bipart = TRUE, trivial = FALSE,
  col = rgb(0, 0, 0, 0.5), ...)
}
\arguments{
\item{obj}{an object of class phylo, multiPhylo or splits}

\item{xlim}{graphical parameter}

\item{ylim}{graphical parameter}

\item{main}{graphical parameter}

\item{sub}{graphical parameter}

\item{xlab}{graphical parameter}

\item{ylab}{graphical parameter}

\item{bipart}{plot bipartition information.}

\item{trivial}{logical, whether to present trivial splits (default is
FALSE).}

\item{col}{color for the splits / bipartition.}

\item{\dots}{Further arguments passed to or from other methods.}
}
\value{
lento returns a plot.
}
\description{
The lento plot represents support and conflict of splits/bipartitions.
}
\examples{

data(yeast)
yeast.ry <- acgt2ry(yeast)
splits.h <- h2st(yeast.ry)
lento(splits.h, trivial=TRUE) 

}
\references{
Lento, G.M., Hickson, R.E., Chambers G.K., and Penny, D. (1995)
Use of spectral analysis to test hypotheses on the origin of pinninpeds.
\emph{Molecular Biology and Evolution}, \bold{12}, 28-52.
}
\seealso{
\code{\link{as.splits}, \link{hadamard}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{cluster}
\keyword{plot}
