% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph_location.R
\name{ph_location}
\alias{ph_location}
\title{Location for a placeholder from scratch}
\usage{
ph_location(
  left = 1,
  top = 1,
  width = 4,
  height = 3,
  newlabel = "",
  bg = NULL,
  rotation = NULL,
  ln = NULL,
  geom = NULL,
  ...
)
}
\arguments{
\item{left, top, width, height}{place holder coordinates
in inches.}

\item{newlabel}{a label for the placeholder. See section details.}

\item{bg}{background color}

\item{rotation}{rotation angle}

\item{ln}{a \code{\link[=sp_line]{sp_line()}} object specifying the outline style.}

\item{geom}{shape geometry, see http://www.datypic.com/sc/ooxml/t-a_ST_ShapeType.html}

\item{...}{unused arguments}
}
\description{
The function will return a list that complies with
expected format for argument \code{location} of function \code{ph_with}.
}
\details{
The location of the bounding box associated to a placeholder
within a slide is specified with the left top coordinate,
the width and the height. These are defined in inches:

\describe{
\item{left}{left coordinate of the bounding box}
\item{top}{top coordinate of the bounding box}
\item{width}{width of the bounding box}
\item{height}{height of the bounding box}
}

In addition to these attributes, a label can be
associated with the shape. Shapes, text boxes, images and other objects
will be identified with that label in the Selection Pane of PowerPoint.
This label can then be reused by other functions such as \code{ph_location_label()}.
It can be set with argument \code{newlabel}.
}
\examples{
doc <- read_pptx()
doc <- add_slide(doc)
doc <- ph_with(doc, "Hello world",
  location = ph_location(width = 4, height = 3, newlabel = "hello") )
print(doc, target = tempfile(fileext = ".pptx") )

# Set geometry and outline
doc <- read_pptx()
doc <- add_slide(doc)
loc <- ph_location(left = 1, top = 1, width = 4, height = 3, bg = "steelblue",
                   ln = sp_line(color = "red", lwd = 2.5),
                   geom = "trapezoid")
doc <- ph_with(doc, "", loc = loc)
print(doc, target = tempfile(fileext = ".pptx") )
}
\seealso{
Other functions for placeholder location: 
\code{\link{ph_location_fullsize}()},
\code{\link{ph_location_id}()},
\code{\link{ph_location_label}()},
\code{\link{ph_location_left}()},
\code{\link{ph_location_right}()},
\code{\link{ph_location_template}()},
\code{\link{ph_location_type}()}
}
\concept{functions for placeholder location}
