% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drive_auth.R
\name{drive_scopes}
\alias{drive_scopes}
\title{Produce scopes specific to the Drive API}
\usage{
drive_scopes(scopes = NULL)
}
\arguments{
\item{scopes}{One or more API scopes. Each scope can be specified in full or,
for Drive API-specific scopes, in an abbreviated form that is recognized by
\code{\link[=drive_scopes]{drive_scopes()}}:
\itemize{
\item "drive" = "https://www.googleapis.com/auth/drive" (the default)
\item "full" = "https://www.googleapis.com/auth/drive" (same as "drive")
\item "drive.readonly" = "https://www.googleapis.com/auth/drive.readonly"
\item "drive.file" = "https://www.googleapis.com/auth/drive.file"
\item "drive.appdata" = "https://www.googleapis.com/auth/drive.appdata"
\item "drive.metadata" = "https://www.googleapis.com/auth/drive.metadata"
\item "drive.metadata.readonly" = "https://www.googleapis.com/auth/drive.metadata.readonly"
\item "drive.photos.readonly" = "https://www.googleapis.com/auth/drive.photos.readonly"
\item "drive.scripts" = "https://www.googleapis.com/auth/drive.scripts
}

See \url{https://developers.google.com/drive/api/guides/api-specific-auth} for
details on the permissions for each scope.}
}
\value{
A character vector of scopes.
}
\description{
When called with no arguments, \code{drive_scopes()} returns a named character vector
of scopes associated with the Drive API. If \code{drive_scopes(scopes =)} is given,
an abbreviated entry such as \code{"drive.readonly"} is expanded to a full scope
(\code{"https://www.googleapis.com/auth/drive.readonly"} in this case).
Unrecognized scopes are passed through unchanged.
}
\examples{
drive_scopes("full")
drive_scopes("drive.readonly")
drive_scopes()
}
\seealso{
\url{https://developers.google.com/drive/api/guides/api-specific-auth} for details on
the permissions for each scope.

Other auth functions: 
\code{\link{drive_auth_configure}()},
\code{\link{drive_auth}()},
\code{\link{drive_deauth}()}
}
\concept{auth functions}
