% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shared_drives.R
\name{shared_drives}
\alias{shared_drives}
\title{Access shared drives}
\description{
A shared drive supports files owned by an organization rather than an
individual user. Shared drives follow different sharing and ownership models
from a specific user's "My Drive". Shared drives are the successors to the
earlier concept of Team Drives.

How to capture a shared drive or files/folders that live on a
shared drive for downstream use:
\itemize{
\item \code{\link[=shared_drive_find]{shared_drive_find()}} and \code{\link[=shared_drive_get]{shared_drive_get()}} return a \code{\link{dribble}} with
metadata on shared drives themselves. You will need this in order to use a
shared drive in certain file operations. For example, you can specify a
shared drive as the parent folder via the \code{path} argument for upload, move,
copy, etc. In that context, the id of a shared drive functions like the id of
its top-level or root folder.
\item \code{\link[=drive_find]{drive_find()}} and \code{\link[=drive_get]{drive_get()}} return a \code{\link{dribble}} with metadata on
files, including folders. Both can be directed to search for files on shared
drives using the optional arguments \code{shared_drive} or \code{corpus} (documented
below).
}

Regard the functions mentioned above as the official "port of
entry" for working with shared drives. Use these functions to capture your
target(s) in a \code{\link{dribble}} to pass along to other googledrive functions.
The flexibility to refer to files by name or path does not apply as broadly
to shared drives. While it's always a good idea to get things into a
\code{\link{dribble}} early, for shared drives it's often required.
}
\section{Specific shared drive}{

To search one specific shared drive, pass its name, marked id, or
\code{\link{dribble}} to \code{shared_drive} somewhere in the call, like so:\preformatted{drive_find(..., shared_drive = "i_am_a_shared_drive_name")
drive_find(..., shared_drive = as_id("i_am_a_shared_drive_id"))
drive_find(..., shared_drive = i_am_a_shared_drive_dribble)
}

The value provided to \code{shared_drive} is pre-processed with
\code{\link[=as_shared_drive]{as_shared_drive()}}.
}

\section{Other collections}{

To search other collections, pass the \code{corpus} parameter somewhere in the
call, like so:\preformatted{drive_find(..., corpus = "user")
drive_find(..., corpus = "allDrives")
drive_find(..., corpus = "domain")
}

Possible values of \code{corpus} and what they mean:
\itemize{
\item \code{"user"}: Queries files that the user has accessed, including both shared
drive and My Drive files.
\item \code{"drive"}: Queries all items in the shared drive specified via
\code{shared_drive}. googledrive automatically fills this in whenever
\code{shared_drive} is not \code{NULL}.
\item \code{"allDrives"}: Queries files that the user has accessed and all shared
drives in which they are a member. Note that the response may include
\code{incompleteSearch : true}, indicating that some corpora were not searched
for this request (currently, googledrive does not surface this). Prefer
\code{"user"} or \code{"drive"} to \code{"allDrives"} for efficiency.
\item \code{"domain"}: Queries files that are shared to the domain, including both
shared drive and My Drive files.
}
}

\section{Google blogs and docs}{

Here is some of the best official Google reading about shared drives:
\itemize{
\item \href{https://workspaceupdates.googleblog.com/2019/04/shared-drives.html}{Team Drives is being renamed to shared drives} from Google Workspace blog
\item \href{https://cloud.google.com/blog/products/application-development/upcoming-changes-to-the-google-drive-api-and-google-picker-api}{Upcoming changes to the Google Drive API and Google Picker API} from the Google Cloud blog
\item \url{https://developers.google.com/drive/api/v3/about-shareddrives}
\item \url{https://developers.google.com/drive/api/v3/shared-drives-diffs}
\item \href{https://support.google.com/a/users/answer/9310351}{Get started with shared drives} from Google Workspace Learning Center
\item \href{https://support.google.com/a/users/answer/9310156}{Best practices for shared drives} from Google Workspace Learning Center
}
}

\section{API docs}{

googledrive implements shared drive support as outlined here:
\itemize{
\item \url{https://developers.google.com/drive/api/v3/enable-shareddrives}
}

Users shouldn't need to know any of this, but here are details for the
curious. The extra information needed to search shared drives consists of the
following query parameters:
\itemize{
\item \code{corpora}: Where to search? Formed from googledrive's \code{corpus} argument.
\item \code{driveId}: The id of a specific shared drive. Only allowed -- and also
absolutely required -- when \code{corpora = "drive"}. When user specifies a
\code{shared_drive}, googledrive sends its id and also infers that \code{corpora}
should be set to \code{"drive"}.
\item \code{includeItemsFromAllDrives}: Do you want to see shared drive items?
Obviously, this should be \code{TRUE} and googledrive sends this whenever shared
drive parameters are detected.
\item \code{supportsAllDrives}: Does the sending application (googledrive, in this
case) know about shared drive? Obviously, this should be \code{TRUE} and
googledrive sends it for all applicable endpoints, all the time.
}
}

