% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dribble.R
\name{as_dribble}
\alias{as_dribble}
\title{Coerce to a \code{dribble}}
\usage{
as_dribble(x, ...)
}
\arguments{
\item{x}{A vector of Drive file paths, a vector of file ids marked
with \code{\link[=as_id]{as_id()}}, a list of Files Resource objects, or a suitable data
frame.}

\item{...}{Other arguments passed down to methods. (Not used.)}
}
\description{
Converts various representations of Google Drive files into a \code{\link{dribble}},
the object used by googledrive to hold Drive file metadata. Files can be
specified via:
\itemize{
\item File path. File name is an important special case.
\item File id. Mark with \code{\link[=as_id]{as_id()}} to distinguish from file path.
\item Data frame or \code{\link{dribble}}. Once you've successfully used googledrive to
identify the files of interest, you'll have a \code{\link{dribble}}. Pass it into
downstream functions.
\item List representing \href{https://developers.google.com/drive/api/v3/reference/files}{Files resource}
objects. Mostly for internal use.
}

This is a generic function.

For maximum clarity, get your files into a \code{\link{dribble}} (or capture file id)
as early as possible. When specifying via path, it's best to include the
trailing slash when you're targetting a folder. If you want the folder \code{foo},
say \verb{foo/}, not \code{foo}.

Some functions, such as \code{\link[=drive_cp]{drive_cp()}}, \code{\link[=drive_mkdir]{drive_mkdir()}}, \code{\link[=drive_mv]{drive_mv()}}, and
\code{\link[=drive_upload]{drive_upload()}}, can accept the new file or folder name as the last part of
\code{path}, when \code{name} is not given. But if you say \code{a/b/c} (no trailing slash)
and a folder \verb{a/b/c/} already exists, it's unclear what you want. A file
named \code{c} in \verb{a/b/} or a file with default name in \verb{a/b/c/}? You get an
error and must make your intent clear.
}
\examples{
\dontshow{if (drive_has_token()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# create some files for us to re-discover by name or filepath
alfa <- drive_create("alfa", type = "folder")
bravo <- drive_create("bravo", path = alfa)

# as_dribble() can work with file names or paths
as_dribble("alfa")
as_dribble("bravo")
as_dribble("alfa/bravo")
as_dribble(c("alfa", "alfa/bravo"))

# specify the file id (substitute a real file id of your own!)
# as_dribble(as_id("0B0Gh-SuuA2nTOGZVTXZTREgwZ2M"))

# cleanup
drive_find("alfa") \%>\% drive_rm()
\dontshow{\}) # examplesIf}
}
