% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/position-jitter.r
\name{position_jitter}
\alias{position_jitter}
\title{Jitter points to avoid overplotting.}
\usage{
position_jitter(width = NULL, height = NULL)
}
\arguments{
\item{width, height}{Amount of vertical and horizontal jitter. The jitter
  is added in both positive and negative directions, so the total spread
  is twice the value specified here.

  If omitted, defaults to 40\% of the resolution of the data: this means the
  jitter values will occupy 80\% of the implied bins. Categorical data
  is aligned on the integers, so a width or height of 0.5 will spread the
  data so it's not possible to see the distinction between the categories.}
}
\description{
Jitter points to avoid overplotting.
}
\examples{
ggplot(mtcars, aes(am, vs)) + geom_point()

# Default amount of jittering will generally be too much for
# small datasets:
ggplot(mtcars, aes(am, vs)) + geom_jitter()

# Two ways to override
ggplot(mtcars, aes(am, vs)) +
  geom_jitter(width = 0.1, height = 0.1)
ggplot(mtcars, aes(am, vs)) +
  geom_jitter(position = position_jitter(width = 0.1, height = 0.1))

# The default works better for large datasets, where it will
# take up as much space as a boxplot or a bar
ggplot(mpg, aes(class, hwy)) +
  geom_jitter() +
  geom_boxplot()
}
\seealso{
Other position adjustments: \code{\link{position_dodge}},
  \code{\link{position_fill}},
  \code{\link{position_identity}},
  \code{\link{position_jitterdodge}},
  \code{\link{position_nudge}}
}

