% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth-app.R
\name{oauth_app_from_json}
\alias{oauth_app_from_json}
\title{Create an OAuth app from JSON}
\usage{
oauth_app_from_json(path, appname = NULL)
}
\arguments{
\item{path}{JSON downloaded from Google Cloud Platform Console, containing a
client id (aka key) and secret, in one of the forms supported for the \code{txt}
argument of \code{\link[jsonlite:fromJSON]{jsonlite::fromJSON()}} (typically, a file path or JSON string).}

\item{appname}{name of the application.  This is not used for OAuth, but is
used to make it easier to identify different applications.}
}
\description{
Essentially a wrapper around \code{\link[httr:oauth_app]{httr::oauth_app()}} that extracts the necessary
info from JSON obtained from \href{https://console.cloud.google.com}{Google Cloud Platform Console}. If no \code{appname} is given,
the \code{"project_id"} from the JSON is used.
}
\examples{
\dontrun{
oauth_app(
  path = "/path/to/the/JSON/you/downloaded/from/gcp/console.json"
)
}
}
