% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R
\name{tidy_rstudio}
\alias{tidy_rstudio}
\title{Reformat R code in RStudio IDE}
\usage{
tidy_rstudio(...)
}
\arguments{
\item{...}{Arguments to be passed to \code{\link{tidy_source}()}, among which
the \code{indent} argument will respect the value you set for the number of
spaces for indentation in RStudio.}
}
\description{
If any R code is selected in the RStudio source editor, this function
reformats the selected code; otherwise it reformats the current open file (if
it is unsaved, it will be automatically saved).
}
\note{
If the output is not what you want, you can undo the change in the
  editor (Ctrl + Z or Command + Z).
}
\examples{\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
formatR::tidy_rstudio()
formatR::tidy_rstudio(args.newline = TRUE)
\dontshow{\}) # examplesIf}
}
