% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_between_odds_to_probs.R
\name{odds_to_probs}
\alias{odds_to_probs}
\alias{convert_odds_to_probs}
\alias{odds_to_probs.data.frame}
\alias{probs_to_odds}
\alias{convert_probs_to_odds}
\alias{probs_to_odds.data.frame}
\title{Convert between Odds and Probabilities}
\usage{
odds_to_probs(odds, log = FALSE, ...)

\method{odds_to_probs}{data.frame}(odds, log = FALSE, select = NULL, exclude = NULL, ...)

probs_to_odds(probs, log = FALSE, ...)

\method{probs_to_odds}{data.frame}(probs, log = FALSE, select = NULL, exclude = NULL, ...)
}
\arguments{
\item{odds}{The \emph{Odds} (or \code{log(odds)} when \code{log = TRUE}) to convert.}

\item{log}{Take in or output log odds (such as in logistic models).}

\item{...}{Arguments passed to or from other methods.}

\item{select}{When a data frame is passed, character or list of of column
names to be transformed.}

\item{exclude}{When a data frame is passed, character or list of column names
to be excluded from transformation.}

\item{probs}{Probability values to convert.}
}
\value{
Converted index.
}
\description{
Convert between Odds and Probabilities
}
\examples{
odds_to_probs(3)
odds_to_probs(1.09, log = TRUE)

probs_to_odds(0.95)
probs_to_odds(0.95, log = TRUE)
}
\seealso{
\code{\link[stats:Logistic]{stats::plogis()}}

Other convert between effect sizes: 
\code{\link{d_to_cles}()},
\code{\link{d_to_r}()},
\code{\link{eta2_to_f2}()},
\code{\link{oddsratio_to_riskratio}()}
}
\concept{convert between effect sizes}
