% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/param_engine_lightgbm.R
\name{num_leaves}
\alias{num_leaves}
\title{Possible engine parameters for lightbgm}
\usage{
num_leaves(range = c(5, 100), trans = NULL)
}
\arguments{
\item{range}{A two-element vector holding the \emph{defaults} for the smallest and
largest possible values, respectively. If a transformation is specified,
these values should be in the \emph{transformed units}.}

\item{trans}{A \code{trans} object from the \code{scales} package, such as
\code{scales::log10_trans()} or \code{scales::reciprocal_trans()}. If not provided,
the default is used which matches the units used in \code{range}. If no
transformation, \code{NULL}.}
}
\description{
These parameters are auxiliary to tree-based models that use the "lightgbm"
engine. They correspond to tuning parameters that would be specified using
\code{set_engine("lightgbm", ...)}.
}
\details{
"lightbgm" is an available engine in the parsnip extension package \href{https://bonsai.tidymodels.org/}{bonsai}

For more information, see the \href{https://lightgbm.readthedocs.io/en/latest/Parameters.html}{lightgbm webpage}.
}
\examples{

num_leaves()

}
