% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verb-copy-to.R
\name{copy_inline}
\alias{copy_inline}
\title{Use a local data frame in a dbplyr query}
\usage{
copy_inline(con, df, types = NULL)
}
\arguments{
\item{con}{A database connection.}

\item{df}{A local data frame. The data is written directly in the SQL query
so it should be small.}

\item{types}{A named character vector of SQL data types to use for the columns.
The data types are backend specific. For example for Postgres this could
be \code{c(id = "bigint", created_at = "timestamp", values = "integer[]")}.
If \code{NULL}, the default, the types are determined from \code{df}.}
}
\value{
A \code{tbl_lazy}.
}
\description{
This is an alternative to \code{\link[dplyr:copy_to]{dplyr::copy_to()}} that does not need write access and
is faster for small data.
}
\details{
It writes the data directly in the SQL query via the \code{VALUES} clause.
}
\examples{
df <- data.frame(x = 1:3, y = c("a", "b", "c"))
con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")

copy_inline(con, df)

copy_inline(con, df) \%>\% dplyr::show_query()
}
\seealso{
\code{\link[dplyr:copy_to]{dplyr::copy_to()}} to copy the data into a new database table.
}
