% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-day.R
\name{year_day}
\alias{year_day}
\title{Calendar: year-day}
\usage{
year_day(
  year,
  day = NULL,
  hour = NULL,
  minute = NULL,
  second = NULL,
  subsecond = NULL,
  ...,
  subsecond_precision = NULL
)
}
\arguments{
\item{year}{\verb{[integer]}

The year. Values \verb{[-32767, 32767]} are generally allowed.}

\item{day}{\verb{[integer / NULL]}

The day of the year. Values \verb{[1, 366]} are allowed.}

\item{hour}{\verb{[integer / NULL]}

The hour. Values \verb{[0, 23]} are allowed.}

\item{minute}{\verb{[integer / NULL]}

The minute. Values \verb{[0, 59]} are allowed.}

\item{second}{\verb{[integer / NULL]}

The second. Values \verb{[0, 59]} are allowed.}

\item{subsecond}{\verb{[integer / NULL]}

The subsecond. If specified, \code{subsecond_precision} must also be specified
to determine how to interpret the \code{subsecond}.

If using milliseconds, values \verb{[0, 999]} are allowed.

If using microseconds, values \verb{[0, 999999]} are allowed.

If using nanoseconds, values \verb{[0, 999999999]} are allowed.}

\item{...}{These dots are for future extensions and must be empty.}

\item{subsecond_precision}{\verb{[character(1) / NULL]}

The precision to interpret \code{subsecond} as. One of: \code{"millisecond"},
\code{"microsecond"}, or \code{"nanosecond"}.}
}
\value{
A year-day calendar vector.
}
\description{
\code{year_day()} constructs a calendar vector from the Gregorian
year and day of the year.
}
\details{
Fields are recycled against each other using
\link[vctrs:vector_recycling_rules]{tidyverse recycling rules}.

Fields are collected in order until the first \code{NULL} field is located. No
fields after the first \code{NULL} field are used.
}
\examples{
# Just the year
x <- year_day(2019:2025)
x

year_day(2020, 1:10)

# Last day of the year, accounting for leap years
year_day(2019:2021, "last")

# Precision can go all the way out to nanosecond
year_day(2019, 100, 2, 40, 45, 200, subsecond_precision = "nanosecond")
}
