% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gregorian-year-month-day.R
\name{year-month-day-boundary}
\alias{year-month-day-boundary}
\alias{calendar_start.clock_year_month_day}
\alias{calendar_end.clock_year_month_day}
\title{Boundaries: year-month-day}
\usage{
\method{calendar_start}{clock_year_month_day}(x, precision)

\method{calendar_end}{clock_year_month_day}(x, precision)
}
\arguments{
\item{x}{\verb{[clock_year_month_day]}

A year-month-day vector.}

\item{precision}{\verb{[character(1)]}

One of:
\itemize{
\item \code{"year"}
\item \code{"month"}
\item \code{"day"}
\item \code{"hour"}
\item \code{"minute"}
\item \code{"second"}
\item \code{"millisecond"}
\item \code{"microsecond"}
\item \code{"nanosecond"}
}}
}
\value{
\code{x} at the same precision, but with some components altered to be
at the boundary value.
}
\description{
This is a year-month-day method for the \code{\link[=calendar_start]{calendar_start()}} and
\code{\link[=calendar_end]{calendar_end()}} generics. They adjust components of a calendar to the
start or end of a specified \code{precision}.
}
\examples{
# Hour precision
x <- year_month_day(2019, 2:4, 5, 6)
x

# Compute the start of the month
calendar_start(x, "month")

# Or the end of the month, notice that the hour value is adjusted as well
calendar_end(x, "month")

# Compare that with just setting the day of the month to `"last"`, which
# doesn't adjust any other components
set_day(x, "last")

# You can't compute the start / end at a more precise precision than
# the input is at
try(calendar_start(x, "second"))
}
