% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/339-extractDrugPetitjeanShapeIndex.R
\name{extractDrugPetitjeanShapeIndex}
\alias{extractDrugPetitjeanShapeIndex}
\title{Descriptor that Calculates the Petitjean Shape Indices}
\usage{
extractDrugPetitjeanShapeIndex(molecules, silent = TRUE)
}
\arguments{
\item{molecules}{Parsed molucule object.}

\item{silent}{Logical. Whether the calculating process
should be shown or not, default is \code{TRUE}.}
}
\value{
A data frame, each row represents one of the molecules,
each column represents one feature.
This function returns two columns named
\code{topoShape} (Topological Shape Index) and
\code{geomShape} (Geometric Shape Index).
}
\description{
Descriptor that Calculates the Petitjean Shape Indices
}
\details{
The topological and geometric shape indices described Petitjean
and Bath et al. respectively. Both measure the anisotropy in a molecule.
}
\examples{
sdf = system.file('sysdata/OptAA3d.sdf', package = 'Rcpi')
\donttest{
mol = readMolFromSDF(sdf)
dat = extractDrugPetitjeanShapeIndex(mol)
head(dat)}
}
\references{
Petitjean, M.,
Applications of the radius-diameter diagram to the classification of
topological and geometrical shapes of chemical compounds,
Journal of Chemical Information and Computer Science,
1992, 32:331-337

Bath, P.A. and Poirette, A.R. and Willet, P. and Allen, F.H. ,
The Extent of the Relationship between the Graph-Theoretical
and the Geometrical Shape Coefficients of Chemical Compounds,
Journal of Chemical Information and Computer Science, 1995, 35:714-716.
}
\author{
Nan Xiao <\url{https://nanx.me}>
}
\keyword{Geometric}
\keyword{Index}
\keyword{Petitjean}
\keyword{Shape}
\keyword{extractDrugPetitjeanShapeIndex}
