% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/enrichment.R
\name{plot_enrichment_heatmap}
\alias{plot_enrichment_heatmap}
\title{Heatmap of Feature Set Enrichment Analysis results}
\usage{
plot_enrichment_heatmap(
  enrichment.results,
  alpha = 0.1,
  cap = 1e-50,
  log_scale = TRUE,
  ...
)
}
\arguments{
\item{enrichment.results}{output of \link{run_enrichment} function}

\item{alpha}{FDR threshold to filter out unsignificant feature sets which are
not represented in the heatmap. Default is 0.10.}

\item{cap}{cap p-values below this threshold}

\item{log_scale}{logical indicating whether to plot the -log of the p.values.}

\item{...}{extra arguments to be passed to the \link{pheatmap} function}
}
\value{
produces a heatmap
}
\description{
This method generates a heatmap with the adjusted p.values that
 result from the the feature set enrichment analysis. Rows are feature sets and columns are factors.
}
