% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_mofa.R
\name{get_default_data_options}
\alias{get_default_data_options}
\title{Get default data options}
\usage{
get_default_data_options(object)
}
\arguments{
\item{object}{an untrained \code{\link{MOFA}} object}
}
\value{
Returns a list with the default data options.
}
\description{
Function to obtain the default data options.
}
\details{
This function provides a default set of data options that can be modified and passed to the \code{\link{MOFA}} object
in the \code{\link{prepare_mofa}} step (see example), i.e. after creating a \code{\link{MOFA}} object
 (using \code{\link{create_mofa}}) and before starting the training (using \code{\link{run_mofa}})
The data options are the following: \cr
\itemize{
 \item{\strong{scale_views}:}{ logical indicating whether to scale views to have the same unit variance. 
 As long as the scale differences between the views is not too high, this is not required. Default is FALSE.}
 \item{\strong{scale_groups}:}{ logical indicating whether to scale groups to have the same unit variance. 
 As long as the scale differences between the groups is not too high, this is not required. Default is FALSE.}
 \item{\strong{use_float32}:}{ logical indicating whether use float32 instead of float64 arrays to increase speed and memory usage. Default is FALSE.}
 }
}
\examples{
# Using an existing simulated data with two groups and two views
file <- system.file("extdata", "test_data.RData", package = "MOFA2")

# Load data dt (in data.frame format)
load(file) 

# Create the MOFA object
MOFAmodel <- create_mofa(dt)

# Load default data options
data_opts <- get_default_data_options(MOFAmodel)

# Edit some of the data options
data_opts$scale_views <- TRUE

# Prepare the MOFA object
MOFAmodel <- prepare_mofa(MOFAmodel, data_options = data_opts)
}
