\name{HOMO_SAPIENS}

\alias{ACYRTHOSIPHON_PISUM}
\alias{AEDES_AEGYPTI}
\alias{ANOPHELES_GAMBIAE}
\alias{APIS_MELLIFERA}
\alias{ARABIDOPSIS_THALIANA}
\alias{ASPERGILLUS_FUMIGATUS}
\alias{BATRACHOCHYTRIUM_DENDROBATIDIS}
\alias{BOMBYX_MORI}
\alias{BOS_TAURUS}
\alias{BRANCHIOSTOMA_FLORIDAE}
\alias{BRUGIA_MALAYI}
\alias{CAENORHABDITIS_BRENNERI}
\alias{CAENORHABDITIS_BRIGGSAE}
\alias{CAENORHABDITIS_ELEGANS}
\alias{CAENORHABDITIS_JAPONICA}
\alias{CAENORHABDITIS_REMANEI}
\alias{CANDIDA_ALBICANS}
\alias{CANDIDA_GLABRATA}
\alias{CANIS_FAMILIARIS}
\alias{CAPITELLA_SPI}
\alias{CAVIA_PORCELLUS}
\alias{CHLAMYDOMONAS_REINHARDTII}
\alias{CIONA_INTESTINALIS}
\alias{CIONA_SAVIGNYI}
\alias{COCCIDIOIDES_IMMITIS}
\alias{COPRINOPSIS_CINEREUS}
\alias{CRYPTOCOCCUS_NEOFORMANS}
\alias{CRYPTOSPORIDIUM_HOMINIS}
\alias{CRYPTOSPORIDIUM_PARVUM}
\alias{CULEX_PIPIENS}
\alias{CYANIDIOSCHYZON_MEROLAE}
\alias{DANIO_RERIO}
\alias{DAPHNIA_PULEX}
\alias{DEBARYOMYCES_HANSENII}
\alias{DICTYOSTELIUM_DISCOIDEUM}
\alias{DROSOPHILA_ANANASSAE}
\alias{DROSOPHILA_GRIMSHAWI}
\alias{DROSOPHILA_MELANOGASTER}
\alias{DROSOPHILA_MOJAVENSIS}
\alias{DROSOPHILA_PSEUDOOBSCURA}
\alias{DROSOPHILA_VIRILIS}
\alias{DROSOPHILA_WILLISTONI}
\alias{ENTAMOEBA_HISTOLYTICA}
\alias{EQUUS_CABALLUS}
\alias{ESCHERICHIA_COLIK12}
\alias{FUSARIUM_GRAMINEARUM}
\alias{GALLUS_GALLUS}
\alias{GASTEROSTEUS_ACULEATUS}
\alias{GIARDIA_LAMBLIA}
\alias{HELOBDELLA_ROBUSTA}
\alias{IXODES_SCAPULARIS}
\alias{KLUYVEROMYCES_LACTIS}
\alias{LEISHMANIA_MAJOR}
\alias{LOTTIA_GIGANTEA}
\alias{MACACA_MULATTA}
\alias{MAGNAPORTHE_GRISEA}
\alias{MONODELPHIS_DOMESTICA}
\alias{MONOSIGA_BREVICOLLIS}
\alias{MUS_MUSCULUS}
\alias{NASONIA_VITRIPENNIS}
\alias{NEMATOSTELLA_VECTENSIS}
\alias{NEUROSPORA_CRASSA}
\alias{ORNITHORHYNCHUS_ANATINUS}
\alias{ORYZA_SATIVA}
\alias{ORYZIAS_LATIPES}
\alias{OSTREOCOCCUS_TAURI}
\alias{PAN_TROGLODYTES}
\alias{PEDICULUS_HUMANUS}
\alias{PHYSCOMITRELLA_PATENS}
\alias{PHYTOPHTHORA_RAMORUM}
\alias{PHYTOPHTHORA_SOJAE}
\alias{PLASMODIUM_FALCIPARUM}
\alias{PLASMODIUM_VIVAX}
\alias{PONGO_PYGMAEUS}
\alias{POPULUS_TRICHOCARPA}
\alias{PRISTIONCHUS_PACIFICUS}
\alias{PUCCINIA_GRAMINIS}
\alias{RATTUS_NORVEGICUS}
\alias{RHIZOPUS_ORYZAE}
\alias{SACCHAROMYCES_CEREVISIAE}
\alias{SCHISTOSOMA_MANSONI}
\alias{SCHIZOSACCHAROMYCES_POMBE}
\alias{SCLEROTINIA_SCLEROTIORUM}
\alias{SORGHUM_BICOLOR}
\alias{STAGONOSPORA_NODORUM}
\alias{STRONGYLOCENTROTUS_PURPURATUS}
\alias{TAKIFUGU_RUBRIPES}
\alias{TETRAHYMENA_THERMOPHILA}
\alias{TETRAODON_NIGROVIRIDIS}
\alias{THALASSIOSIRA_PSEUDONANA}
\alias{THEILERIA_ANNULATA}
\alias{THEILERIA_PARVA}
\alias{TRIBOLIUM_CASTANEUM}
\alias{TRICHOMONAS_VAGINALIS}
\alias{TRICHOPLAX_ADHAERENS}
\alias{TRYPANOSOMA_CRUZI}
\alias{USTILAGO_MAYDIS}
\alias{XENOPUS_TROPICALIS}
\alias{YARROWIA_LIPOLYTICA}


\title{Descriptions of available values for \code{columns} and
  \code{keytypes} for inparanpoid packages.}


\description{
  When the user calls \code{columns} or \code{keytypes} for an inparanoid
  package, the \code{columns} and \code{keytypes} methods will give the
  full genus and species names of all the organisms that are available.
}


\details{
  
  All the possible values for \code{columns} and \code{keytypes} are listed
  below.
  
  \describe{
    \item{ACYRTHOSIPHON_PISUM:}{the pea aphid}
    \item{AEDES_AEGYPTI:}{a mosquito that can spread the dengue fever, Chikungunya and yellow fever viruses, and other diseases}
    \item{ANOPHELES_GAMBIAE:}{a mosquito notorious as a vector for malaria}
    \item{APIS_MELLIFERA:}{the western honey bee}
    \item{ARABIDOPSIS_THALIANA:}{the thale cress}
    \item{ASPERGILLUS_FUMIGATUS:}{a fungus that causes disease in
    immunodeficient individuals}
    \item{BATRACHOCHYTRIUM_DENDROBATIDIS:}{a chytrid fungus that causes the disease chytridiomycosis}
    \item{BOMBYX_MORI:}{the silk worm}
    \item{BOS_TAURUS:}{domestic cattle}
    \item{BRANCHIOSTOMA_FLORIDAE:}{a lancelet (amphioxus)}
    \item{BRUGIA_MALAYI:}{a nematode (roundworm), one of the three causative agents of lymphatic filariasis}
    \item{CAENORHABDITIS_BRENNERI:}{a small nematode, closely related to the model organism Caenorhabditis elegans}
    \item{CAENORHABDITIS_BRIGGSAE:}{a small nematode, closely related to Caenorhabditis elegans}
    \item{CAENORHABDITIS_ELEGANS:}{a small nematode}
    \item{CAENORHABDITIS_JAPONICA:}{a gonochoristic (male-female) species related to C. elegans}
    \item{CAENORHABDITIS_REMANEI:}{a species of nematode (gonochoristic)}
    \item{CANDIDA_ALBICANS:}{a diploid fungus that grows both as yeast and filamentous cells and a causal agent of opportunistic oral and genital infections in humans}
    \item{CANDIDA_GLABRATA:}{a haploid yeast of the genus Candida}
    \item{CANIS_FAMILIARIS:}{domestic dog}
    \item{CAPITELLA_SPI:}{a polychaete worm}
    \item{CAVIA_PORCELLUS:}{Guinea pig}
    \item{CHLAMYDOMONAS_REINHARDTII:}{a single celled green alga }
    \item{CIONA_INTESTINALIS:}{a urochordata (sea squirt), a tunicate widely distributed in Northern European waters}
    \item{CIONA_SAVIGNYI:}{a urochordata (sea squirt)}
    \item{COCCIDIOIDES_IMMITIS:}{a pathogenic fungus that resides in the soil}
    \item{COPRINOPSIS_CINEREUS:}{a species of mushroom}
    \item{CRYPTOCOCCUS_NEOFORMANS:}{an encapsulated yeast that can live in both plants and animals}
    \item{CRYPTOSPORIDIUM_HOMINIS:}{an obligate parasite of humans that can colonize the gastrointestinal tract}
    \item{CRYPTOSPORIDIUM_PARVUM:}{one of several protozoal species that cause cryptosporidiosis, a parasitic disease of the mammalian intestinal tract}
    \item{CULEX_PIPIENS:}{the common house mosquito}
    \item{CYANIDIOSCHYZON_MEROLAE:}{a an algae that is the main organism in red tide}
    \item{DANIO_RERIO:}{the zebrafish}
    \item{DAPHNIA_PULEX:}{the most common species of water flea}
    \item{DEBARYOMYCES_HANSENII:}{a yeast that tolerates high concentrations of salt and is related to yeasts that cause disease, including Candida albicans}
    \item{DICTYOSTELIUM_DISCOIDEUM:}{a species of soil-living amoeba,
    AKA a slime mold}
    \item{DROSOPHILA_ANANASSAE:}{a fruit fly}
    \item{DROSOPHILA_GRIMSHAWI:}{a fruit fly}
    \item{DROSOPHILA_MELANOGASTER:}{a fruit fly}
    \item{DROSOPHILA_MOJAVENSIS:}{a fruit fly}
    \item{DROSOPHILA_PSEUDOOBSCURA:}{a fruit fly}
    \item{DROSOPHILA_VIRILIS:}{a fruit fly}
    \item{DROSOPHILA_WILLISTONI:}{a fruit fly}
    \item{ENTAMOEBA_HISTOLYTICA:}{an anaerobic parasitic protozoan}
    \item{EQUUS_CABALLUS:}{domestic horse}
    \item{ESCHERICHIA_COLIK12:}{a laboratory strain of coliform bacteria}
    \item{FUSARIUM_GRAMINEARUM:}{a fungus that attacks cereal grains}
    \item{GALLUS_GALLUS:}{domsticated chicken}
    \item{GASTEROSTEUS_ACULEATUS:}{three spined stickleback fish}
    \item{GIARDIA_LAMBLIA:}{a flagellated protozoan parasite}
    \item{HELOBDELLA_ROBUSTA:}{a leech}
    \item{IXODES_SCAPULARIS:}{the black legged deer tick, a vector for
    lyme disease}
    \item{KLUYVEROMYCES_LACTIS:}{yeast commonly used for genetic studies}
    \item{LEISHMANIA_MAJOR:}{a species of Leishmania, associated with zoonotic cutaneous leishmaniasis}
    \item{LOTTIA_GIGANTEA:}{a species of sea snail, a true limpet, a marine gastropod mollusc}
    \item{MACACA_MULATTA:}{the rhesus Macaque}
    \item{MAGNAPORTHE_GRISEA:}{rice blast fungus}
    \item{MONODELPHIS_DOMESTICA:}{grey short tailed opossum}
    \item{MONOSIGA_BREVICOLLIS:}{a marine choanoflagellate}
    \item{MUS_MUSCULUS:}{lab mouse}
    \item{NASONIA_VITRIPENNIS:}{a small pteromalid parasitoid wasp}
    \item{NEMATOSTELLA_VECTENSIS:}{the starlet sea anemone}
    \item{NEUROSPORA_CRASSA:}{a type of red bread mould}
    \item{ORNITHORHYNCHUS_ANATINUS:}{the platypus}
    \item{ORYZA_SATIVA:}{rice}
    \item{ORYZIAS_LATIPES:}{medaka fish}
    \item{OSTREOCOCCUS_TAURI:}{a unicellular coccoid or spherically shaped green alga}
    \item{PAN_TROGLODYTES:}{chimp}
    \item{PEDICULUS_HUMANUS:}{a species of lice that infects humans}
    \item{PHYSCOMITRELLA_PATENS:}{a moss (Bryophyta) used as a model organism for studies on plant evolution}
    \item{PHYTOPHTHORA_RAMORUM:}{the oomycete plant pathogen (sudden oak
    death)}
    \item{PHYTOPHTHORA_SOJAE:}{an oomycete and a soil-borne plant pathogen that causes stem and root rot of soybean}
    \item{PLASMODIUM_FALCIPARUM:}{a protozoan parasite that causes malaria}
    \item{PLASMODIUM_VIVAX:}{a protozoal parasite and a human pathogen
    that causes a more benign malaria}
    \item{PONGO_PYGMAEUS:}{the Bornean orangutan}
    \item{POPULUS_TRICHOCARPA:}{black cottonwood; also known as western balsam poplar or California poplar}
    \item{PRISTIONCHUS_PACIFICUS:}{a diplogastrid nematode}
    \item{PUCCINIA_GRAMINIS:}{stem, black or cereal rusts}
    \item{RATTUS_NORVEGICUS:}{common lab rat}
    \item{RHIZOPUS_ORYZAE:}{a fungus that lives worldwide in dead organic matter. An opportunistic human pathogen}
    \item{SACCHAROMYCES_CEREVISIAE:}{brewers yeast}
    \item{SCHISTOSOMA_MANSONI:}{a significant parasite of humans, a trematode that is one of the major agents of the disease schistosomiasis}
    \item{SCHIZOSACCHAROMYCES_POMBE:}{fission yeast}
    \item{SCLEROTINIA_SCLEROTIORUM:}{an omnivorous fungal plant pathogen}
    \item{SORGHUM_BICOLOR:}{sorghum}
    \item{STAGONOSPORA_NODORUM:}{a fungal leaf spot disease}
    \item{STRONGYLOCENTROTUS_PURPURATUS:}{the purple sea urchin}
    \item{TAKIFUGU_RUBRIPES:}{Japanese pufferfish}
    \item{TETRAHYMENA_THERMOPHILA:}{a single celled cilliate}
    \item{TETRAODON_NIGROVIRIDIS:}{green spotted pufferfish (fresh water)}
    \item{THALASSIOSIRA_PSEUDONANA:}{a species of marine centric diatom}
    \item{THEILERIA_ANNULATA:}{a tickborne protozoan pathogen which is a major cause of livestock disease in sub-tropical regions}
    \item{THEILERIA_PARVA:}{a parasitic protozoan, that causes East Coast fever (theileriosis) in cattle}
    \item{TRIBOLIUM_CASTANEUM:}{the red flour beetle}
    \item{TRICHOMONAS_VAGINALIS:}{an anaerobic, flagellated protozoan}
    \item{TRICHOPLAX_ADHAERENS:}{Trichoplax adhaerens represents the simplest known animal, with the smallest known animal genome}
    \item{TRYPANOSOMA_CRUZI:}{a species of parasitic euglenoid trypanosomes. This species causes the trypanosomiasis diseases in humans and animals in America.}
    \item{USTILAGO_MAYDIS:}{a pathogenic plant fungus that causes smut disease on maize}
    \item{XENOPUS_TROPICALIS:}{Western clawed frog}
    \item{YARROWIA_LIPOLYTICA:}{Yarrowia lipolytica is a "non-conventional" species of yeast, often used in genetic research because it differs from other well-studied species}
 }


  To get the latest  information about the date stamps and source URLS
  for the data used to make an annotation package, please use the
  metadata method as shown in the example below.
  
}


\author{Marc Carlson}


\examples{
  library(hom.Hs.inp.db)
  ## List the possible values for columns
  columns(hom.Hs.inp.db)
  ## List the possible values for keytypes
  keytypes(hom.Hs.inp.db)
  ## get some values back
  keys <- head(keys(hom.Hs.inp.db, keytype="HOMO_SAPIENS"))
  keys
  select(hom.Hs.inp.db, keys=keys, columns=c("BOS_TAURUS","EQUUS_CABALLUS"),
  keytype="HOMO_SAPIENS")

  ## More infomation about the dates and original sources for these data:
  metadata(hom.Hs.inp.db)
}


\keyword{utilities}
\keyword{manip}
