#
# PySNMP MIB module HOST-RESOURCES-MIB (http://pysnmp.sf.net)
# ASN.1 source http://mibs.snmplabs.com:80/asn1/HOST-RESOURCES-MIB
# Produced by pysmi-0.0.7 at Sun Feb 14 00:12:48 2016
# On host bldfarm platform Linux version 4.1.13-100.fc21.x86_64 by user goose
# Using Python version 3.5.0 (default, Jan  5 2016, 17:11:52) 
#
( ObjectIdentifier, Integer, OctetString, ) = mibBuilder.importSymbols("ASN1", "ObjectIdentifier", "Integer", "OctetString")
( NamedValues, ) = mibBuilder.importSymbols("ASN1-ENUMERATION", "NamedValues")
( ConstraintsUnion, ValueRangeConstraint, SingleValueConstraint, ValueSizeConstraint, ConstraintsIntersection, ) = mibBuilder.importSymbols("ASN1-REFINEMENT", "ConstraintsUnion", "ValueRangeConstraint", "SingleValueConstraint", "ValueSizeConstraint", "ConstraintsIntersection")
( InterfaceIndexOrZero, ) = mibBuilder.importSymbols("IF-MIB", "InterfaceIndexOrZero")
( NotificationGroup, ModuleCompliance, ObjectGroup, ) = mibBuilder.importSymbols("SNMPv2-CONF", "NotificationGroup", "ModuleCompliance", "ObjectGroup")
( Bits, ModuleIdentity, Counter32, IpAddress, Unsigned32, MibIdentifier, ObjectIdentity, MibScalar, MibTable, MibTableRow, MibTableColumn, iso, mib_2, NotificationType, Counter64, TimeTicks, Gauge32, Integer32, ) = mibBuilder.importSymbols("SNMPv2-SMI", "Bits", "ModuleIdentity", "Counter32", "IpAddress", "Unsigned32", "MibIdentifier", "ObjectIdentity", "MibScalar", "MibTable", "MibTableRow", "MibTableColumn", "iso", "mib-2", "NotificationType", "Counter64", "TimeTicks", "Gauge32", "Integer32")
( TruthValue, AutonomousType, TextualConvention, DisplayString, DateAndTime, ) = mibBuilder.importSymbols("SNMPv2-TC", "TruthValue", "AutonomousType", "TextualConvention", "DisplayString", "DateAndTime")
hostResourcesMibModule = ModuleIdentity((1, 3, 6, 1, 2, 1, 25, 7, 1)).setRevisions(("2000-03-06 00:00", "1999-10-20 22:00",))
if mibBuilder.loadTexts: hostResourcesMibModule.setLastUpdated('200003060000Z')
if mibBuilder.loadTexts: hostResourcesMibModule.setOrganization('IETF Host Resources MIB Working Group')
if mibBuilder.loadTexts: hostResourcesMibModule.setContactInfo('Steve Waldbusser\n          Postal: Lucent Technologies, Inc.\n                  1213 Innsbruck Dr.\n                  Sunnyvale, CA 94089\n                  USA\n          Phone:  650-318-1251\n          Fax:    650-318-1633\n          Email:  waldbusser@lucent.com\n\n\n          In addition, the Host Resources MIB mailing list is\n          dedicated to discussion of this MIB. To join the\n          mailing list, send a request message to\n          hostmib-request@andrew.cmu.edu. The mailing list\n          address is hostmib@andrew.cmu.edu.')
if mibBuilder.loadTexts: hostResourcesMibModule.setDescription("This MIB is for use in managing host systems. The term\n          `host' is construed to mean any computer that communicates\n          with other similar computers attached to the internet and\n          that is directly used by one or more human beings. Although\n          this MIB does not necessarily apply to devices whose primary\n          function is communications services (e.g., terminal servers,\n          routers, bridges, monitoring equipment), such relevance is\n          not explicitly precluded.  This MIB instruments attributes\n          common to all internet hosts including, for example, both\n          personal computers and systems that run variants of Unix.")
host = MibIdentifier((1, 3, 6, 1, 2, 1, 25))
hrSystem = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 1))
hrStorage = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2))
hrDevice = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3))
hrSWRun = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 4))
hrSWRunPerf = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 5))
hrSWInstalled = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 6))
hrMIBAdminInfo = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7))
class KBytes(Integer32, TextualConvention):
    subtypeSpec = Integer32.subtypeSpec+ValueRangeConstraint(0,2147483647)

class ProductID(ObjectIdentifier, TextualConvention):
    pass

class InternationalDisplayString(OctetString, TextualConvention):
    pass

hrSystemUptime = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemUptime.setDescription('The amount of time since this host was last\n           initialized.  Note that this is different from\n           sysUpTime in the SNMPv2-MIB [RFC1907] because\n           sysUpTime is the uptime of the network management\n           portion of the system.')
hrSystemDate = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 2), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemDate.setDescription("The host's notion of the local date and time of day.")
hrSystemInitialLoadDevice = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 3), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadDevice.setDescription('The index of the hrDeviceEntry for the device from\n           which this host is configured to load its initial\n           operating system configuration (i.e., which operating\n           system code and/or boot parameters).\n\n           Note that writing to this object just changes the\n           configuration that will be used the next time the\n           operating system is loaded and does not actually cause\n           the reload to occur.')
hrSystemInitialLoadParameters = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSystemInitialLoadParameters.setDescription('This object contains the parameters (e.g. a pathname\n           and parameter) supplied to the load device when\n           requesting the initial operating system configuration\n           from that device.\n\n        Note that writing to this object just changes the\n        configuration that will be used the next time the\n        operating system is loaded and does not actually cause\n        the reload to occur.')
hrSystemNumUsers = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 5), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemNumUsers.setDescription('The number of user sessions for which this host is\n           storing state information.  A session is a collection\n           of processes requiring a single act of user\n           authentication and possibly subject to collective job\n           control.')
hrSystemProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 6), Gauge32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemProcesses.setDescription('The number of process contexts currently loaded or\n           running on this system.')
hrSystemMaxProcesses = MibScalar((1, 3, 6, 1, 2, 1, 25, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSystemMaxProcesses.setDescription('The maximum number of process contexts this system\n           can support.  If there is no fixed maximum, the value\n           should be zero.  On systems that have a fixed maximum,\n           this object can help diagnose failures that occur when\n           this maximum is reached.')
hrStorageTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 2, 1))
hrMemorySize = MibScalar((1, 3, 6, 1, 2, 1, 25, 2, 2), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrMemorySize.setDescription('The amount of physical read-write main memory,\n           typically RAM, contained by the host.')
hrStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 2, 3), )
if mibBuilder.loadTexts: hrStorageTable.setDescription("The (conceptual) table of logical storage areas on\n           the host.\n\n           An entry shall be placed in the storage table for each\n           logical area of storage that is allocated and has\n           fixed resource limits.  The amount of storage\n           represented in an entity is the amount actually usable\n           by the requesting entity, and excludes loss due to\n           formatting or file system reference information.\n\n           These entries are associated with logical storage\n           areas, as might be seen by an application, rather than\n           physical storage entities which are typically seen by\n           an operating system.  Storage such as tapes and\n           floppies without file systems on them are typically\n           not allocated in chunks by the operating system to\n           requesting applications, and therefore shouldn't\n           appear in this table.  Examples of valid storage for\n           this table include disk partitions, file systems, ram\n           (for some architectures this is further segmented into\n           regular memory, extended memory, and so on), backing\n           store for virtual memory (`swap space').\n\n           This table is intended to be a useful diagnostic for\n           `out of memory' and `out of buffers' types of\n           failures.  In addition, it can be a useful performance\n           monitoring tool for tracking memory, disk, or buffer\n           usage.")
hrStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 2, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrStorageIndex"))
if mibBuilder.loadTexts: hrStorageEntry.setDescription('A (conceptual) entry for one logical storage area on\n           the host.  As an example, an instance of the\n           hrStorageType object might be named hrStorageType.3')
hrStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageIndex.setDescription('A unique value for each logical storage area\n           contained by the host.')
hrStorageType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageType.setDescription('The type of storage represented by this entry.')
hrStorageDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 3), DisplayString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageDescr.setDescription('A description of the type and instance of the storage\n           described by this entry.')
hrStorageAllocationUnits = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 4), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setUnits('Bytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationUnits.setDescription('The size, in bytes, of the data objects allocated\n           from this pool.  If this entry is monitoring sectors,\n           blocks, buffers, or packets, for example, this number\n           will commonly be greater than one.  Otherwise this\n           number will typically be one.')
hrStorageSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrStorageSize.setDescription('The size of the storage represented by this entry, in\n           units of hrStorageAllocationUnits. This object is\n           writable to allow remote configuration of the size of\n           the storage area in those cases where such an\n           operation makes sense and is possible on the\n           underlying system. For example, the amount of main\n           memory allocated to a buffer pool might be modified or\n           the amount of disk space allocated to virtual memory\n           might be modified.')
hrStorageUsed = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 6), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageUsed.setDescription('The amount of the storage represented by this entry\n           that is allocated, in units of\n           hrStorageAllocationUnits.')
hrStorageAllocationFailures = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 2, 3, 1, 7), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrStorageAllocationFailures.setDescription('The number of requests for storage represented by\n           this entry that could not be honored due to not enough\n           storage.  It should be noted that as this object has a\n           SYNTAX of Counter32, that it does not have a defined\n           initial value.  However, it is recommended that this\n           object be initialized to zero, even though management\n           stations must not depend on such an initialization.')
hrDeviceTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 1))
hrDeviceTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 2), )
if mibBuilder.loadTexts: hrDeviceTable.setDescription('The (conceptual) table of devices contained by the\n           host.')
hrDeviceEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDeviceEntry.setDescription('A (conceptual) entry for one device contained by the\n           host.  As an example, an instance of the hrDeviceType\n           object might be named hrDeviceType.3')
hrDeviceIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceIndex.setDescription('A unique value for each device contained by the host.\n           The value for each device must remain constant at\n           least from one re-initialization of the agent to the\n           next re-initialization.')
hrDeviceType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 2), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceType.setDescription("An indication of the type of device.\n\n           If this value is\n           `hrDeviceProcessor { hrDeviceTypes 3 }' then an entry\n           exists in the hrProcessorTable which corresponds to\n           this device.\n\n           If this value is\n           `hrDeviceNetwork { hrDeviceTypes 4 }', then an entry\n           exists in the hrNetworkTable which corresponds to this\n           device.\n\n           If this value is\n           `hrDevicePrinter { hrDeviceTypes 5 }', then an entry\n           exists in the hrPrinterTable which corresponds to this\n           device.\n\n           If this value is\n           `hrDeviceDiskStorage { hrDeviceTypes 6 }', then an\n           entry exists in the hrDiskStorageTable which\n           corresponds to this device.")
hrDeviceDescr = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 3), DisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceDescr.setDescription("A textual description of this device, including the\n           device's manufacturer and revision, and optionally,\n           its serial number.")
hrDeviceID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 4), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceID.setDescription('The product ID for this device.')
hrDeviceStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("unknown", 1), ("running", 2), ("warning", 3), ("testing", 4), ("down", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceStatus.setDescription("The current operational state of the device described\n           by this row of the table.  A value unknown(1)\n           indicates that the current state of the device is\n           unknown.  running(2) indicates that the device is up\n           and running and that no unusual error conditions are\n           known.  The warning(3) state indicates that agent has\n           been informed of an unusual error condition by the\n           operational software (e.g., a disk device driver) but\n           that the device is still 'operational'.  An example\n           would be a high number of soft errors on a disk.  A\n           value of testing(4), indicates that the device is not\n           available for use because it is in the testing state.\n           The state of down(5) is used only when the agent has\n           been informed that the device is not available for any\n           use.")
hrDeviceErrors = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 2, 1, 6), Counter32()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDeviceErrors.setDescription('The number of errors detected on this device.  It\n           should be noted that as this object has a SYNTAX of\n           Counter32, that it does not have a defined initial\n           value.  However, it is recommended that this object be\n           initialized to zero, even though management stations\n           must not depend on such an initialization.')
hrProcessorTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 3), )
if mibBuilder.loadTexts: hrProcessorTable.setDescription("The (conceptual) table of processors contained by the\n           host.\n\n           Note that this table is potentially sparse: a\n           (conceptual) entry exists only if the correspondent\n           value of the hrDeviceType object is\n           `hrDeviceProcessor'.")
hrProcessorEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrProcessorEntry.setDescription('A (conceptual) entry for one processor contained by\n           the host.  The hrDeviceIndex in the index represents\n           the entry in the hrDeviceTable that corresponds to the\n           hrProcessorEntry.\n\n           As an example of how objects in this table are named,\n           an instance of the hrProcessorFrwID object might be\n           named hrProcessorFrwID.3')
hrProcessorFrwID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 1), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorFrwID.setDescription('The product ID of the firmware associated with the\n           processor.')
hrProcessorLoad = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 3, 1, 2), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,100))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrProcessorLoad.setDescription('The average, over the last minute, of the percentage\n           of time that this processor was not idle.\n           Implementations may approximate this one minute\n           smoothing period if necessary.')
hrNetworkTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 4), )
if mibBuilder.loadTexts: hrNetworkTable.setDescription("The (conceptual) table of network devices contained\n           by the host.\n\n\n           Note that this table is potentially sparse: a\n           (conceptual) entry exists only if the correspondent\n           value of the hrDeviceType object is\n           `hrDeviceNetwork'.")
hrNetworkEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 4, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrNetworkEntry.setDescription('A (conceptual) entry for one network device contained\n           by the host.  The hrDeviceIndex in the index\n           represents the entry in the hrDeviceTable that\n           corresponds to the hrNetworkEntry.\n\n           As an example of how objects in this table are named,\n           an instance of the hrNetworkIfIndex object might be\n           named hrNetworkIfIndex.3')
hrNetworkIfIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 4, 1, 1), InterfaceIndexOrZero()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrNetworkIfIndex.setDescription('The value of ifIndex which corresponds to this\n           network device. If this device is not represented in\n           the ifTable, then this value shall be zero.')
hrPrinterTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 5), )
if mibBuilder.loadTexts: hrPrinterTable.setDescription("The (conceptual) table of printers local to the host.\n\n           Note that this table is potentially sparse: a\n           (conceptual) entry exists only if the correspondent\n           value of the hrDeviceType object is\n           `hrDevicePrinter'.")
hrPrinterEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 5, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrPrinterEntry.setDescription('A (conceptual) entry for one printer local to the\n           host.  The hrDeviceIndex in the index represents the\n           entry in the hrDeviceTable that corresponds to the\n           hrPrinterEntry.\n\n           As an example of how objects in this table are named,\n           an instance of the hrPrinterStatus object might be\n           named hrPrinterStatus.3')
hrPrinterStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5,))).clone(namedValues=NamedValues(("other", 1), ("unknown", 2), ("idle", 3), ("printing", 4), ("warmup", 5),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterStatus.setDescription('The current status of this printer device.')
hrPrinterDetectedErrorState = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 5, 1, 2), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPrinterDetectedErrorState.setDescription('This object represents any error conditions detected\n           by the printer.  The error conditions are encoded as\n           bits in an octet string, with the following\n           definitions:\n\n                Condition         Bit #\n\n                lowPaper              0\n\n\n                noPaper               1\n                lowToner              2\n                noToner               3\n                doorOpen              4\n                jammed                5\n                offline               6\n                serviceRequested      7\n                inputTrayMissing      8\n                outputTrayMissing     9\n                markerSupplyMissing  10\n                outputNearFull       11\n                outputFull           12\n                inputTrayEmpty       13\n                overduePreventMaint  14\n\n           Bits are numbered starting with the most significant\n           bit of the first byte being bit 0, the least\n           significant bit of the first byte being bit 7, the\n           most significant bit of the second byte being bit 8,\n           and so on.  A one bit encodes that the condition was\n           detected, while a zero bit encodes that the condition\n           was not detected.\n\n           This object is useful for alerting an operator to\n           specific warning or error conditions that may occur,\n           especially those requiring human intervention.')
hrDiskStorageTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 6), )
if mibBuilder.loadTexts: hrDiskStorageTable.setDescription("The (conceptual) table of long-term storage devices\n           contained by the host.  In particular, disk devices\n           accessed remotely over a network are not included\n           here.\n\n           Note that this table is potentially sparse: a\n           (conceptual) entry exists only if the correspondent\n           value of the hrDeviceType object is\n           `hrDeviceDiskStorage'.")
hrDiskStorageEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 6, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"))
if mibBuilder.loadTexts: hrDiskStorageEntry.setDescription('A (conceptual) entry for one long-term storage device\n           contained by the host.  The hrDeviceIndex in the index\n           represents the entry in the hrDeviceTable that\n           corresponds to the hrDiskStorageEntry. As an example,\n           an instance of the hrDiskStorageCapacity object might\n           be named hrDiskStorageCapacity.3')
hrDiskStorageAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 1), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageAccess.setDescription('An indication if this long-term storage device is\n           readable and writable or only readable.  This should\n           reflect the media type, any write-protect mechanism,\n           and any device configuration that affects the entire\n           device.')
hrDiskStorageMedia = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 2), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4, 5, 6, 7, 8,))).clone(namedValues=NamedValues(("other", 1), ("unknown", 2), ("hardDisk", 3), ("floppyDisk", 4), ("opticalDiskROM", 5), ("opticalDiskWORM", 6), ("opticalDiskRW", 7), ("ramDisk", 8),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageMedia.setDescription('An indication of the type of media used in this long-\n           term storage device.')
hrDiskStorageRemoveble = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 3), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageRemoveble.setDescription('Denotes whether or not the disk media may be removed\n           from the drive.')
hrDiskStorageCapacity = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 6, 1, 4), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrDiskStorageCapacity.setDescription('The total size for this long-term storage device. If\n           the media is removable and is currently removed, this\n           value should be zero.')
hrPartitionTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 7), )
if mibBuilder.loadTexts: hrPartitionTable.setDescription('The (conceptual) table of partitions for long-term\n           storage devices contained by the host.  In particular,\n           partitions accessed remotely over a network are not\n           included here.')
hrPartitionEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 7, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrDeviceIndex"), (0, "HOST-RESOURCES-MIB", "hrPartitionIndex"))
if mibBuilder.loadTexts: hrPartitionEntry.setDescription('A (conceptual) entry for one partition.  The\n           hrDeviceIndex in the index represents the entry in the\n           hrDeviceTable that corresponds to the\n           hrPartitionEntry.\n\n           As an example of how objects in this table are named,\n           an instance of the hrPartitionSize object might be\n           named hrPartitionSize.3.1')
hrPartitionIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionIndex.setDescription('A unique value for each partition on this long-term\n           storage device.  The value for each long-term storage\n           device must remain constant at least from one re-\n           initialization of the agent to the next re-\n           initialization.')
hrPartitionLabel = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionLabel.setDescription('A textual description of this partition.')
hrPartitionID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 3), OctetString()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionID.setDescription('A descriptor which uniquely represents this partition\n           to the responsible operating system.  On some systems,\n           this might take on a binary representation.')
hrPartitionSize = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 4), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionSize.setDescription('The size of this partition.')
hrPartitionFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 7, 1, 5), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrPartitionFSIndex.setDescription('The index of the file system mounted on this\n           partition.  If no file system is mounted on this\n           partition, then this value shall be zero.  Note that\n           multiple partitions may point to one file system,\n           denoting that that file system resides on those\n           partitions.  Multiple file systems may not reside on\n           one partition.')
hrFSTypes = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 3, 9))
hrFSTable = MibTable((1, 3, 6, 1, 2, 1, 25, 3, 8), )
if mibBuilder.loadTexts: hrFSTable.setDescription("The (conceptual) table of file systems local to this\n           host or remotely mounted from a file server.  File\n           systems that are in only one user's environment on a\n           multi-user system will not be included in this table.")
hrFSEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 3, 8, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrFSIndex"))
if mibBuilder.loadTexts: hrFSEntry.setDescription("A (conceptual) entry for one file system local to\n           this host or remotely mounted from a file server.\n           File systems that are in only one user's environment\n           on a multi-user system will not be included in this\n           table.\n\n           As an example of how objects in this table are named,\n           an instance of the hrFSMountPoint object might be\n           named hrFSMountPoint.3")
hrFSIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSIndex.setDescription('A unique value for each file system local to this\n           host.  The value for each file system must remain\n           constant at least from one re-initialization of the\n           agent to the next re-initialization.')
hrFSMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSMountPoint.setDescription('The path name of the root of this file system.')
hrFSRemoteMountPoint = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 3), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSRemoteMountPoint.setDescription('A description of the name and/or address of the\n           server that this file system is mounted from.  This\n           may also include parameters such as the mount point on\n           the remote file system.  If this is not a remote file\n           system, this string should have a length of zero.')
hrFSType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 4), AutonomousType()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSType.setDescription('The value of this object identifies the type of this\n           file system.')
hrFSAccess = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 5), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2,))).clone(namedValues=NamedValues(("readWrite", 1), ("readOnly", 2),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSAccess.setDescription('An indication if this file system is logically\n           configured by the operating system to be readable and\n           writable or only readable.  This does not represent\n           any local access-control policy, except one that is\n           applied to the file system as a whole.')
hrFSBootable = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 6), TruthValue()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSBootable.setDescription('A flag indicating whether this file system is\n           bootable.')
hrFSStorageIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 7), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrFSStorageIndex.setDescription('The index of the hrStorageEntry that represents\n           information about this file system.  If there is no\n           such information available, then this value shall be\n           zero.  The relevant storage entry will be useful in\n           tracking the percent usage of this file system and\n           diagnosing errors that may occur when it runs out of\n           space.')
hrFSLastFullBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 8), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastFullBackupDate.setDescription("The last date at which this complete file system was\n\n\n           copied to another storage device for backup.  This\n           information is useful for ensuring that backups are\n           being performed regularly.\n\n           If this information is not known, then this variable\n           shall have the value corresponding to January 1, year\n           0000, 00:00:00.0, which is encoded as\n           (hex)'00 00 01 01 00 00 00 00'.")
hrFSLastPartialBackupDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 3, 8, 1, 9), DateAndTime()).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrFSLastPartialBackupDate.setDescription("The last date at which a portion of this file system\n           was copied to another storage device for backup.  This\n           information is useful for ensuring that backups are\n           being performed regularly.\n\n           If this information is not known, then this variable\n           shall have the value corresponding to January 1, year\n           0000, 00:00:00.0, which is encoded as\n           (hex)'00 00 01 01 00 00 00 00'.")
hrSWOSIndex = MibScalar((1, 3, 6, 1, 2, 1, 25, 4, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWOSIndex.setDescription('The value of the hrSWRunIndex for the hrSWRunEntry\n           that represents the primary operating system running\n           on this host.  This object is useful for quickly and\n           uniquely identifying that primary operating system.')
hrSWRunTable = MibTable((1, 3, 6, 1, 2, 1, 25, 4, 2), )
if mibBuilder.loadTexts: hrSWRunTable.setDescription('The (conceptual) table of software running on the\n           host.')
hrSWRunEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 4, 2, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWRunIndex"))
if mibBuilder.loadTexts: hrSWRunEntry.setDescription('A (conceptual) entry for one piece of software\n           running on the host Note that because the installed\n           software table only contains information for software\n           stored locally on this host, not every piece of\n           running software will be found in the installed\n           software table.  This is true of software that was\n           loaded and run from a non-local source, such as a\n           network-mounted file system.\n\n           As an example of how objects in this table are named,\n           an instance of the hrSWRunName object might be named\n           hrSWRunName.1287')
hrSWRunIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunIndex.setDescription("A unique value for each piece of software running on\n           the host.  Wherever possible, this should be the\n           system's native, unique identification number.")
hrSWRunName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunName.setDescription('A textual description of this running piece of\n           software, including the manufacturer, revision,  and\n           the name by which it is commonly known.  If this\n           software was installed locally, this should be the\n           same string as used in the corresponding\n           hrSWInstalledName.')
hrSWRunID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunID.setDescription('The product ID of this running piece of software.')
hrSWRunPath = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 4), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPath.setDescription('A description of the location on long-term storage\n           (e.g. a disk drive) from which this software was\n           loaded.')
hrSWRunParameters = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 5), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,128))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunParameters.setDescription('A description of the parameters supplied to this\n           software when it was initially loaded.')
hrSWRunType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 6), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunType.setDescription('The type of this software.')
hrSWRunStatus = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 4, 2, 1, 7), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("running", 1), ("runnable", 2), ("notRunnable", 3), ("invalid", 4),))).setMaxAccess("readwrite")
if mibBuilder.loadTexts: hrSWRunStatus.setDescription('The status of this running piece of software.\n           Setting this value to invalid(4) shall cause this\n           software to stop running and to be unloaded. Sets to\n           other values are not valid.')
hrSWRunPerfTable = MibTable((1, 3, 6, 1, 2, 1, 25, 5, 1), )
if mibBuilder.loadTexts: hrSWRunPerfTable.setDescription('The (conceptual) table of running software\n           performance metrics.')
hrSWRunPerfEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 5, 1, 1), )
hrSWRunEntry.registerAugmentions(("HOST-RESOURCES-MIB", "hrSWRunPerfEntry"))
hrSWRunPerfEntry.setIndexNames(*hrSWRunEntry.getIndexNames())
if mibBuilder.loadTexts: hrSWRunPerfEntry.setDescription('A (conceptual) entry containing software performance\n           metrics.  As an example, an instance of the\n           hrSWRunPerfCPU object might be named\n           hrSWRunPerfCPU.1287')
hrSWRunPerfCPU = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(0,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfCPU.setDescription("The number of centi-seconds of the total system's CPU\n           resources consumed by this process.  Note that on a\n           multi-processor system, this value may increment by\n           more than one centi-second in one centi-second of real\n           (wall clock) time.")
hrSWRunPerfMem = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 5, 1, 1, 2), KBytes()).setUnits('KBytes').setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWRunPerfMem.setDescription('The total amount of real system memory allocated to\n           this process.')
hrSWInstalledLastChange = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 1), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastChange.setDescription('The value of sysUpTime when an entry in the\n           hrSWInstalledTable was last added, renamed, or\n           deleted.  Because this table is likely to contain many\n           entries, polling of this object allows a management\n           station to determine when re-downloading of the table\n           might be useful.')
hrSWInstalledLastUpdateTime = MibScalar((1, 3, 6, 1, 2, 1, 25, 6, 2), TimeTicks()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledLastUpdateTime.setDescription('The value of sysUpTime when the hrSWInstalledTable\n           was last completely updated.  Because caching of this\n           data will be a popular implementation strategy,\n           retrieval of this object allows a management station\n           to obtain a guarantee that no data in this table is\n           older than the indicated time.')
hrSWInstalledTable = MibTable((1, 3, 6, 1, 2, 1, 25, 6, 3), )
if mibBuilder.loadTexts: hrSWInstalledTable.setDescription('The (conceptual) table of software installed on this\n           host.')
hrSWInstalledEntry = MibTableRow((1, 3, 6, 1, 2, 1, 25, 6, 3, 1), ).setIndexNames((0, "HOST-RESOURCES-MIB", "hrSWInstalledIndex"))
if mibBuilder.loadTexts: hrSWInstalledEntry.setDescription('A (conceptual) entry for a piece of software\n           installed on this host.\n\n           As an example of how objects in this table are named,\n           an instance of the hrSWInstalledName object might be\n           named hrSWInstalledName.96')
hrSWInstalledIndex = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 1), Integer32().subtype(subtypeSpec=ValueRangeConstraint(1,2147483647))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledIndex.setDescription('A unique value for each piece of software installed\n           on the host.  This value shall be in the range from 1\n           to the number of pieces of software installed on the\n           host.')
hrSWInstalledName = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 2), InternationalDisplayString().subtype(subtypeSpec=ValueSizeConstraint(0,64))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledName.setDescription('A textual description of this installed piece of\n           software, including the manufacturer, revision, the\n           name by which it is commonly known, and optionally,\n           its serial number.')
hrSWInstalledID = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 3), ProductID()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledID.setDescription('The product ID of this installed piece of software.')
hrSWInstalledType = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 4), Integer32().subtype(subtypeSpec=ConstraintsUnion(SingleValueConstraint(1, 2, 3, 4,))).clone(namedValues=NamedValues(("unknown", 1), ("operatingSystem", 2), ("deviceDriver", 3), ("application", 4),))).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledType.setDescription('The type of this software.')
hrSWInstalledDate = MibTableColumn((1, 3, 6, 1, 2, 1, 25, 6, 3, 1, 5), DateAndTime()).setMaxAccess("readonly")
if mibBuilder.loadTexts: hrSWInstalledDate.setDescription("The last-modification date of this application as it\n           would appear in a directory listing.\n\n           If this information is not known, then this variable\n           shall have the value corresponding to January 1, year\n           0000, 00:00:00.0, which is encoded as\n           (hex)'00 00 01 01 00 00 00 00'.")
hrMIBCompliances = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 2))
hrMIBGroups = MibIdentifier((1, 3, 6, 1, 2, 1, 25, 7, 3))
hrMIBCompliance = ModuleCompliance((1, 3, 6, 1, 2, 1, 25, 7, 2, 1)).setObjects(*(("HOST-RESOURCES-MIB", "hrSystemGroup"), ("HOST-RESOURCES-MIB", "hrStorageGroup"), ("HOST-RESOURCES-MIB", "hrDeviceGroup"),))
if mibBuilder.loadTexts: hrMIBCompliance.setDescription('The requirements for conformance to the Host Resources MIB.')
hrSystemGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 1)).setObjects(*(("HOST-RESOURCES-MIB", "hrSystemUptime"), ("HOST-RESOURCES-MIB", "hrSystemDate"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadDevice"), ("HOST-RESOURCES-MIB", "hrSystemInitialLoadParameters"), ("HOST-RESOURCES-MIB", "hrSystemNumUsers"), ("HOST-RESOURCES-MIB", "hrSystemProcesses"), ("HOST-RESOURCES-MIB", "hrSystemMaxProcesses"),))
if mibBuilder.loadTexts: hrSystemGroup.setDescription('The Host Resources System Group.')
hrStorageGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 2)).setObjects(*(("HOST-RESOURCES-MIB", "hrMemorySize"), ("HOST-RESOURCES-MIB", "hrStorageIndex"), ("HOST-RESOURCES-MIB", "hrStorageType"), ("HOST-RESOURCES-MIB", "hrStorageDescr"), ("HOST-RESOURCES-MIB", "hrStorageAllocationUnits"), ("HOST-RESOURCES-MIB", "hrStorageSize"), ("HOST-RESOURCES-MIB", "hrStorageUsed"), ("HOST-RESOURCES-MIB", "hrStorageAllocationFailures"),))
if mibBuilder.loadTexts: hrStorageGroup.setDescription('The Host Resources Storage Group.')
hrDeviceGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 3)).setObjects(*(("HOST-RESOURCES-MIB", "hrDeviceIndex"), ("HOST-RESOURCES-MIB", "hrDeviceType"), ("HOST-RESOURCES-MIB", "hrDeviceDescr"), ("HOST-RESOURCES-MIB", "hrDeviceID"), ("HOST-RESOURCES-MIB", "hrDeviceStatus"), ("HOST-RESOURCES-MIB", "hrDeviceErrors"), ("HOST-RESOURCES-MIB", "hrProcessorFrwID"), ("HOST-RESOURCES-MIB", "hrProcessorLoad"), ("HOST-RESOURCES-MIB", "hrNetworkIfIndex"), ("HOST-RESOURCES-MIB", "hrPrinterStatus"), ("HOST-RESOURCES-MIB", "hrPrinterDetectedErrorState"), ("HOST-RESOURCES-MIB", "hrDiskStorageAccess"), ("HOST-RESOURCES-MIB", "hrDiskStorageMedia"), ("HOST-RESOURCES-MIB", "hrDiskStorageRemoveble"), ("HOST-RESOURCES-MIB", "hrDiskStorageCapacity"), ("HOST-RESOURCES-MIB", "hrPartitionIndex"), ("HOST-RESOURCES-MIB", "hrPartitionLabel"), ("HOST-RESOURCES-MIB", "hrPartitionID"), ("HOST-RESOURCES-MIB", "hrPartitionSize"), ("HOST-RESOURCES-MIB", "hrPartitionFSIndex"), ("HOST-RESOURCES-MIB", "hrFSIndex"), ("HOST-RESOURCES-MIB", "hrFSMountPoint"), ("HOST-RESOURCES-MIB", "hrFSRemoteMountPoint"), ("HOST-RESOURCES-MIB", "hrFSType"), ("HOST-RESOURCES-MIB", "hrFSAccess"), ("HOST-RESOURCES-MIB", "hrFSBootable"), ("HOST-RESOURCES-MIB", "hrFSStorageIndex"), ("HOST-RESOURCES-MIB", "hrFSLastFullBackupDate"), ("HOST-RESOURCES-MIB", "hrFSLastPartialBackupDate"),))
if mibBuilder.loadTexts: hrDeviceGroup.setDescription('The Host Resources Device Group.')
hrSWRunGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 4)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWOSIndex"), ("HOST-RESOURCES-MIB", "hrSWRunIndex"), ("HOST-RESOURCES-MIB", "hrSWRunName"), ("HOST-RESOURCES-MIB", "hrSWRunID"), ("HOST-RESOURCES-MIB", "hrSWRunPath"), ("HOST-RESOURCES-MIB", "hrSWRunParameters"), ("HOST-RESOURCES-MIB", "hrSWRunType"), ("HOST-RESOURCES-MIB", "hrSWRunStatus"),))
if mibBuilder.loadTexts: hrSWRunGroup.setDescription('The Host Resources Running Software Group.')
hrSWRunPerfGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 5)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWRunPerfCPU"), ("HOST-RESOURCES-MIB", "hrSWRunPerfMem"),))
if mibBuilder.loadTexts: hrSWRunPerfGroup.setDescription('The Host Resources Running Software\n               Performance Group.')
hrSWInstalledGroup = ObjectGroup((1, 3, 6, 1, 2, 1, 25, 7, 3, 6)).setObjects(*(("HOST-RESOURCES-MIB", "hrSWInstalledLastChange"), ("HOST-RESOURCES-MIB", "hrSWInstalledLastUpdateTime"), ("HOST-RESOURCES-MIB", "hrSWInstalledIndex"), ("HOST-RESOURCES-MIB", "hrSWInstalledName"), ("HOST-RESOURCES-MIB", "hrSWInstalledID"), ("HOST-RESOURCES-MIB", "hrSWInstalledType"), ("HOST-RESOURCES-MIB", "hrSWInstalledDate"),))
if mibBuilder.loadTexts: hrSWInstalledGroup.setDescription('The Host Resources Installed Software Group.')
mibBuilder.exportSymbols("HOST-RESOURCES-MIB", hrProcessorEntry=hrProcessorEntry, hrDeviceEntry=hrDeviceEntry, hrSWRunPerfTable=hrSWRunPerfTable, hrSWRunPerfGroup=hrSWRunPerfGroup, hrMIBCompliances=hrMIBCompliances, hrDiskStorageEntry=hrDiskStorageEntry, hrStorageIndex=hrStorageIndex, hrSWRunPerfMem=hrSWRunPerfMem, hrDeviceIndex=hrDeviceIndex, hrFSTypes=hrFSTypes, hrSystemNumUsers=hrSystemNumUsers, hrSystemGroup=hrSystemGroup, hrSWRunPerfCPU=hrSWRunPerfCPU, hrPrinterEntry=hrPrinterEntry, hrMemorySize=hrMemorySize, hrDeviceStatus=hrDeviceStatus, hrStorageAllocationUnits=hrStorageAllocationUnits, hrFSIndex=hrFSIndex, hrDiskStorageAccess=hrDiskStorageAccess, hrDiskStorageCapacity=hrDiskStorageCapacity, hrSystemProcesses=hrSystemProcesses, hrDeviceType=hrDeviceType, hrSWRunEntry=hrSWRunEntry, hrStorageType=hrStorageType, hrStorageSize=hrStorageSize, hrSystemDate=hrSystemDate, hrSystemUptime=hrSystemUptime, hrDeviceTypes=hrDeviceTypes, PYSNMP_MODULE_ID=hostResourcesMibModule, hrDevice=hrDevice, hrNetworkEntry=hrNetworkEntry, hrSWInstalledEntry=hrSWInstalledEntry, hrSWInstalledGroup=hrSWInstalledGroup, hrPartitionFSIndex=hrPartitionFSIndex, hrStorageEntry=hrStorageEntry, hrStorageTable=hrStorageTable, hrSWInstalledType=hrSWInstalledType, hrStorageUsed=hrStorageUsed, hostResourcesMibModule=hostResourcesMibModule, hrSWRunName=hrSWRunName, hrSystem=hrSystem, hrFSLastPartialBackupDate=hrFSLastPartialBackupDate, hrSystemInitialLoadDevice=hrSystemInitialLoadDevice, hrSystemMaxProcesses=hrSystemMaxProcesses, hrSWRunTable=hrSWRunTable, hrSWInstalledDate=hrSWInstalledDate, hrPartitionTable=hrPartitionTable, hrProcessorFrwID=hrProcessorFrwID, hrDiskStorageTable=hrDiskStorageTable, hrSWRun=hrSWRun, hrSWRunGroup=hrSWRunGroup, hrSWRunPerf=hrSWRunPerf, hrNetworkIfIndex=hrNetworkIfIndex, hrSWInstalledIndex=hrSWInstalledIndex, hrFSBootable=hrFSBootable, host=host, hrPrinterDetectedErrorState=hrPrinterDetectedErrorState, hrStorageDescr=hrStorageDescr, hrDeviceDescr=hrDeviceDescr, hrSWInstalledLastUpdateTime=hrSWInstalledLastUpdateTime, ProductID=ProductID, hrMIBAdminInfo=hrMIBAdminInfo, hrFSTable=hrFSTable, hrSWInstalledTable=hrSWInstalledTable, hrDeviceErrors=hrDeviceErrors, hrFSRemoteMountPoint=hrFSRemoteMountPoint, hrFSEntry=hrFSEntry, hrFSLastFullBackupDate=hrFSLastFullBackupDate, hrPartitionLabel=hrPartitionLabel, hrMIBCompliance=hrMIBCompliance, hrFSMountPoint=hrFSMountPoint, hrDeviceID=hrDeviceID, hrStorageAllocationFailures=hrStorageAllocationFailures, hrNetworkTable=hrNetworkTable, hrSWInstalled=hrSWInstalled, hrDeviceTable=hrDeviceTable, hrSWRunPerfEntry=hrSWRunPerfEntry, hrFSType=hrFSType, InternationalDisplayString=InternationalDisplayString, hrProcessorTable=hrProcessorTable, hrFSStorageIndex=hrFSStorageIndex, KBytes=KBytes, hrPartitionEntry=hrPartitionEntry, hrSWInstalledName=hrSWInstalledName, hrSWRunIndex=hrSWRunIndex, hrProcessorLoad=hrProcessorLoad, hrSWRunType=hrSWRunType, hrSWRunID=hrSWRunID, hrStorageTypes=hrStorageTypes, hrPrinterTable=hrPrinterTable, hrStorageGroup=hrStorageGroup, hrSWInstalledID=hrSWInstalledID, hrSWRunPath=hrSWRunPath, hrFSAccess=hrFSAccess, hrSWOSIndex=hrSWOSIndex, hrSWRunParameters=hrSWRunParameters, hrPartitionSize=hrPartitionSize, hrPartitionIndex=hrPartitionIndex, hrMIBGroups=hrMIBGroups, hrPrinterStatus=hrPrinterStatus, hrSWRunStatus=hrSWRunStatus, hrPartitionID=hrPartitionID, hrSystemInitialLoadParameters=hrSystemInitialLoadParameters, hrSWInstalledLastChange=hrSWInstalledLastChange, hrDiskStorageMedia=hrDiskStorageMedia, hrDeviceGroup=hrDeviceGroup, hrDiskStorageRemoveble=hrDiskStorageRemoveble, hrStorage=hrStorage)
