# pylint: disable=too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
from typing import TYPE_CHECKING

from msrest import Serializer

from azure.core.exceptions import ClientAuthenticationError, HttpResponseError, ResourceExistsError, ResourceNotFoundError, map_error
from azure.core.pipeline import PipelineResponse
from azure.core.pipeline.transport import HttpResponse
from azure.core.rest import HttpRequest
from azure.core.tracing.decorator import distributed_trace

from .. import models as _models
from .._vendor import _convert_request

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Callable, Dict, Optional, TypeVar, Union
    T = TypeVar('T')
    ClsType = Optional[Callable[[PipelineResponse[HttpRequest, HttpResponse], T, Dict[str, Any]], Any]]

_SERIALIZER = Serializer()
_SERIALIZER.client_side_validation = False
# fmt: off

def build_issue_relay_configuration_request(
    **kwargs  # type: Any
):
    # type: (...) -> HttpRequest
    api_version = kwargs.pop('api_version', "2022-03-01-preview")  # type: str
    content_type = kwargs.pop('content_type', None)  # type: Optional[str]

    accept = "application/json"
    # Construct URL
    _url = kwargs.pop("template_url", "/networkTraversal/:issueRelayConfiguration")

    # Construct parameters
    _query_parameters = kwargs.pop("params", {})  # type: Dict[str, Any]
    _query_parameters['api-version'] = _SERIALIZER.query("api_version", api_version, 'str')

    # Construct headers
    _header_parameters = kwargs.pop("headers", {})  # type: Dict[str, Any]
    if content_type is not None:
        _header_parameters['Content-Type'] = _SERIALIZER.header("content_type", content_type, 'str')
    _header_parameters['Accept'] = _SERIALIZER.header("accept", accept, 'str')

    return HttpRequest(
        method="POST",
        url=_url,
        params=_query_parameters,
        headers=_header_parameters,
        **kwargs
    )

# fmt: on
class CommunicationNetworkTraversalOperations(object):
    """
    .. warning::
        **DO NOT** instantiate this class directly.

        Instead, you should access the following operations through
        :class:`~azure.communication.networktraversal.CommunicationNetworkTraversalClient`'s
        :attr:`communication_network_traversal` attribute.
    """

    models = _models

    def __init__(self, *args, **kwargs):
        args = list(args)
        self._client = args.pop(0) if args else kwargs.pop("client")
        self._config = args.pop(0) if args else kwargs.pop("config")
        self._serialize = args.pop(0) if args else kwargs.pop("serializer")
        self._deserialize = args.pop(0) if args else kwargs.pop("deserializer")


    @distributed_trace
    def issue_relay_configuration(
        self,
        id=None,  # type: Optional[str]
        route_type=None,  # type: Optional[Union[str, "_models.RouteType"]]
        ttl=172800,  # type: Optional[int]
        **kwargs  # type: Any
    ):
        # type: (...) -> "_models.CommunicationRelayConfiguration"
        """Issue a configuration for an STUN/TURN server.

        Issue a configuration for an STUN/TURN server.

        :param id: An identity to be associated with telemetry for data relayed using the returned
         credentials. Must be an existing ACS user identity. If not provided, the telemetry will not
         contain an associated identity value. Default value is None.
        :type id: str
        :param route_type: Filter the routing methodology returned. If not provided, will return all
         route types in separate ICE servers. Default value is None.
        :type route_type: str or ~azure.communication.networktraversal.models.RouteType
        :param ttl: The credential Time-To-Live (TTL), in seconds. The default value will be used if
         given value exceeds it. Default value is 172800.
        :type ttl: int
        :keyword callable cls: A custom type or function that will be passed the direct response
        :return: CommunicationRelayConfiguration, or the result of cls(response)
        :rtype: ~azure.communication.networktraversal.models.CommunicationRelayConfiguration
        :raises: ~azure.core.exceptions.HttpResponseError
        """
        cls = kwargs.pop('cls', None)  # type: ClsType["_models.CommunicationRelayConfiguration"]
        error_map = {
            401: ClientAuthenticationError, 404: ResourceNotFoundError, 409: ResourceExistsError
        }
        error_map.update(kwargs.pop('error_map', {}))

        api_version = kwargs.pop('api_version', "2022-03-01-preview")  # type: str
        content_type = kwargs.pop('content_type', "application/json")  # type: Optional[str]

        _body = _models.CommunicationRelayConfigurationRequest(id=id, route_type=route_type, ttl=ttl)
        if _body is not None:
            _json = self._serialize.body(_body, 'CommunicationRelayConfigurationRequest')
        else:
            _json = None

        request = build_issue_relay_configuration_request(
            api_version=api_version,
            content_type=content_type,
            json=_json,
            template_url=self.issue_relay_configuration.metadata['url'],
        )
        request = _convert_request(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.endpoint", self._config.endpoint, 'str', skip_quote=True),
        }
        request.url = self._client.format_url(request.url, **path_format_arguments)

        pipeline_response = self._client._pipeline.run(  # pylint: disable=protected-access
            request,
            stream=False,
            **kwargs
        )
        response = pipeline_response.http_response

        if response.status_code not in [200]:
            map_error(status_code=response.status_code, response=response, error_map=error_map)
            error = self._deserialize.failsafe_deserialize(_models.CommunicationErrorResponse, pipeline_response)
            raise HttpResponseError(response=response, model=error)

        deserialized = self._deserialize('CommunicationRelayConfiguration', pipeline_response)

        if cls:
            return cls(pipeline_response, deserialized, {})

        return deserialized

    issue_relay_configuration.metadata = {'url': "/networkTraversal/:issueRelayConfiguration"}  # type: ignore

