# Introduction

This documentation provides a guide for `pymatgen` administrators. The following assumes you are using `miniconda`
or Anaconda.

## Releases

The general procedure for releasing `pymatgen` comprises the following steps:

1. Make sure all CI checks are green. We don't want to release known bugs.
2. Update changelog.
3. Run `invoke make-doc` to update the HTML docs.
4. Tag the latest commit with `git tag v<yyyy.mm.dd>`.
5. Make a GitHub release with auto-generated release notes.
6. Make sure the release action runs that publishes the new version to PyPI and conda-forge runs to completion.

## Initial setup

Pymatgen uses [invoke](http://pyinvoke.org) to automate releases.
You will also need `sphinx` and `doc2dash`.

```sh
pip install --upgrade invoke sphinx
```

## Doing the release

First update the change log. The autogenerated change log is simply a list of commit messages since the last version. Make sure to edit the log for brevity and to attribute significant features to appropriate developers:

```sh
invoke update-changelog
```

Then, do the release:

```sh
invoke release
```

Double check that the releases are properly done on Pypi.
