
#include "bdl.h"

static BDL_Record moonrecords[] = {

     {
          2455197.1,
          {-1.0092,0.00665,52.4555,0.27687,0.000734,0.4106}, /*cmx*/
          {-5.336232,-0.3814,-3.5727,-0.6781}, /*cfx*/
          {-1.0754,0.00474,184.2091,0.09239,0.00016,0.3609}, /*cmy*/
          {-1.933963,-0.3859,-3.6505,-0.4536}, /*cfy*/
          {-0.0805,-0.00137,190.7561,0.04176,0.000132,0.4246}, /*cmz*/
          {-3.521545,-0.464,-2.8542,-0.7726} /*cfz*/
     },
     {
          2455455.1,
          {0.1401,0.00263,61.6535,0.09604,0.000698,0.592}, /*cmx*/
          {-3.336795,-1.1188,-4.3435,-3.9967}, /*cfx*/
          {-0.4566,0.00171,183.9722,0.11401,0.000455,0.0755}, /*cmy*/
          {-5.842044,-1.1592,-4.3286,-0.5326}, /*cfy*/
          {0.2228,-0.00166,187.8303,0.08537,0.000289,0.1959}, /*cmz*/
          {-1.180763,-2.5267,-5.3556,-3.5372} /*cfz*/
     },
     {
          2455713.1,
          {-0.6868,0.00903,74.3509,0.10347,0.000217,0.4362}, /*cmx*/
          {-1.304181,-5.4648,-2.5367,-3.8931}, /*cfx*/
          {-0.7214,0.00542,185.3318,0.01926,0.000208,0.3735}, /*cmy*/
          {-3.522664,-1.2228,-4.9542,-3.7305}, /*cfy*/
          {-0.5553,0.0037,182.0239,0.03868,0.000203,0.0965}, /*cmz*/
          {-5.17437,-4.3932,-0.676,-4.1137} /*cfz*/
     },
     {
          2455971.1,
          {-0.1008,0.00177,67.9523,0.24382,0.000806,0.1875}, /*cmx*/
          {-5.180058,-6.0671,-2.9445,-0.8542}, /*cfx*/
          {-0.7898,0.00433,183.9862,0.11898,0.000323,0.0768}, /*cmy*/
          {-1.263304,-6.1208,-3.0316,-6.1249}, /*cfy*/
          {-0.4413,0.00112,185.8757,0.10359,0.000314,0.4124}, /*cmz*/
          {-2.899281,-0.2563,-3.2439,-0.5646} /*cfz*/
     },
     {
          2456229.1,
          {1.1791,-0.00459,71.9994,0.06711,0.000192,0.6927}, /*cmx*/
          {-2.930127,-4.0275,-3.4637,-3.8794}, /*cfx*/
          {0.0428,-0.00069,184.8329,0.0647,0.000344,0.0945}, /*cmy*/
          {-5.198025,-0.5291,-3.7076,-4.5853}, /*cfy*/
          {0.1424,-0.00064,183.2001,0.07481,0.000315,0.266}, /*cmz*/
          {-0.563184,-2.2401,-4.8374,-3.757} /*cfz*/
     },
     {
          2456487.1,
          {0.6101,-0.00126,93.6715,0.18922,0.000681,0.394}, /*cmx*/
          {-0.853821,-4.5962,-1.5179,-3.7445}, /*cfx*/
          {-0.0011,0.00097,185.9368,0.05266,6.4e-05,0.3397}, /*cmy*/
          {-2.852774,-4.5526,-1.5108,-3.6446}, /*cfy*/
          {-0.4553,0.00351,172.3353,0.07685,0.000255,0.231}, /*cmz*/
          {-4.532689,-4.784,-1.1793,-3.6475} /*cfz*/
     },
     {
          2456745.1,
          {0.9406,-0.007,90.4788,0.16135,0.000692,0.3203}, /*cmx*/
          {-4.857273,-5.2531,-2.1679,-0.9675}, /*cfx*/
          {-0.1924,0.00077,185.7618,0.10564,0.000371,0.0517}, /*cmy*/
          {-0.589065,-5.3803,-2.243,-2.5843}, /*cfy*/
          {-0.0865,-0.00158,173.6946,0.11322,0.000436,0.3922}, /*cmz*/
          {-2.267777,-6.0436,-2.7884,-0.6025} /*cfz*/
     },
     {
          2457003.1,
          {1.5263,-0.00918,87.1604,0.19093,0.000328,0.4293}, /*cmx*/
          {-2.4894,-3.4292,-0.6192,-3.7534}, /*cfx*/
          {0.4027,-0.00341,185.4795,0.01829,0.000172,0.1085}, /*cmy*/
          {-4.558383,-4.9867,-2.7351,-4.4339}, /*cfy*/
          {0.6265,-0.00406,176.2165,0.09175,0.000192,0.2577}, /*cmz*/
          {-6.231937,-2.7545,-5.1386,-3.9105} /*cfz*/
     },
     {
          2457261.1,
          {0.6257,-0.00428,109.7456,0.18596,0.000828,0.0763}, /*cmx*/
          {-0.34619,-3.9985,-0.9604,-3.0626}, /*cfx*/
          {0.3866,-0.00246,187.2493,0.09486,0.000259,0.2263}, /*cmy*/
          {-2.198591,-3.9334,-0.8982,-3.6742}, /*cfy*/
          {-0.2292,0.00153,161.0592,0.12457,0.000494,0.1657}, /*cmz*/
          {-3.89624,-4.3879,-1.0106,-3.2637} /*cfz*/
     },
     {
          2457519.1,
          {0.8176,-0.00861,114.0592,0.0663,0.000383,0.6337}, /*cmx*/
          {-4.401805,-4.1464,-1.3759,-0.827}, /*cfx*/
          {0.1478,-0.00211,188.1281,0.08256,0.000357,0.1288}, /*cmy*/
          {-6.21016,-4.6289,-1.5363,-1.7407}, /*cfy*/
          {0.0702,-0.00407,156.4374,0.07318,0.000384,0.5354}, /*cmz*/
          {-1.622097,-5.6745,-2.3454,-0.7565} /*cfz*/
     },
     {
          2457777.1,
          {0.8481,-0.00624,107.1246,0.22618,0.000572,0.0694}, /*cmx*/
          {-2.034525,-2.799,-6.0545,-2.9154}, /*cfx*/
          {0.3673,-0.0038,186.8261,0.03086,8.8e-05,0.0173}, /*cmy*/
          {-3.915535,-3.2288,-1.4577,-0.569}, /*cfy*/
          {0.7838,-0.00636,163.5198,0.16184,0.000362,0.1887}, /*cmz*/
          {-5.614689,-2.6494,-5.6491,-4.0708} /*cfz*/
     },
     {
          2458035.1,
          {-0.5383,0.00285,121.8052,0.07837,0.000557,0.2375}, /*cmx*/
          {-6.085432,-3.1093,-0.2604,-0.7641}, /*cfx*/
          {0.2604,-0.00212,188.7027,0.08842,0.000268,0.0776}, /*cmy*/
          {-1.563525,-3.2916,-0.2512,-4.1671}, /*cfy*/
          {-0.5109,0.00261,149.8845,0.10733,0.000558,0.0714}, /*cmz*/
          {-3.261814,-4.0152,-0.5681,-2.2381} /*cfz*/
     },
     {
          2458293.1,
          {-0.4634,0.00044,136.6762,0.08983,0.000228,0.6898}, /*cmx*/
          {-3.872788,-1.4805,-4.9124,-0.6733}, /*cfx*/
          {-0.0361,-0.00084,189.6198,0.04653,0.000253,0.2174}, /*cmy*/
          {-5.562121,-3.9483,-0.872,-1.1151}, /*cfy*/
          {-0.5216,-0.00087,135.3271,0.07037,0.000222,0.7391}, /*cmz*/
          {-0.967511,-0.4988,-2.991,-0.7575} /*cfz*/
     },
     {
          2458551.1,
          {-0.1921,0.00155,128.9505,0.20218,0.000669,0.0045}, /*cmx*/
          {-1.555478,-2.0519,-5.2511,-2.8482}, /*cfx*/
          {0.0811,-0.0018,188.9001,0.0298,4.3e-05,0.1762}, /*cmy*/
          {-3.2775,-2.2018,-6.1646,-0.9734}, /*cfy*/
          {0.2403,-0.00272,143.86,0.20794,0.000643,0.1587}, /*cmz*/
          {-4.976329,-2.1009,-5.1644,-4.2788} /*cfz*/
     },
     {
          2458809.1,
          {-1.1686,0.00872,134.4652,0.08504,0.000272,0.141}, /*cmx*/
          {-5.525907,-0.708,-5.2057,-0.6533}, /*cfx*/
          {-0.0178,4e-05,189.6739,0.07397,0.000234,0.0698}, /*cmy*/
          {-0.942289,-2.5293,-5.7329,-4.637}, /*cfy*/
          {-1.0895,0.00743,137.4484,0.03913,0.000374,0.002}, /*cmz*/
          {-2.634553,-4.4448,-0.0067,-3.3883} /*cfz*/
     },
     {
          2459067.1,
          {-0.9707,0.00655,154.9256,0.16855,0.000612,0.3915}, /*cmx*/
          {-3.321023,-0.7797,-4.0749,-0.4395}, /*cfx*/
          {-0.3687,0.00227,190.4455,0.015,0.000164,0.1132}, /*cmy*/
          {-4.929731,-2.9929,-0.0794,-0.7444}, /*cfy*/
          {-1.1345,0.00477,112.9731,0.17384,0.000555,0.7326}, /*cmz*/
          {-0.295541,-0.4912,-3.5245,-0.7135} /*cfz*/
     },
     {
          2455197.5,
          {-0.3704,-0.00181,73.5546,0.3262,0.000786,0.4458}, /*cmx*/
          {-3.338292,-4.5671,-1.4225,-2.6882}, /*cfx*/
          {-0.5043,-0.00111,256.739,0.10313,0.000173,0.4193}, /*cmy*/
          {-6.184772,-4.5092,-1.2424,-0.2232}, /*cfy*/
          {1.6536,-0.0023,265.4291,0.04238,7.8e-05,0.7614}, /*cmz*/
          {-1.493717,-4.9082,-0.997,-1.8987} /*cfz*/
     },
     {
          2455439.5,
          {-0.3651,0.00248,88.678,0.23288,0.00126,0.5781}, /*cmx*/
          {-1.178718,-5.2421,-2.1251,-5.275}, /*cfx*/
          {-0.3314,-0.00139,256.3081,0.13525,0.00054,0.6486}, /*cmy*/
          {-3.636569,-5.2917,-2.1759,-1.8935}, /*cfy*/
          {1.5433,-0.00034,260.4786,0.09574,0.000352,0.5382}, /*cmz*/
          {-5.261866,-0.0058,-2.8385,-3.122} /*cfz*/
     },
     {
          2455681.5,
          {-1.5098,0.01032,97.4123,0.09727,0.000593,2.0487}, /*cmx*/
          {-5.120332,-5.2007,-2.3074,-5.655}, /*cfx*/
          {-0.8468,0.0027,257.0691,0.08055,0.000459,0.1499}, /*cmy*/
          {-1.145126,-5.7208,-2.6303,-3.6044}, /*cfy*/
          {1.1116,0.00221,256.3441,0.04316,0.000264,0.7242}, /*cmz*/
          {-2.787742,-0.7339,-3.7431,-4.8294} /*cfz*/
     },
     {
          2455923.5,
          {-1.2761,0.00596,89.8605,0.33513,0.000793,1.1284}, /*cmx*/
          {-2.499787,-3.5709,-0.4831,-5.8359}, /*cfx*/
          {-1.0953,0.00294,255.8383,0.09184,0.000149,0.7742}, /*cmy*/
          {-4.960988,-3.6741,-0.8129,-5.1071}, /*cfy*/
          {1.0732,0.00015,261.2134,0.099,0.000229,0.4716}, /*cmz*/
          {-0.306431,-3.3961,-6.1115,-5.7649} /*cfz*/
     },
     {
          2456165.5,
          {-0.3013,0.00065,113.0039,0.24117,0.001179,0.3043}, /*cmx*/
          {-0.261939,-4.0637,-0.9799,-2.7967}, /*cfx*/
          {-0.9778,0.00154,257.8651,0.14404,0.000514,0.8155}, /*cmy*/
          {-2.409674,-4.0738,-0.9417,-5.533}, /*cfy*/
          {1.4869,-0.00154,249.924,0.10525,0.000427,0.5949}, /*cmz*/
          {-4.075826,-4.774,-1.3615,-1.4514} /*cfz*/
     },
     {
          2456407.5,
          {-0.428,0.00426,120.1345,0.13785,0.000782,0.7421}, /*cmx*/
          {-4.128467,-4.7904,-1.6436,-5.1281}, /*cfx*/
          {-0.7848,0.00125,258.1022,0.09977,0.00049,0.5813}, /*cmy*/
          {-6.215825,-4.7541,-1.6119,-0.0222}, /*cfy*/
          {1.2339,0.00208,245.9688,0.10038,0.000495,0.1077}, /*cmz*/
          {-1.607591,-5.549,-2.3037,-1.0065} /*cfz*/
     },
     {
          2456649.5,
          {-0.8941,0.0064,112.2706,0.22627,0.000369,1.6571}, /*cmx*/
          {-1.581895,-2.5551,-6.0895,-5.6972}, /*cfx*/
          {-0.9679,0.002,257.4993,0.03682,0.000119,0.2874}, /*cmy*/
          {-3.737162,-2.8785,-1.5305,-0.6843}, /*cfy*/
          {0.669,0.00487,250.028,0.08539,6.6e-05,0.9254}, /*cmz*/
          {-5.401921,-2.4016,-5.1198,-5.1782} /*cfz*/
     },
     {
          2456891.5,
          {-0.6156,0.00226,139.2113,0.26457,0.001188,0.588}, /*cmx*/
          {-5.544615,-3.0055,-6.1955,-0.199}, /*cfx*/
          {-1.0838,0.00197,260.0668,0.12001,0.000379,0.1985}, /*cmy*/
          {-1.194526,-3.0273,-6.2549,-3.5235}, /*cfy*/
          {1.0007,0.00054,233.268,0.16361,0.000655,0.3982}, /*cmz*/
          {-2.883429,-3.3275,-6.2812,-4.9583} /*cfz*/
     },
     {
          2457133.5,
          {0.2115,-0.00237,142.1468,0.15441,0.000758,0.8859}, /*cmx*/
          {-3.095402,-3.4827,-0.3976,-2.476}, /*cfx*/
          {-0.9061,9e-05,260.0754,0.09478,0.000419,0.4315}, /*cmy*/
          {-5.007996,-3.5447,-0.4215,-4.492}, /*cfy*/
          {1.5805,-0.00302,231.7058,0.10859,0.000517,0.4708}, /*cmz*/
          {-0.41424,-3.9848,-0.8379,-2.0696} /*cfz*/
     },
     {
          2457375.5,
          {0.2227,-0.00131,135.1592,0.20472,0.000206,0.4434}, /*cmx*/
          {-0.564074,-1.2544,-4.4326,-3.7924}, /*cfx*/
          {-0.8866,0.00035,259.9458,0.00558,0.000162,0.7252}, /*cmy*/
          {-2.521294,-2.9256,-1.0438,-5.6653}, /*cfy*/
          {1.4184,0.00021,236.6096,0.11692,0.000248,0.3561}, /*cmz*/
          {-4.205665,-0.7129,-2.7929,-0.8228} /*cfz*/
     },
     {
          2457617.5,
          {-0.3143,0.00066,165.7018,0.23515,0.000972,0.5026}, /*cmx*/
          {-4.485422,-1.8763,-5.0988,-5.5353}, /*cfx*/
          {-0.9709,0.00106,261.9458,0.06935,0.000153,0.6168}, /*cmy*/
          {-6.275542,-1.8192,-5.2061,-0.2524}, /*cfy*/
          {0.6993,0.00335,213.573,0.16366,0.000621,0.438}, /*cmz*/
          {-1.693489,-2.0904,-5.0969,-5.7823} /*cfz*/
     },
     {
          2457859.5,
          {0.0719,-0.00452,163.4705,0.22894,0.00098,0.8013}, /*cmx*/
          {-2.016262,-2.3863,-5.5447,-1.9487}, /*cfx*/
          {-1.0398,-0.00035,261.9128,0.08932,0.00035,0.5565}, /*cmy*/
          {-3.811778,-2.4386,-5.5955,-2.2031}, /*cfy*/
          {1.0481,-0.00184,214.7432,0.20342,0.000865,0.4667}, /*cmz*/
          {-5.511506,-2.708,-5.813,-3.0411} /*cfz*/
     },
     {
          2458101.5,
          {0.6021,-0.00747,161.9322,0.17849,0.000261,1.5038}, /*cmx*/
          {-5.782385,-0.5063,-4.4586,-2.3959}, /*cfx*/
          {-0.7919,-0.00239,261.5145,0.04143,0.000197,0.8582}, /*cmy*/
          {-1.313104,-2.3357,-5.7909,-2.9845}, /*cfy*/
          {1.9351,-0.00721,216.2019,0.09709,7.7e-05,0.9984}, /*cmz*/
          {-3.01714,-6.2503,-0.4876,-2.6883} /*cfz*/
     },
     {
          2458343.5,
          {0.1352,-0.003,191.4917,0.24035,0.000918,0.7744}, /*cmx*/
          {-3.404153,-0.7491,-3.9718,-2.9443}, /*cfx*/
          {-0.863,-0.00179,264.3023,0.04881,7.3e-05,0.3798}, /*cmy*/
          {-5.085528,-0.7689,-4.5413,-4.3538}, /*cfy*/
          {1.3866,-0.00241,187.4761,0.22004,0.000785,0.2248}, /*cmz*/
          {-0.4923,-0.7083,-3.7137,-1.7603} /*cfz*/
     },
     {
          2458585.5,
          {-0.4023,-0.00225,185.8291,0.23721,0.000953,0.3422}, /*cmx*/
          {-0.919091,-1.4222,-4.5858,-3.7349}, /*cfx*/
          {-1.2043,0.00032,264.1648,0.05085,0.000166,0.6764}, /*cmy*/
          {-2.623375,-1.2343,-4.4589,-5.9771}, /*cfy*/
          {0.6376,8e-05,193.4331,0.24059,0.000946,0.3346}, /*cmz*/
          {-4.313509,-1.4825,-4.6113,-0.8037} /*cfz*/
     },
     {
          2458827.5,
          {0.0383,-0.00699,187.7112,0.08051,0.000376,0.9643}, /*cmx*/
          {-4.709799,-6.1096,-4.6665,-2.3436}, /*cfx*/
          {-1.1734,-0.00066,264.0553,0.06337,0.000222,0.5038}, /*cmy*/
          {-0.119857,-1.6446,-4.8984,-1.3515}, /*cfy*/
          {1.0003,-0.00575,191.3286,0.04091,0.000507,1.1689}, /*cmz*/
          {-1.808406,-3.9086,-5.3975,-2.5181} /*cfz*/
     },
     {
          2459069.5,
          {0.1476,-0.00626,212.5904,0.19182,0.000726,1.3344}, /*cmx*/
          {-2.304713,-6.1992,-3.1911,-2.2589}, /*cfx*/
          {-1.0652,-0.00245,265.4693,0.02767,0.000213,1.0206}, /*cmy*/
          {-3.918545,-1.7799,-5.2016,-2.548}, /*cfy*/
          {1.4045,-0.00709,160.8318,0.20282,0.00065,1.4568}, /*cmz*/
          {-5.562111,-6.0164,-2.821,-2.8193} /*cfz*/
     },
     {
          2455197.5,
          {-0.4356,0.00431,122.0281,0.53819,0.001252,0.3036}, /*cmx*/
          {4.75186,3.4766,0.3395,-4.31}, /*cfx*/
          {0.8144,0.0039,420.5683,0.21574,0.000372,0.291}, /*cmy*/
          {1.899859,3.5086,0.4501,-0.2112}, /*cfy*/
          {-0.6873,0.00058,435.5465,0.0987,0.000127,0.5938}, /*cmz*/
          {0.307549,2.7773,0.146,-1.7636} /*cfz*/
     },
     {
          2455420.5,
          {0.1664,-0.00155,149.7164,0.46688,0.002111,0.5642}, /*cmx*/
          {1.954181,4.1986,1.0607,-3.6498}, /*cfx*/
          {1.374,-0.00211,421.1636,0.18992,0.000834,0.4787}, /*cmy*/
          {5.827369,4.1839,1.0434,-5.0014}, /*cfy*/
          {-0.9684,0.00185,425.3275,0.12634,0.000536,0.3351}, /*cmz*/
          {4.198031,3.5081,0.4328,-6.1407} /*cfz*/
     },
     {
          2455643.5,
          {-0.1225,-0.00047,149.8824,0.45292,0.00204,0.2043}, /*cmx*/
          {5.810639,4.9515,1.8013,-3.258}, /*cfx*/
          {1.1194,-6e-05,420.6931,0.23628,0.000933,0.7482}, /*cmy*/
          {3.400247,4.9184,1.785,-3.8196}, /*cfy*/
          {-0.5535,-0.00062,425.659,0.17653,0.000715,0.3958}, /*cmz*/
          {1.767139,4.2243,1.2216,-4.6099} /*cfz*/
     },
     {
          2455866.5,
          {-0.899,0.00616,148.3598,0.01975,0.001122,0.0825}, /*cmx*/
          {3.398741,3.2833,2.4547,-4.842}, /*cfx*/
          {0.7556,0.00244,421.3356,0.01985,0.000586,0.4962}, /*cmy*/
          {0.987825,5.3402,2.4522,-2.2439}, /*cfy*/
          {-0.9605,0.00254,425.0361,0.03661,0.000534,0.3032}, /*cmz*/
          {5.640711,4.6107,1.8936,-4.1495} /*cfz*/
     },
     {
          2456089.5,
          {-0.7095,0.00761,191.6043,0.20431,0.000199,0.2198}, /*cmx*/
          {0.730223,3.151,0.0783,-4.9825}, /*cfx*/
          {0.9045,0.00337,422.787,0.03171,0.000131,0.5303}, /*cmy*/
          {4.906949,3.4362,2.8796,-0.6268}, /*cfy*/
          {-0.7798,0.00192,406.2083,0.07262,0.000198,0.4961}, /*cmz*/
          {3.237608,3.5532,1.4388,-2.7468} /*cfz*/
     },
     {
          2456312.5,
          {0.051,0.00191,167.7321,0.52823,0.001362,0.3646}, /*cmx*/
          {4.721791,3.8819,0.719,-3.8741}, /*cfx*/
          {1.2033,0.00054,421.3707,0.19893,0.000403,0.3845}, /*cmy*/
          {2.456914,3.9014,0.739,-5.4986}, /*cfy*/
          {-0.7263,0.00268,419.326,0.22547,0.000507,0.3346}, /*cmz*/
          {0.804495,3.5783,0.6021,-0.8164} /*cfz*/
     },
     {
          2456535.5,
          {0.2951,-0.00229,205.8967,0.42882,0.002056,0.3339}, /*cmx*/
          {2.126569,4.6479,1.4963,-3.402}, /*cfx*/
          {1.3422,-0.00085,424.5159,0.17451,0.000788,0.8666}, /*cmy*/
          {0.091712,4.6571,1.5248,-4.0926}, /*cfy*/
          {-0.4963,0.0,398.2881,0.20515,0.000971,0.3271}, /*cmz*/
          {4.697336,4.26,1.1702,-5.0765} /*cfz*/
     },
     {
          2456758.5,
          {-0.2148,0.00143,210.1649,0.39386,0.0019,0.1925}, /*cmx*/
          {5.964832,5.3763,2.2167,-3.471}, /*cfx*/
          {1.1459,-6e-05,425.057,0.17902,0.000724,0.4344}, /*cmy*/
          {3.95141,5.4116,2.2384,-2.5259}, /*cfy*/
          {-0.4888,0.00054,395.5797,0.244,0.001099,0.4106}, /*cmz*/
          {2.269375,4.9611,1.9179,-4.4941} /*cfz*/
     },
     {
          2456981.5,
          {-0.7448,0.00708,204.5262,0.0936,0.000752,0.257}, /*cmx*/
          {3.569348,2.9014,2.8907,-5.7412}, /*cfx*/
          {0.9631,0.00224,424.8922,0.00932,0.000419,0.3325}, /*cmy*/
          {1.533543,4.1923,2.8403,-1.221}, /*cfy*/
          {-0.8698,0.00374,398.0213,0.03284,0.000672,0.5519}, /*cmz*/
          {6.140225,3.9999,2.4715,-3.1324} /*cfz*/
     },
     {
          2457204.5,
          {-0.1754,0.00482,253.3343,0.24959,0.000496,0.3132}, /*cmx*/
          {0.998535,3.4785,0.3022,-4.2768}, /*cfx*/
          {1.111,0.00184,428.2629,0.01995,8.5e-05,0.602}, /*cmy*/
          {5.44006,3.3445,3.7568,-0.2224}, /*cfy*/
          {-0.5548,0.00346,364.6609,0.14081,0.000259,0.1667}, /*cmz*/
          {3.744425,3.6896,0.9475,-1.6306} /*cfz*/
     },
     {
          2457427.5,
          {0.3916,-0.00053,229.33,0.49679,0.001376,0.236}, /*cmx*/
          {4.929083,4.3091,1.1274,-3.4274}, /*cfx*/
          {1.2741,0.00012,426.0363,0.15159,0.000316,0.7074}, /*cmy*/
          {2.999527,4.3138,1.0888,-4.3783}, /*cfy*/
          {-0.2278,0.0008,383.1736,0.34369,0.000906,0.2188}, /*cmz*/
          {1.306466,4.1423,1.0713,-5.9762} /*cfz*/
     },
     {
          2457650.5,
          {0.1959,-0.0013,265.9281,0.38393,0.001964,0.3041}, /*cmx*/
          {2.424475,5.0639,1.9057,-3.2149}, /*cfx*/
          {1.3437,-0.00107,429.1969,0.11294,0.000523,0.3882}, /*cmy*/
          {0.617815,5.0979,1.9204,-3.1821}, /*cfy*/
          {-0.1637,-0.00086,354.1649,0.28546,0.001428,0.4503}, /*cmz*/
          {5.201205,4.9211,1.8062,-4.8207} /*cfz*/
     },
     {
          2457873.5,
          {-0.211,0.00262,274.7777,0.31579,0.001643,0.1926}, /*cmx*/
          {6.260181,5.7883,2.6111,-5.7422}, /*cfx*/
          {1.1587,-0.00016,430.143,0.12075,0.000481,0.3688}, /*cmy*/
          {4.479348,5.8206,2.6257,-1.8484}, /*cfy*/
          {-0.5439,0.00298,346.8034,0.29084,0.001438,0.3969}, /*cmz*/
          {2.779363,5.5505,2.4729,-3.4112} /*cfz*/
     },
     {
          2458096.5,
          {-0.4658,0.00612,265.8903,0.1505,0.000419,0.2312}, /*cmx*/
          {3.867991,3.2039,3.3679,-5.07}, /*cfx*/
          {1.015,0.00209,429.7844,0.00569,0.000249,0.5057}, /*cmy*/
          {2.061959,2.0605,3.4155,-0.4749}, /*cfy*/
          {-0.546,0.00437,354.2533,0.08733,0.000605,0.2148}, /*cmz*/
          {0.362131,3.549,3.0133,-2.6788} /*cfz*/
     },
     {
          2458319.5,
          {0.3567,0.00131,313.2501,0.25796,0.000645,0.3546}, /*cmx*/
          {1.347257,3.8557,0.6518,-4.0313}, /*cfx*/
          {1.2944,-0.00023,433.7128,0.01838,8e-05,0.5278}, /*cmy*/
          {5.948551,2.7236,4.8466,-4.9301}, /*cfy*/
          {-0.0507,0.00196,308.3394,0.21673,0.000515,0.1451}, /*cmz*/
          {4.263488,4.0546,0.999,-0.5165} /*cfz*/
     },
     {
          2458542.5,
          {0.4462,-0.00125,292.5021,0.45417,0.001364,0.3998}, /*cmx*/
          {5.247623,4.709,1.5123,-3.0038}, /*cfx*/
          {1.2835,-0.0003,432.1586,0.06543,8.9e-05,0.3544}, /*cmy*/
          {3.517769,4.7187,1.0987,-3.4732}, /*cfy*/
          {0.3746,-0.00249,330.6455,0.45079,0.001265,0.4069}, /*cmz*/
          {1.822108,4.7214,1.6213,-5.3577} /*cfz*/
     },
     {
          2458765.5,
          {0.272,-0.00154,323.3711,0.32336,0.001757,0.2402}, /*cmx*/
          {2.78136,5.4637,2.298,-0.6407}, /*cfx*/
          {1.1764,-0.00077,434.0088,0.0445,0.000189,0.2501}, /*cmy*/
          {1.117306,5.3576,2.0736,-2.152}, /*cfy*/
          {-0.233,0.00135,296.5047,0.34282,0.001852,0.5262}, /*cmz*/
          {5.720661,5.4381,2.314,-3.8803} /*cfz*/
     },
     {
          2458988.5,
          {-0.4202,0.00516,335.5234,0.22344,0.001285,0.3221}, /*cmx*/
          {0.331636,6.2101,2.983,-5.4225}, /*cfx*/
          {1.1806,0.00044,434.4568,0.05889,0.000183,0.369}, /*cmy*/
          {4.974707,6.2388,2.8904,-1.2916}, /*cfy*/
          {-0.239,0.00306,282.0388,0.30672,0.001631,0.2261}, /*cmz*/
          {3.30524,6.0732,2.9813,-1.9896} /*cfz*/
     },
     {
          2459211.5,
          {0.0368,0.00288,324.8692,0.18007,0.000166,0.343}, /*cmx*/
          {4.222392,3.5474,4.0621,-4.3288}, /*cfx*/
          {1.1039,2e-05,434.2569,0.02332,0.000114,0.456}, /*cmy*/
          {2.561742,1.1848,3.9391,-5.6365}, /*cfy*/
          {-0.2432,0.00461,294.1613,0.15932,0.000454,0.2117}, /*cmz*/
          {0.880522,3.8149,3.6291,-0.8666} /*cfz*/
     },
     {
          2455197.4,
          {-0.2592,0.0047,161.8529,0.65263,0.001301,0.3557}, /*cmx*/
          {4.438119,3.1771,0.0232,4.9465}, /*cfx*/
          {-0.3733,0.00331,562.3685,0.26036,0.000437,0.4912}, /*cmy*/
          {1.59724,3.1659,0.0104,5.9396}, /*cfy*/
          {-1.3103,0.00081,582.3074,0.11091,0.0001,0.6582}, /*cmz*/
          {0.004774,2.4985,5.9622,5.1159} /*cfz*/
     },
     {
          2455403.4,
          {0.2839,-0.00066,203.1986,0.59891,0.002327,0.8189}, /*cmx*/
          {5.942927,1.9523,5.084,6.206}, /*cfx*/
          {0.0108,-0.00012,563.1814,0.25126,0.000884,0.1273}, /*cmy*/
          {3.553189,1.9376,5.0804,5.1826}, /*cfy*/
          {-0.8077,-0.00158,568.2435,0.14375,0.000503,0.5661}, /*cmz*/
          {1.918326,1.3301,4.5909,2.4589} /*cfz*/
     },
     {
          2455609.4,
          {0.5274,-0.00186,187.137,0.75818,0.002613,0.1622}, /*cmx*/
          {1.652947,0.6543,3.7913,0.4692}, /*cfx*/
          {0.2293,-0.00067,562.9245,0.32463,0.001062,0.5527}, /*cmy*/
          {5.420246,0.6738,3.8122,1.6152}, /*cfy*/
          {-1.132,-0.00073,574.6104,0.23132,0.000765,0.407}, /*cmz*/
          {3.799267,0.1468,3.3373,6.1209} /*cfz*/
     },
     {
          2455815.4,
          {0.3738,-0.0005,215.8169,0.53805,0.003044,0.1347}, /*cmx*/
          {3.367921,5.7037,2.5487,6.0564}, /*cfx*/
          {-0.1324,0.00083,563.8076,0.25272,0.001312,0.5041}, /*cmy*/
          {1.068543,5.7063,2.5497,5.5113}, /*cfy*/
          {-1.0574,-0.00028,562.6066,0.17928,0.000978,0.5642}, /*cmz*/
          {5.706749,5.1248,2.0653,3.2532} /*cfz*/
     },
     {
          2456021.4,
          {0.4552,-0.00154,226.0457,0.57575,0.002809,0.1567}, /*cmx*/
          {5.204144,4.45,1.3024,5.4842}, /*cfx*/
          {0.1618,0.00051,564.651,0.25774,0.001213,0.6444}, /*cmy*/
          {2.96599,4.4554,1.3111,2.6551}, /*cfy*/
          {-1.0545,-0.00074,557.5879,0.23949,0.00114,0.3061}, /*cmz*/
          {1.313843,3.9633,0.8736,1.65} /*cfz*/
     },
     {
          2456227.4,
          {0.6367,-0.00238,226.0515,0.1322,0.002066,0.6972}, /*cmx*/
          {0.818663,3.2399,0.037,2.2537}, /*cfx*/
          {0.056,-0.00065,564.6573,0.09182,0.000959,0.5067}, /*cmy*/
          {4.861383,3.1852,0.0338,0.5631}, /*cfy*/
          {-1.1508,-0.00061,557.2824,0.08701,0.000952,0.2394}, /*cmz*/
          {3.210416,2.5203,5.8907,4.2973} /*cfz*/
     },
     {
          2456433.4,
          {0.2424,0.00128,270.9027,0.15115,0.001578,0.3217}, /*cmx*/
          {2.550644,1.9692,5.0711,3.1712}, /*cfx*/
          {0.0822,0.00118,567.4612,0.09227,0.000759,0.4721}, /*cmy*/
          {0.507038,1.9616,5.0874,3.2446}, /*cfy*/
          {-1.1238,0.00135,534.2746,0.08676,0.0008,0.8645}, /*cmz*/
          {5.115121,1.3523,4.6238,2.7265} /*cfz*/
     },
     {
          2456639.4,
          {-0.1195,0.00623,244.9452,0.32559,0.000302,0.6482}, /*cmx*/
          {4.5275,3.7408,4.0076,4.0815}, /*cfx*/
          {-0.1633,0.00334,565.4576,0.09508,0.000242,0.2642}, /*cmy*/
          {2.377499,3.6988,4.0115,1.7527}, /*cfy*/
          {-1.4197,0.002,548.8337,0.1255,0.000343,0.5576}, /*cmz*/
          {0.714773,3.646,3.3735,5.7886} /*cfz*/
     },
     {
          2456845.4,
          {0.2958,0.0019,309.8562,0.33567,0.000653,0.9339}, /*cmx*/
          {6.240598,2.5085,5.5935,5.9119}, /*cfx*/
          {0.0913,0.00045,570.4995,0.09436,6.3e-05,0.8174}, /*cmy*/
          {4.321622,2.5274,5.4165,5.6861}, /*cfy*/
          {-0.983,0.00013,509.3813,0.18255,0.000342,0.1963}, /*cmz*/
          {2.631277,2.4542,5.9286,3.994} /*cfz*/
     },
     {
          2457051.4,
          {0.8827,-0.00279,276.3901,0.62348,0.001418,0.4956}, /*cmx*/
          {1.92601,1.2498,4.3684,6.1665}, /*cfx*/
          {0.36,5e-05,568.2232,0.20094,0.000392,0.4245}, /*cmy*/
          {6.186713,1.2908,4.3949,2.3877}, /*cfy*/
          {-0.9874,-0.00125,531.6644,0.35141,0.000717,0.6372}, /*cmz*/
          {4.508232,1.108,4.3087,0.8493} /*cfz*/
     },
     {
          2457257.4,
          {0.9279,-0.00284,334.411,0.57425,0.002392,0.3749}, /*cmx*/
          {3.689733,6.2743,3.1151,2.1288}, /*cfx*/
          {0.2417,-0.00116,573.3093,0.19214,0.000712,0.7151}, /*cmy*/
          {1.839428,0.0192,3.1476,0.3616}, /*cfy*/
          {-0.8326,-0.00205,491.1585,0.36216,0.001472,0.1423}, /*cmz*/
          {0.144007,6.1176,3.0183,4.0777} /*cfz*/
     },
     {
          2457463.4,
          {0.5474,0.00018,318.3506,0.67907,0.002503,0.1837}, /*cmx*/
          {5.606669,5.0321,1.8768,4.8018}, /*cfx*/
          {0.4756,-0.00056,571.6595,0.20505,0.000695,0.3846}, /*cmy*/
          {3.716299,5.0665,1.9066,3.6208}, /*cfy*/
          {-1.1044,0.00116,503.3703,0.48358,0.001758,0.6701}, /*cmz*/
          {2.02432,4.8964,1.7755,2.6935} /*cfz*/
     },
     {
          2457669.4,
          {0.8025,-0.00129,347.3348,0.42525,0.002652,0.5112}, /*cmx*/
          {1.166226,3.7916,0.6288,3.0498}, /*cfx*/
          {0.1508,0.00061,573.9758,0.15052,0.000796,0.4137}, /*cmy*/
          {5.630677,3.8377,0.6571,1.2036}, /*cfy*/
          {-1.1666,4e-05,480.2683,0.3192,0.001939,0.3956}, /*cmz*/
          {3.933858,3.59,0.5012,0.3899} /*cfz*/
     },
     {
          2457875.4,
          {0.6382,-2e-05,365.6787,0.45557,0.002373,0.2937}, /*cmx*/
          {3.020828,2.5201,5.6385,1.3418}, /*cfx*/
          {0.3379,-2e-05,575.8631,0.13365,0.000641,0.4416}, /*cmy*/
          {1.243008,2.579,5.685,5.6482}, /*cfy*/
          {-0.8687,-0.0001,464.85,0.39895,0.002038,0.6412}, /*cmz*/
          {5.828148,2.3751,5.5334,2.9708} /*cfz*/
     },
     {
          2458081.4,
          {0.4481,0.00341,360.2964,0.04618,0.001588,0.6422}, /*cmx*/
          {4.926997,1.764,4.4176,3.8604}, /*cfx*/
          {0.3242,0.00086,574.9994,0.04424,0.000471,0.4635}, /*cmy*/
          {3.135766,1.6013,4.5188,3.0415}, /*cfy*/
          {-1.4754,0.00401,469.0201,0.07407,0.001492,0.1446}, /*cmz*/
          {1.439079,0.8489,4.2821,1.1477} /*cfz*/
     },
     {
          2458287.4,
          {0.526,0.00274,410.1544,0.0476,0.00099,0.4387}, /*cmx*/
          {0.455987,0.5578,3.2261,5.342}, /*cfx*/
          {0.2307,0.00043,578.7373,0.05054,0.000371,0.7896}, /*cmy*/
          {5.043773,0.1519,3.2514,0.0691}, /*cfy*/
          {-1.1972,0.00352,421.1903,0.06057,0.000995,0.7215}, /*cmz*/
          {3.355462,5.8207,2.9718,5.1479} /*cfz*/
     },
     {
          2458493.4,
          {0.9259,-0.00083,381.7096,0.34697,6.4e-05,0.8491}, /*cmx*/
          {2.389075,1.8087,4.2841,6.0532}, /*cfx*/
          {0.5337,0.0,577.0189,0.04028,6.7e-05,0.4195}, /*cmy*/
          {0.644522,1.5592,2.534,4.1105}, /*cfy*/
          {-0.8794,-0.00036,450.0778,0.29243,0.00021,0.3904}, /*cmz*/
          {5.232256,1.9319,1.3023,0.4605} /*cfz*/
     },
     {
          2458699.4,
          {1.5002,-0.00562,442.859,0.33673,0.000875,0.4075}, /*cmx*/
          {4.19693,0.4984,3.5428,2.3027}, /*cfx*/
          {0.3687,-0.00097,581.6394,0.02442,8.8e-05,0.3754}, /*cmy*/
          {2.552915,6.1935,1.5504,0.9251}, /*cfy*/
          {-0.3733,-0.00493,383.4818,0.34263,0.000835,0.7782}, /*cmz*/
          {0.883477,0.6193,3.8111,0.6923} /*cfz*/
     },
     {
          2458905.4,
          {0.9594,-0.00127,414.2974,0.56369,0.001473,0.3496}, /*cmx*/
          {6.123464,5.57,2.4053,1.6758}, /*cfx*/
          {0.4726,0.00033,579.5742,0.04699,0.000106,0.454}, /*cmy*/
          {4.436572,5.252,1.7605,5.3415}, /*cfy*/
          {-0.7577,-9e-05,417.417,0.60207,0.001478,0.7516}, /*cmz*/
          {2.750282,5.6677,2.5558,2.9919} /*cfz*/
     },
     {
          2459111.4,
          {0.851,0.00117,462.1968,0.46763,0.002116,0.7375}, /*cmx*/
          {1.674687,4.3325,1.165,3.6673}, /*cfx*/
          {0.354,0.00041,582.3298,0.03145,9.8e-05,0.3982}, /*cmy*/
          {0.055553,4.062,0.169,3.2973}, /*cfy*/
          {-1.0982,0.00136,358.3225,0.53948,0.002382,0.1959}, /*cmz*/
          {4.685287,4.4062,1.2827,2.2543} /*cfz*/
     },
     {
          2455197.0,
          {-0.0712,0.00018,44.6479,2.21065,0.035367,0.1932}, /*cmx*/
          {1.778805,0.0213,4.1046,-3.2943}, /*cfx*/
          {0.0514,-0.00036,127.1107,6.18994,0.102312,0.3686}, /*cmy*/
          {5.469862,3.7493,1.5238,-0.1281}, /*cfy*/
          {0.2654,-0.00131,134.4505,7.06588,0.108497,0.369}, /*cmz*/
          {3.873768,2.0575,5.9985,-0.2166} /*cfz*/
     },
     {
          2455238.0,
          {-0.0818,0.00012,46.9011,2.35815,0.037684,0.2129}, /*cmx*/
          {1.749219,6.2759,4.0695,-3.3179}, /*cfx*/
          {0.043,-0.00085,126.8226,6.15036,0.101599,0.3409}, /*cmy*/
          {5.50852,3.7936,1.5671,-0.0948}, /*cfy*/
          {0.2292,5e-05,133.7352,6.95755,0.106074,0.3751}, /*cmz*/
          {3.900853,2.084,6.0282,-0.287} /*cfz*/
     },
     {
          2455279.0,
          {-0.0902,0.00029,50.0299,2.49111,0.039189,0.225}, /*cmx*/
          {1.711029,6.235,4.0252,-3.312}, /*cfx*/
          {0.0123,-0.0002,126.5841,6.13286,0.101565,0.3128}, /*cmy*/
          {5.561821,3.8532,1.6239,-0.1227}, /*cfy*/
          {0.2448,-0.00104,132.6293,6.81432,0.102948,0.3756}, /*cmz*/
          {3.938378,2.1211,6.0724,-0.2072} /*cfz*/
     },
     {
          2455320.0,
          {-0.0871,0.00031,53.0302,2.57883,0.039749,0.2259}, /*cmx*/
          {1.696407,6.2136,3.9998,-3.3184}, /*cfx*/
          {0.0103,-0.0009,126.4107,6.15979,0.102598,0.286}, /*cmy*/
          {5.62616,3.9218,1.6857,-0.0502}, /*cfy*/
          {0.2205,6e-05,131.4222,6.6865,0.100309,0.3869}, /*cmz*/
          {3.987277,2.1712,6.1313,-0.262} /*cfz*/
     },
     {
          2455361.0,
          {-0.0773,0.00033,54.871,2.58802,0.039095,0.2169}, /*cmx*/
          {1.718329,6.2254,4.0097,-3.3175}, /*cfx*/
          {-0.0298,0.0002,126.3218,6.22405,0.104399,0.2536}, /*cmy*/
          {5.692458,3.9888,1.744,-0.1096}, /*cfy*/
          {0.2505,-0.00088,130.7536,6.61353,0.098719,0.4114}, /*cmz*/
          {4.04239,2.2273,6.197,-0.2022} /*cfz*/
     },
     {
          2455402.0,
          {-0.0671,0.00053,54.8549,2.51925,0.037667,0.1997}, /*cmx*/
          {1.778629,6.2792,4.0652,-3.2939}, /*cfx*/
          {-0.0172,-0.00092,126.221,6.31664,0.106738,0.237}, /*cmy*/
          {5.751199,4.045,1.7895,-6.2758}, /*cfy*/
          {0.2528,-0.00018,130.9345,6.62493,0.098872,0.4415}, /*cmz*/
          {4.097202,2.2825,6.2587,-0.2288} /*cfz*/
     },
     {
          2455443.0,
          {-0.047,0.00019,53.1804,2.41148,0.036361,0.1801}, /*cmx*/
          {1.868116,0.0909,4.1705,-3.3157}, /*cfx*/
          {-0.0416,0.00034,126.1214,6.3985,0.108648,0.2268}, /*cmy*/
          {5.794532,4.0843,1.8204,-0.1095}, /*cfy*/
          {0.275,-0.00067,131.9757,6.70057,0.100064,0.4676}, /*cmz*/
          {4.143755,2.3255,0.0203,-0.207} /*cfz*/
     },
     {
          2455484.0,
          {-0.0442,0.00042,51.0254,2.35145,0.036696,0.1703}, /*cmx*/
          {1.965143,0.2084,4.297,-3.2579}, /*cfx*/
          {-0.0139,-0.00087,125.9639,6.4448,0.109611,0.2339}, /*cmy*/
          {5.822292,4.1095,1.8395,-6.2731}, /*cfy*/
          {0.2738,-0.00049,133.1577,6.78646,0.101392,0.4813}, /*cmz*/
          {4.178549,2.3545,0.0471,-0.2182} /*cfz*/
     },
     {
          2455525.0,
          {-0.0363,-7e-05,49.8812,2.38877,0.038774,0.1722}, /*cmx*/
          {2.035284,0.2991,4.3868,-3.3035}, /*cfx*/
          {-0.0454,0.00046,125.8485,6.43803,0.109189,0.2165}, /*cmy*/
          {5.842944,4.1295,1.8577,-0.1069}, /*cfy*/
          {0.2721,-0.00068,133.8403,6.81974,0.101612,0.4871}, /*cmz*/
          {4.203101,2.3737,0.0637,-0.2185} /*cfz*/
     },
     {
          2455566.0,
          {-0.0556,0.00041,50.4607,2.50188,0.041568,0.1885}, /*cmx*/
          {2.055299,0.3311,4.4125,-3.2453}, /*cfx*/
          {-0.0299,-0.00088,125.7054,6.40457,0.108114,0.2025}, /*cmy*/
          {5.868171,4.1563,1.8832,-6.2425}, /*cfy*/
          {0.2671,-0.00095,133.6766,6.77422,0.100522,0.4815}, /*cmz*/
          {4.224825,2.3931,0.0835,-0.2044} /*cfz*/
     },
     {
          2455607.0,
          {-0.0566,-5e-05,52.6316,2.63766,0.043848,0.2061}, /*cmx*/
          {2.036652,0.3158,4.3954,-3.323}, /*cfx*/
          {-0.0643,0.00027,125.6609,6.36897,0.106964,0.1682}, /*cmy*/
          {5.906829,4.1967,1.9228,-0.0849}, /*cfy*/
          {0.2417,-0.00042,132.7313,6.65592,0.098143,0.4767}, /*cmz*/
          {4.251735,2.4202,0.1151,-0.2337} /*cfz*/
     },
     {
          2455648.0,
          {-0.0741,0.00058,55.6756,2.75986,0.045329,0.2224}, /*cmx*/
          {2.010955,0.289,4.3688,-3.2619}, /*cfx*/
          {-0.0588,-0.00082,125.6769,6.36626,0.106582,0.1489}, /*cmy*/
          {5.960288,4.2512,1.973,-6.1782}, /*cfy*/
          {0.2421,-0.00102,131.2234,6.49526,0.095237,0.4708}, /*cmz*/
          {4.289078,2.4605,0.1655,-0.1901} /*cfz*/
     },
     {
          2455689.0,
          {-0.0599,1e-05,58.582,2.83709,0.045719,0.2226}, /*cmx*/
          {2.006226,0.277,4.3568,-3.3221}, /*cfx*/
          {-0.0981,0.00019,125.8571,6.4007,0.107012,0.1039}, /*cmy*/
          {6.024713,4.3134,2.0289,-6.2423}, /*cfy*/
          {0.2173,-0.00015,129.6161,6.34469,0.092725,0.4713}, /*cmz*/
          {4.337593,2.5148,0.233,-0.2229} /*cfz*/
     },
     {
          2455730.0,
          {-0.0654,0.00071,60.3077,2.84547,0.045099,0.2147}, /*cmx*/
          {2.03386,0.2951,4.3723,-3.2452}, /*cfx*/
          {-0.1049,-0.00046,126.02,6.47507,0.108336,0.0809}, /*cmy*/
          {6.091077,4.3747,2.081,-5.9457}, /*cfy*/
          {0.2399,-0.00117,128.5876,6.25142,0.091555,0.4764}, /*cmz*/
          {4.392946,2.5779,0.311,-0.1596} /*cfz*/
     },
     {
          2455771.0,
          {-0.0399,6e-05,60.2071,2.78192,0.043644,0.1928}, /*cmx*/
          {2.095772,0.3485,4.4236,-3.322}, /*cfx*/
          {-0.1264,0.00014,126.1571,6.56697,0.110119,0.048}, /*cmy*/
          {6.150498,4.4268,2.124,-5.8596}, /*cfy*/
          {0.2226,5e-05,128.6191,6.25047,0.092038,0.4956}, /*cmz*/
          {4.448582,2.6394,0.383,-0.2233} /*cfz*/
     },
     {
          2455812.0,
          {-0.0355,0.00056,58.4214,2.68748,0.042496,0.1729}, /*cmx*/
          {2.182811,0.4383,4.5129,-3.2402}, /*cfx*/
          {-0.1273,-0.00014,126.132,6.65485,0.111809,0.0474}, /*cmy*/
          {6.194808,4.464,2.1525,-5.6177}, /*cfy*/
          {0.2611,-0.00125,129.6847,6.3191,0.093611,0.5215}, /*cmz*/
          {4.496262,2.688,0.4364,-0.1584} /*cfz*/
     },
     {
          2455853.0,
          {-0.0137,2e-05,56.1161,2.64104,0.042897,0.1511}, /*cmx*/
          {2.276416,0.5461,4.6174,-3.2864}, /*cfx*/
          {-0.1297,3e-05,126.062,6.69883,0.112533,0.0386}, /*cmy*/
          {6.223773,4.4884,2.1719,-5.4417}, /*cfy*/
          {0.2405,1e-05,130.989,6.40844,0.095174,0.5375}, /*cmz*/
          {4.53266,2.7205,0.4669,-0.216} /*cfz*/
     },
     {
          2455894.0,
          {-0.017,0.00033,54.7692,2.68746,0.045135,0.1476}, /*cmx*/
          {2.344339,0.6319,4.6937,-3.2115}, /*cfx*/
          {-0.1332,0.00017,125.95,6.69219,0.111981,0.0356}, /*cmy*/
          {6.244687,4.5078,2.1893,-5.4402}, /*cfy*/
          {0.266,-0.00143,131.7804,6.44532,0.095638,0.538}, /*cmz*/
          {4.558394,2.7413,0.4856,-0.1532} /*cfz*/
     },
     {
          2455935.0,
          {-0.0166,2e-05,55.1711,2.80109,0.048009,0.154}, /*cmx*/
          {2.367829,0.6668,4.721,-3.267}, /*cfx*/
          {-0.1269,-0.00013,125.9345,6.64962,0.110561,0.0368}, /*cmy*/
          {6.270194,4.5336,2.2157,-4.8651}, /*cfy*/
          {0.2251,-8e-05,131.5831,6.40804,0.09474,0.5293}, /*cmz*/
          {4.581486,2.7618,0.5049,-0.2248} /*cfz*/
     },
     {
          2455976.0,
          {-0.0281,0.00031,57.1764,2.93187,0.050443,0.1717}, /*cmx*/
          {2.355605,0.6612,4.7141,-3.2382}, /*cfx*/
          {-0.1498,0.00037,126.0534,6.60886,0.108973,0.0346}, /*cmy*/
          {0.024945,4.571,2.2534,-4.1202}, /*cfy*/
          {0.2369,-0.0014,130.4623,6.28862,0.092626,0.5196}, /*cmz*/
          {4.608926,2.7906,0.5387,-0.1625} /*cfz*/
     },
     {
          2456017.0,
          {-0.0302,0.00023,60.0826,3.04672,0.05193,0.1816}, /*cmx*/
          {2.338082,0.6436,4.6987,-3.2611}, /*cfx*/
          {-0.146,-0.00045,126.3527,6.59132,0.107878,0.0728}, /*cmy*/
          {0.077664,4.6213,2.3027,-3.9184}, /*cfy*/
          {0.1967,-0.00021,128.608,6.1348,0.090303,0.5034}, /*cmz*/
          {4.647686,2.8355,0.5926,-0.2081} /*cfz*/
     },
     {
          2456058.0,
          {-0.0308,0.00032,62.8614,3.11618,0.05231,0.1863}, /*cmx*/
          {2.33842,0.6386,4.6949,-3.247}, /*cfx*/
          {-0.1812,0.00051,126.7655,6.61056,0.10749,0.091}, /*cmy*/
          {0.14039,4.6784,2.3566,-3.5306}, /*cfy*/
          {0.2029,-0.00118,126.691,5.98507,0.088505,0.4876}, /*cmz*/
          {4.697107,2.8957,0.6667,-0.1481} /*cfz*/
     },
     {
          2456099.0,
          {-0.0248,0.00029,64.4993,3.12168,0.051559,0.1766}, /*cmx*/
          {2.36958,0.6591,4.713,-3.251}, /*cfx*/
          {-0.1739,-0.00049,127.1643,6.66409,0.108011,0.1314}, /*cmy*/
          {0.206052,4.7361,2.409,-3.6567}, /*cfy*/
          {0.1752,-0.00024,125.3672,5.90433,0.088263,0.4782}, /*cmz*/
          {4.754616,2.9668,0.7505,-0.1904} /*cfz*/
     },
     {
          2456140.0,
          {-0.0095,0.00011,64.3478,3.05986,0.049979,0.1576}, /*cmx*/
          {2.431309,0.7102,4.7596,-3.2591}, /*cfx*/
          {-0.2192,0.00081,127.4684,6.74089,0.109077,0.1572}, /*cmy*/
          {0.264879,4.7849,2.4515,-3.4279}, /*cfy*/
          {0.1888,-0.0009,125.2689,5.90957,0.089591,0.486}, /*cmz*/
          {4.811792,3.0358,0.8291,-0.1505} /*cfz*/
     },
     {
          2456181.0,
          {-0.0015,0.00039,62.5347,2.97437,0.048631,0.1304}, /*cmx*/
          {2.516939,0.7913,4.8342,-3.2048}, /*cfx*/
          {-0.2037,-0.00042,127.5483,6.81464,0.110305,0.1845}, /*cmy*/
          {0.309856,4.8215,2.4817,-3.5636}, /*cfy*/
          {0.1869,-0.00048,126.2894,5.99866,0.092086,0.4995}, /*cmz*/
          {4.862296,3.0915,0.8858,-0.168} /*cfz*/
     },
     {
          2456222.0,
          {0.0187,-2e-05,60.1709,2.93494,0.048785,0.1063}, /*cmx*/
          {2.606616,0.8869,4.9207,-3.2476}, /*cfx*/
          {-0.2294,0.0009,127.5083,6.85195,0.110723,0.184}, /*cmy*/
          {0.339223,4.8453,2.5017,-3.4068}, /*cfy*/
          {0.1976,-0.00069,127.7389,6.09586,0.094092,0.5138}, /*cmz*/
          {4.900123,3.1271,0.9186,-0.1577} /*cfz*/
     },
     {
          2456263.0,
          {0.0167,0.00037,58.7145,2.98774,0.050863,0.0958}, /*cmx*/
          {2.67315,0.9641,4.9854,-3.1195}, /*cfx*/
          {-0.1979,-0.00027,127.4076,6.83841,0.110071,0.1899}, /*cmy*/
          {0.360937,4.8656,2.5212,-3.5553}, /*cfy*/
          {0.1956,-0.00069,128.6073,6.14708,0.094879,0.517}, /*cmz*/
          {4.927858,3.1498,0.9368,-0.1635} /*cfz*/
     },
     {
          2456304.0,
          {0.0294,-0.00016,58.9943,3.10468,0.053755,0.0937}, /*cmx*/
          {2.697889,0.9986,5.0114,-3.2193}, /*cfx*/
          {-0.225,0.00102,127.4653,6.78619,0.108379,0.2005}, /*cmy*/
          {0.385934,4.8907,2.5487,-3.4065}, /*cfy*/
          {0.1803,-0.0005,128.4329,6.11145,0.093987,0.5072}, /*cmz*/
          {4.951766,3.1704,0.956,-0.1728} /*cfz*/
     },
     {
          2456345.0,
          {0.0142,0.00049,60.878,3.23877,0.056339,0.1048}, /*cmx*/
          {2.690454,0.9983,5.0088,-3.0936}, /*cfx*/
          {-0.2063,-0.00015,127.6566,6.72696,0.106458,0.2241}, /*cmy*/
          {0.422996,4.9278,2.5893,-3.4984}, /*cfy*/
          {0.1752,-0.00105,127.1535,6.01011,0.092292,0.4874}, /*cmz*/
          {4.981195,3.2015,0.9879,-0.148} /*cfz*/
     },
     {
          2456386.0,
          {0.0222,-9e-05,63.6802,3.35031,0.057895,0.1122}, /*cmx*/
          {2.677081,0.9871,5.0003,-3.2404}, /*cfx*/
          {-0.2293,0.00072,128.0815,6.68388,0.104739,0.2467}, /*cmy*/
          {0.473654,4.976,2.6412,-3.3928}, /*cfy*/
          {0.1434,-0.00033,125.15,5.86917,0.09029,0.4627}, /*cmz*/
          {5.021285,3.2483,1.0401,-0.1797} /*cfz*/
     },
     {
          2456427.0,
          {0.0085,0.00054,66.3605,3.41803,0.058316,0.1209}, /*cmx*/
          {2.680895,0.9866,5.0008,-3.1187}, /*cfx*/
          {-0.2218,-7e-05,128.5712,6.67238,0.103731,0.272}, /*cmy*/
          {0.534567,5.032,2.6991,-3.4402}, /*cfy*/
          {0.141,-0.00114,123.0077,5.74874,0.089296,0.4406}, /*cmz*/
          {5.073181,3.3134,1.1114,-0.1278} /*cfz*/
     },
     {
          2456468.0,
          {0.0287,-0.00023,67.966,3.41858,0.05742,0.1087}, /*cmx*/
          {2.712931,1.0075,5.0202,-3.2408}, /*cfx*/
          {-0.2507,0.00062,129.0751,6.69162,0.103449,0.3052}, /*cmy*/
          {0.598158,5.0881,2.7554,-3.3803}, /*cfy*/
          {0.1023,-8e-05,121.5513,5.69579,0.089791,0.4148}, /*cmz*/
          {5.133081,3.3891,1.1925,-0.1688} /*cfz*/
     },
     {
          2456509.0,
          {0.0241,0.0004,67.7998,3.3548,0.055606,0.0938}, /*cmx*/
          {2.77355,1.0543,5.0615,-3.0801}, /*cfx*/
          {-0.2612,0.00028,129.3754,6.73794,0.103945,0.3328}, /*cmy*/
          {0.656132,5.1374,2.803,-3.3917}, /*cfy*/
          {0.115,-0.00122,121.376,5.74386,0.092237,0.4048}, /*cmz*/
          {5.193402,3.4638,1.2666,-0.0953} /*cfz*/
     },
     {
          2456550.0,
          {0.0455,-0.0002,66.0023,3.2614,0.053751,0.0646}, /*cmx*/
          {2.855433,1.1255,5.1267,-3.2176}, /*cfx*/
          {-0.2723,0.00045,129.4947,6.79074,0.104689,0.3559}, /*cmy*/
          {0.700934,5.1742,2.8367,-3.3882}, /*cfy*/
          {0.0905,9e-05,122.496,5.86217,0.095388,0.4049}, /*cmz*/
          {5.246169,3.5222,1.3205,-0.1706} /*cfz*/
     },
     {
          2456591.0,
          {0.0476,0.00031,63.5945,3.21637,0.053393,0.0448}, /*cmx*/
          {2.940568,1.2085,5.2008,-2.8991}, /*cfx*/
          {-0.2759,0.00059,129.4321,6.81785,0.104951,0.3619}, /*cmy*/
          {0.73095,5.1991,2.8596,-3.3782}, /*cfy*/
          {0.1207,-0.00115,124.0546,5.98593,0.098059,0.4224}, /*cmz*/
          {5.285782,3.5599,1.351,-0.0972} /*cfz*/
     },
     {
          2456632.0,
          {0.0675,-0.00011,62.1039,3.26282,0.05501,0.0215}, /*cmx*/
          {3.003759,1.2758,5.2579,-2.781}, /*cfx*/
          {-0.2659,0.00043,129.3461,6.79668,0.1042,0.3681}, /*cmy*/
          {0.752774,5.2203,2.8815,-3.3953}, /*cfy*/
          {0.0941,0.00017,125.0543,6.04658,0.098917,0.4195}, /*cmz*/
          {5.314807,3.5823,1.368,-0.1671} /*cfz*/
     },
     {
          2456673.0,
          {0.0673,0.00022,62.3162,3.38228,0.057787,0.0249}, /*cmx*/
          {3.028214,1.3075,5.2811,-2.3415}, /*cfx*/
          {-0.2716,0.001,129.3526,6.7356,0.102552,0.3675}, /*cmy*/
          {0.77745,5.2467,2.9129,-3.3549}, /*cfy*/
          {0.1127,-0.00114,124.8942,6.02145,0.098165,0.412}, /*cmz*/
          {5.339674,3.603,1.3846,-0.0939} /*cfz*/
     },
     {
          2456714.0,
          {0.0709,0.0,64.1798,3.5195,0.060415,0.0219}, /*cmx*/
          {3.023261,1.3098,5.2817,-2.503}, /*cfx*/
          {-0.2487,0.00021,129.5482,6.66278,0.100607,0.3817}, /*cmy*/
          {0.813357,5.285,2.9582,-3.4064}, /*cfy*/
          {0.0768,4e-05,123.5911,5.92454,0.096188,0.3854}, /*cmz*/
          {5.370445,3.6325,1.413,-0.1728} /*cfz*/
     },
     {
          2456755.0,
          {0.0668,0.00018,66.9416,3.63799,0.062152,0.0324}, /*cmx*/
          {3.012782,1.3028,5.2758,-2.6222}, /*cfx*/
          {-0.2687,0.0011,129.9332,6.59763,0.098764,0.3967}, /*cmy*/
          {0.862136,5.3341,3.0161,-3.3379}, /*cfy*/
          {0.0802,-0.00106,121.4785,5.79991,0.094253,0.3639}, /*cmz*/
          {5.4119,3.6793,1.4594,-0.0969} /*cfz*/
     },
     {
          2456796.0,
          {0.0681,5e-05,69.6394,3.70592,0.062606,0.031}, /*cmx*/
          {3.018581,1.305,5.2793,-2.6722}, /*cfx*/
          {-0.2496,-1e-05,130.3539,6.55724,0.097563,0.4192}, /*cmy*/
          {0.920923,5.392,3.0817,-3.3881}, /*cfy*/
          {0.0401,-0.00016,119.2875,5.70479,0.093242,0.3239}, /*cmz*/
          {5.466418,3.7433,1.5228,-0.1435} /*cfz*/
     },
     {
          2456837.0,
          {0.0717,-6e-05,71.2341,3.70538,0.061666,0.029}, /*cmx*/
          {3.049956,1.3254,5.2978,-2.6924}, /*cfx*/
          {-0.2835,0.00121,130.7391,6.54418,0.097051,0.4344}, /*cmy*/
          {0.982692,5.4502,3.1467,-3.3085}, /*cfy*/
          {0.0311,-0.00086,117.8258,5.68846,0.094073,0.2943}, /*cmz*/
          {5.528357,3.8184,1.5943,-0.0683} /*cfz*/
     },
     {
          2456878.0,
          {0.0705,0.0,71.0912,3.63082,0.059566,0.0199}, /*cmx*/
          {3.107981,1.368,5.3369,-2.1842}, /*cfx*/
          {-0.2649,-0.00011,130.9401,6.56544,0.097393,0.4576}, /*cmy*/
          {1.039954,5.5026,3.2017,-3.3841}, /*cfy*/
          {0.0029,-0.0002,117.766,5.77367,0.096728,0.2644}, /*cmz*/
          {5.59136,3.8913,1.6603,-0.1096} /*cfz*/
     },
     {
          2456919.0,
          {0.0848,-0.00028,69.2632,3.52307,0.057237,0.0154}, /*cmx*/
          {3.184385,1.4302,5.3952,-0.8782}, /*cfx*/
          {-0.3054,0.00131,131.0004,6.59701,0.097932,0.4786}, /*cmy*/
          {1.084468,5.5413,3.2412,-3.3133}, /*cfy*/
          {-0.0006,-0.00047,119.041,5.9291,0.100375,0.2607}, /*cmz*/
          {5.645368,3.9485,1.7078,-0.0649} /*cfz*/
     },
     {
          2456960.0,
          {0.0867,0.00019,66.8187,3.45566,0.056206,0.0442}, /*cmx*/
          {3.263134,1.5024,5.4633,-0.5933}, /*cfx*/
          {-0.2813,5e-05,130.8599,6.61692,0.098267,0.4904}, /*cmy*/
          {1.115061,5.569,3.2682,-3.3754}, /*cfy*/
          {-0.0015,-0.0003,120.8213,6.07909,0.103297,0.2593}, /*cmz*/
          {5.686461,3.9844,1.7344,-0.0728} /*cfz*/
     },
     {
          2457001.0,
          {0.1087,-0.00025,65.2624,3.48623,0.057242,0.0606}, /*cmx*/
          {3.320617,1.5607,5.5155,-0.3133}, /*cfx*/
          {-0.3014,0.00142,130.7479,6.59188,0.097631,0.4859}, /*cmy*/
          {1.136903,5.5914,3.2935,-3.3106}, /*cfy*/
          {-0.0006,-0.00014,121.9543,6.14981,0.104278,0.266}, /*cmz*/
          {5.715148,4.0053,1.7487,-0.0812} /*cfz*/
     },
     {
          2457042.0,
          {0.1045,0.0003,65.4838,3.60001,0.059762,0.0759}, /*cmx*/
          {3.343445,1.5897,5.5388,-0.4931}, /*cfx*/
          {-0.262,0.00022,130.6943,6.53527,0.096411,0.482}, /*cmy*/
          {1.161608,5.6203,3.3283,-3.3751}, /*cfy*/
          {0.0059,-0.0004,121.8403,6.12148,0.103221,0.2576}, /*cmz*/
          {5.740692,4.0239,1.7635,-0.0654} /*cfz*/
     },
     {
          2457083.0,
          {0.1238,-0.00034,67.4157,3.74461,0.0624,0.0766}, /*cmx*/
          {3.339499,1.5926,5.5395,-0.3334}, /*cfx*/
          {-0.276,0.00137,130.8503,6.45779,0.094766,0.4849}, /*cmy*/
          {1.196128,5.6598,3.3782,-3.3174}, /*cfy*/
          {-0.016,9e-05,120.4849,6.0167,0.100821,0.2368}, /*cmz*/
          {5.771468,4.0513,1.7888,-0.1023} /*cfz*/
     },
     {
          2457124.0,
          {0.1109,0.00035,70.2751,3.87166,0.064295,0.0799}, /*cmx*/
          {3.331589,1.5887,5.5362,-0.5301}, /*cfx*/
          {-0.2499,0.0004,131.0669,6.39095,0.093562,0.4907}, /*cmy*/
          {1.243791,5.7131,3.4426,-3.3526}, /*cfy*/
          {-0.0154,-0.00073,118.3295,5.88974,0.098283,0.2055}, /*cmz*/
          {5.814429,4.0945,1.8298,-0.0171} /*cfz*/
     },
     {
          2457165.0,
          {0.124,-0.00042,73.0569,3.94696,0.06486,0.0713}, /*cmx*/
          {3.338412,1.5924,5.5404,-0.3304}, /*cfx*/
          {-0.2601,0.00105,131.3601,6.33864,0.092761,0.4957}, /*cmy*/
          {1.300728,5.7739,3.5152,-3.3108}, /*cfy*/
          {-0.0517,9e-05,116.1298,5.79472,0.096638,0.1692}, /*cmz*/
          {5.869481,4.1538,1.8864,-0.0927} /*cfz*/
     },
     {
          2457206.0,
          {0.1065,0.00019,74.7093,3.94733,0.064001,0.0741}, /*cmx*/
          {3.369357,1.6131,5.5594,-0.5334}, /*cfx*/
          {-0.2469,0.00045,131.5362,6.31886,0.092848,0.5028}, /*cmy*/
          {1.361807,5.8373,3.5874,-3.3319}, /*cfy*/
          {-0.0552,-0.00083,114.7378,5.78846,0.096923,0.1362}, /*cmz*/
          {5.932981,4.2236,1.9509,-6.1914} /*cfz*/
     },
     {
          2457247.0,
          {0.1234,-0.00066,74.5985,3.8664,0.061771,0.0795}, /*cmx*/
          {3.423604,1.6516,5.5958,-0.2739}, /*cfx*/
          {-0.2587,0.00077,131.6025,6.32506,0.093437,0.516}, /*cmy*/
          {1.418317,5.8934,3.6493,-3.3142}, /*cfy*/
          {-0.1051,0.00036,114.8629,5.88974,0.099221,0.0941}, /*cmz*/
          {5.996358,4.291,2.0105,-0.0158} /*cfz*/
     },
     {
          2457288.0,
          {0.1123,4e-05,72.7105,3.74027,0.059136,0.0967}, /*cmx*/
          {3.493834,1.7076,5.6514,-0.3774}, /*cfx*/
          {-0.2657,0.00076,131.4891,6.35542,0.0945,0.5288}, /*cmy*/
          {1.463683,5.9373,3.6943,-3.3144}, /*cfy*/
          {-0.0979,-0.00074,116.3924,6.06787,0.102787,0.0828}, /*cmz*/
          {6.050833,4.3437,2.0525,-5.9207} /*cfz*/
     },
     {
          2457329.0,
          {0.1292,-0.00041,70.1751,3.64741,0.05753,0.1166}, /*cmx*/
          {3.564392,1.771,5.7163,-0.2277}, /*cfx*/
          {-0.2646,0.00061,131.3291,6.37262,0.09499,0.5366}, /*cmy*/
          {1.494571,5.9668,3.724,-3.3278}, /*cfy*/
          {-0.122,0.00056,118.4284,6.2312,0.105682,0.0695}, /*cmz*/
          {6.090891,4.3759,2.0758,-6.2238} /*cfz*/
     },
     {
          2457370.0,
          {0.13,0.00014,68.5371,3.65571,0.058063,0.1376}, /*cmx*/
          {3.615448,1.8233,5.7681,-0.3023}, /*cfx*/
          {-0.2649,0.00106,131.1629,6.3582,0.094848,0.5356}, /*cmy*/
          {1.517015,5.9916,3.7508,-3.3098}, /*cfy*/
          {-0.0911,-0.00052,119.682,6.30655,0.10664,0.0877}, /*cmz*/
          {6.119068,4.3946,2.0877,-5.9558} /*cfz*/
     },
     {
          2457411.0,
          {0.1507,-0.00027,68.8269,3.76009,0.06022,0.156}, /*cmx*/
          {3.635148,1.8491,5.7916,-0.2509}, /*cfx*/
          {-0.2382,0.00051,131.1,6.31026,0.094,0.5259}, /*cmy*/
          {1.541197,6.0212,3.7862,-3.334}, /*cfy*/
          {-0.1126,0.00071,119.5923,6.26446,0.105212,0.0704}, /*cmz*/
          {6.143819,4.4111,2.1012,-6.2233} /*cfz*/
     },
     {
          2457452.0,
          {0.1533,2e-05,70.8948,3.9094,0.062838,0.1636}, /*cmx*/
          {3.632253,1.8534,5.7942,-0.2976}, /*cfx*/
          {-0.2403,0.0014,131.1548,6.25264,0.093278,0.5152}, /*cmy*/
          {1.575275,6.0636,3.8368,-3.2897}, /*cfy*/
          {-0.0946,-0.00039,118.1081,6.13921,0.102251,0.0666}, /*cmz*/
          {6.174511,4.4363,2.1247,-5.8564} /*cfz*/
     },
     {
          2457493.0,
          {0.1588,-0.00021,73.9673,4.04784,0.064832,0.1669}, /*cmx*/
          {3.626864,1.8517,5.7923,-0.2807}, /*cfx*/
          {-0.2051,0.00029,131.3063,6.2012,0.092768,0.5069}, /*cmy*/
          {1.621746,6.1182,3.9004,-3.3412}, /*cfy*/
          {-0.1171,0.0004,115.8353,5.9808,0.098795,0.0311}, /*cmz*/
          {6.217289,4.4762,2.1646,-5.9179} /*cfz*/
     },
     {
          2457534.0,
          {0.1558,-0.00016,76.9092,4.13514,0.065608,0.1632}, /*cmx*/
          {3.635861,1.8576,5.7979,-0.289}, /*cfx*/
          {-0.218,0.00142,131.4464,6.16682,0.092968,0.5059}, /*cmy*/
          {1.677756,6.1827,3.973,-3.276}, /*cfy*/
          {-0.1179,-0.00039,113.5087,5.86065,0.096237,0.0308}, /*cmz*/
          {6.272445,4.5314,2.2189,-4.8553} /*cfz*/
     },
     {
          2457575.0,
          {0.1536,-0.0003,78.7056,4.14161,0.06489,0.1647}, /*cmx*/
          {3.666482,1.8784,5.8172,-0.2793}, /*cfx*/
          {-0.1831,5e-05,131.4767,6.16095,0.093785,0.498}, /*cmy*/
          {1.738502,6.2494,4.0448,-3.3272}, /*cfy*/
          {-0.1529,0.00017,112.158,5.82961,0.095503,0.0502}, /*cmz*/
          {0.052334,4.5961,2.2822,-3.7094} /*cfz*/
     },
     {
          2457616.0,
          {0.1539,-0.00054,78.6135,4.0604,0.062784,0.1631}, /*cmx*/
          {3.717597,1.915,5.853,-0.2362}, /*cfx*/
          {-0.2074,0.00138,131.3956,6.18398,0.095328,0.4973}, /*cmy*/
          {1.795524,0.0274,4.1072,-3.2556}, /*cfy*/
          {-0.1743,-0.00012,112.3759,5.9201,0.09707,0.0868}, /*cmz*/
          {0.114602,4.6584,2.3397,-3.6354} /*cfz*/
     },
     {
          2457657.0,
          {0.1428,-0.00021,76.695,3.92416,0.060096,0.1728}, /*cmx*/
          {3.781629,1.9665,5.9069,-0.2702}, /*cfx*/
          {-0.1812,-6e-05,131.2238,6.22614,0.096846,0.4986}, /*cmy*/
          {1.842076,0.0741,4.152,-3.3327}, /*cfy*/
          {-0.1938,0.00014,114.1563,6.09422,0.100156,0.1177}, /*cmz*/
          {0.167482,4.7068,2.3805,-3.5477} /*cfz*/
     },
     {
          2457698.0,
          {0.1549,-0.00051,74.047,3.81136,0.058217,0.1873}, /*cmx*/
          {3.844171,2.0238,5.971,-0.1997}, /*cfx*/
          {-0.211,0.00136,131.0243,6.25437,0.097864,0.5104}, /*cmy*/
          {1.873737,0.1063,4.1823,-3.2671}, /*cfy*/
          {-0.2021,0.00033,116.3974,6.26416,0.102922,0.1233}, /*cmz*/
          {0.205734,4.7355,2.4005,-3.5334} /*cfz*/
     },
     {
          2457739.0,
          {0.1544,9e-05,72.3528,3.79757,0.058361,0.2108}, /*cmx*/
          {3.888348,2.0722,6.0245,-0.2545}, /*cfx*/
          {-0.179,0.00013,130.8536,6.25603,0.098021,0.5031}, /*cmy*/
          {1.897084,0.1317,4.2071,-3.3249}, /*cfy*/
          {-0.1897,0.00019,117.8003,6.33382,0.103711,0.1267}, /*cmz*/
          {0.232464,4.7521,2.411,-3.5767} /*cfz*/
     },
     {
          2457780.0,
          {0.1793,-0.00048,72.707,3.88992,0.060207,0.2259}, /*cmx*/
          {3.905257,2.0968,6.0509,-0.1935}, /*cfx*/
          {-0.189,0.00138,130.8055,6.22798,0.097741,0.4915}, /*cmy*/
          {1.920791,0.1615,4.2392,-3.2614}, /*cfy*/
          {-0.1899,0.00071,117.6,6.27652,0.102002,0.1156}, /*cmz*/
          {0.256098,4.767,2.423,-3.4892} /*cfz*/
     },
     {
          2457821.0,
          {0.1732,0.00015,74.9892,4.04174,0.062741,0.2402}, /*cmx*/
          {3.904141,2.1032,6.0565,-0.276}, /*cfx*/
          {-0.1489,0.00026,130.866,6.19696,0.097445,0.47}, /*cmy*/
          {1.954521,0.2027,4.2831,-3.3215}, /*cfy*/
          {-0.1659,4e-05,115.9037,6.11848,0.098521,0.1265}, /*cmz*/
          {0.286643,4.7919,2.4481,-3.5889} /*cfz*/
     },
     {
          2457862.0,
          {0.195,-0.00065,78.322,4.18972,0.064752,0.2466}, /*cmx*/
          {3.902293,2.1039,6.0569,-0.2052}, /*cfx*/
          {-0.1492,0.00117,130.9918,6.17081,0.09756,0.4578}, /*cmy*/
          {1.999478,0.2565,4.3398,-3.2663}, /*cfy*/
          {-0.1852,0.00078,113.3199,5.92212,0.094322,0.1382}, /*cmz*/
          {0.329154,4.8305,2.4894,-3.414} /*cfz*/
     },
     {
          2457903.0,
          {0.1788,7e-05,81.4793,4.2886,0.065727,0.2512}, /*cmx*/
          {3.914646,2.1136,6.0655,-0.2731}, /*cfx*/
          {-0.1199,0.00048,131.0752,6.1715,0.09834,0.4369}, /*cmy*/
          {2.055412,0.3201,4.4032,-3.2933}, /*cfy*/
          {-0.1742,-0.00026,110.7325,5.75457,0.090864,0.17}, /*cmz*/
          {0.384096,4.8852,2.5487,-3.5014} /*cfz*/
     },
     {
          2457944.0,
          {0.1919,-0.00086,83.4325,4.30465,0.065205,0.2451}, /*cmx*/
          {3.946189,2.1354,6.0865,-0.1846}, /*cfx*/
          {-0.1147,0.00084,131.0844,6.19409,0.099781,0.4227}, /*cmy*/
          {2.115565,0.3869,4.4675,-3.256}, /*cfy*/
          {-0.2121,0.00068,109.177,5.68162,0.089177,0.1965}, /*cmz*/
          {0.445894,4.9481,2.6166,-3.3477} /*cfz*/
     },
     {
          2457985.0,
          {0.1659,-9e-05,83.4186,4.23233,0.063438,0.2425}, /*cmx*/
          {3.995721,2.1724,6.123,-0.2625}, /*cfx*/
          {-0.0997,0.00046,130.9852,6.2479,0.1018,0.4075}, /*cmy*/
          {2.174064,0.4485,4.5237,-3.2737}, /*cfy*/
          {-0.2112,-0.00035,109.3594,5.73924,0.090023,0.2363}, /*cmz*/
          {0.50663,5.0096,2.6796,-3.4528} /*cfz*/
     },
     {
          2458026.0,
          {0.1778,-0.00089,81.5195,4.09569,0.060898,0.2443}, /*cmx*/
          {4.054449,2.2203,6.176,-0.1773}, /*cfx*/
          {-0.0935,0.00039,130.8267,6.31017,0.1038,0.4042}, /*cmy*/
          {2.221691,0.4968,4.5659,-3.2679}, /*cfy*/
          {-0.2592,0.00092,111.2676,5.8976,0.092542,0.2689}, /*cmz*/
          {0.55686,5.0549,2.7211,-3.3489} /*cfz*/
     },
     {
          2458067.0,
          {0.1628,-6e-05,78.7873,3.97411,0.059125,0.2551}, /*cmx*/
          {4.110383,2.2753,6.2411,-0.2318}, /*cfx*/
          {-0.0995,0.00073,130.6503,6.36329,0.10521,0.4018}, /*cmy*/
          {2.25569,0.5299,4.5931,-3.2548}, /*cfy*/
          {-0.245,-7e-05,113.6721,6.06099,0.095112,0.2885}, /*cmz*/
          {0.592958,5.082,2.7405,-3.4389} /*cfz*/
     },
     {
          2458108.0,
          {0.1818,-0.00054,77.0778,3.94345,0.059058,0.2709}, /*cmx*/
          {4.148634,2.3208,0.0142,-0.1782}, /*cfx*/
          {-0.0872,0.00027,130.5464,6.3772,0.105557,0.3991}, /*cmy*/
          {2.279209,0.5546,4.6154,-3.2812}, /*cfy*/
          {-0.2585,0.00112,115.1477,6.12535,0.095704,0.2816}, /*cmz*/
          {0.61787,5.096,2.7482,-3.3546} /*cfz*/
     },
     {
          2458149.0,
          {0.181,0.0,77.5074,4.02552,0.060756,0.289}, /*cmx*/
          {4.164397,2.3471,0.0454,-0.2265}, /*cfx*/
          {-0.0903,0.00095,130.5348,6.36947,0.105419,0.3881}, /*cmy*/
          {2.303227,0.5824,4.6419,-3.2436}, /*cfy*/
          {-0.2191,0.00015,114.7937,6.05331,0.093914,0.2711}, /*cmz*/
          {0.641345,5.1112,2.7604,-3.4394} /*cfz*/
     },
     {
          2458190.0,
          {0.2011,-0.00051,80.0109,4.17212,0.063045,0.3061}, /*cmx*/
          {4.16574,2.3558,0.0557,-0.1981}, /*cfx*/
          {-0.0523,3e-05,130.6542,6.35317,0.105133,0.3629}, /*cmy*/
          {2.335554,0.6197,4.6789,-3.2866}, /*cfy*/
          {-0.2252,0.00109,112.7868,5.86745,0.090073,0.2671}, /*cmz*/
          {0.671964,5.1362,2.7873,-3.3584} /*cfz*/
     },
     {
          2458231.0,
          {0.201,-0.00025,83.5397,4.32501,0.065115,0.3166}, /*cmx*/
          {4.169185,2.3623,0.0618,-0.2196}, /*cfx*/
          {-0.0554,0.00119,130.8108,6.35472,0.10533,0.3382}, /*cmy*/
          {2.379759,0.6689,4.7251,-3.2082}, /*cfy*/
          {-0.2027,0.00026,109.72,5.63232,0.085565,0.2718}, /*cmz*/
          {0.715422,5.1782,2.8362,-3.4031} /*cfz*/
     },
     {
          2458272.0,
          {0.2047,-0.00051,86.9127,4.43037,0.066125,0.321}, /*cmx*/
          {4.185891,2.3755,0.0747,-0.2067}, /*cfx*/
          {-0.015,-4e-05,130.9728,6.37232,0.105922,0.3102}, /*cmy*/
          {2.434087,0.727,4.779,-3.2858}, /*cfy*/
          {-0.2111,0.00065,106.6911,5.42108,0.081593,0.2842}, /*cmz*/
          {0.770726,5.2357,2.9053,-3.3514} /*cfz*/
     },
     {
          2458313.0,
          {0.1976,-0.0005,88.9969,4.45794,0.065918,0.3183}, /*cmx*/
          {4.220309,2.4015,0.1,-0.2036}, /*cfx*/
          {-0.0237,0.00114,131.0289,6.42067,0.107336,0.2933}, /*cmy*/
          {2.494209,0.7896,4.8342,-3.1787}, /*cfy*/
          {-0.2121,0.00021,104.7384,5.30624,0.079547,0.305}, /*cmz*/
          {0.832635,5.3034,2.9866,-3.3637} /*cfz*/
     },
     {
          2458354.0,
          {0.1888,-0.00051,89.1079,4.39618,0.06444,0.3139}, /*cmx*/
          {4.26929,2.4393,0.1385,-0.2029}, /*cfx*/
          {0.0222,-0.00035,131.056,6.4933,0.109254,0.262}, /*cmy*/
          {2.553424,0.8483,4.8847,-3.2683}, /*cfy*/
          {-0.2355,0.00041,104.7346,5.32792,0.079925,0.339}, /*cmz*/
          {0.891771,5.3673,3.0602,-3.3464} /*cfz*/
     },
     {
          2458395.0,
          {0.1862,-0.00075,87.243,4.27147,0.062427,0.308}, /*cmx*/
          {4.325201,2.4879,0.1931,-0.1753}, /*cfx*/
          {0.006,0.00095,130.9995,6.58282,0.111466,0.2512}, /*cmy*/
          {2.603189,0.8956,4.9224,-3.1406}, /*cfy*/
          {-0.2582,0.00053,106.5881,5.46486,0.082239,0.3695}, /*cmz*/
          {0.939957,5.4143,3.1079,-3.3406} /*cfz*/
     },
     {
          2458436.0,
          {0.173,-0.00023,84.5487,4.15261,0.060924,0.3113}, /*cmx*/
          {4.376264,2.541,0.258,-0.2103}, /*cfx*/
          {0.0318,-0.00038,130.9584,6.64836,0.112893,0.2386}, /*cmy*/
          {2.638956,0.9281,4.9484,-3.267}, /*cfy*/
          {-0.2621,0.00043,109.1257,5.61975,0.084542,0.3898}, /*cmz*/
          {0.973712,5.4392,3.1257,-3.3676} /*cfz*/
     },
     {
          2458477.0,
          {0.1873,-0.00064,82.848,4.11565,0.061014,0.3249}, /*cmx*/
          {4.411006,2.587,0.3172,-0.1672}, /*cfx*/
          {0.0082,0.00087,130.8971,6.67794,0.113397,0.2448}, /*cmy*/
          {2.663615,0.952,4.968,-3.1518}, /*cfy*/
          {-0.2639,0.00095,110.6348,5.68007,0.085066,0.3878}, /*cmz*/
          {0.997545,5.4517,3.1307,-3.3413} /*cfz*/
     },
     {
          2458518.0,
          {0.1836,-2e-05,83.349,4.18658,0.062592,0.3429}, /*cmx*/
          {4.426806,2.6157,0.3536,-0.2111}, /*cfx*/
          {0.0391,-0.00026,130.9835,6.67426,0.113034,0.2229}, /*cmy*/
          {2.68751,0.9766,4.9911,-3.2443}, /*cfy*/
          {-0.2337,0.00045,110.1337,5.59809,0.083167,0.3755}, /*cmz*/
          {1.021103,5.4666,3.1419,-3.3748} /*cfz*/
     },
     {
          2458559.0,
          {0.2075,-0.00082,85.9569,4.32486,0.064828,0.357}, /*cmx*/
          {4.432226,2.63,0.3715,-0.1599}, /*cfx*/
          {0.0348,0.00072,131.1314,6.6664,0.112541,0.2072}, /*cmy*/
          {2.71831,1.0091,5.0214,-3.1262}, /*cfy*/
          {-0.2289,0.00119,107.7155,5.39476,0.079409,0.3551}, /*cmz*/
          {1.053318,5.4947,3.1737,-3.3186} /*cfz*/
     },
     {
          2458600.0,
          {0.1937,-2e-05,89.6099,4.47496,0.0668,0.369}, /*cmx*/
          {4.441547,2.642,0.3839,-0.2258}, /*cfx*/
          {0.0637,-5e-05,131.3762,6.66358,0.112106,0.1716}, /*cmy*/
          {2.760541,1.0518,5.0617,-3.2018}, /*cfy*/
          {-0.1921,0.00021,104.1453,5.13832,0.075005,0.3454}, /*cmz*/
          {1.099157,5.5422,3.2319,-3.3813} /*cfz*/
     },
     {
          2458641.0,
          {0.2133,-0.00102,93.0736,4.58008,0.06789,0.3771}, /*cmx*/
          {4.463481,2.6612,0.404,-0.1605}, /*cfx*/
          {0.0717,0.00051,131.5735,6.6827,0.112158,0.1508}, /*cmy*/
          {2.812654,1.1034,5.1082,-3.09}, /*cfy*/
          {-0.2036,0.00106,100.5713,4.9011,0.071265,0.3447}, /*cmz*/
          {1.156757,5.6079,3.3167,-3.3039} /*cfz*/
     },
     {
          2458682.0,
          {0.1885,-9e-05,95.213,4.61619,0.067939,0.3761}, /*cmx*/
          {4.501679,2.6926,0.4349,-0.2138}, /*cfx*/
          {0.0971,0.00015,131.7884,6.72623,0.112801,0.1126}, /*cmy*/
          {2.871856,1.1599,5.1583,-3.0724}, /*cfy*/
          {-0.184,-1e-05,98.1321,4.76362,0.069561,0.3547}, /*cmz*/
          {1.220375,5.6855,3.4158,-3.3574} /*cfz*/
     },
     {
          2458723.0,
          {0.2003,-0.00112,95.4196,4.56784,0.066953,0.3667}, /*cmx*/
          {4.551719,2.7342,0.4782,-0.1413}, /*cfx*/
          {0.1162,0.00011,131.9429,6.80299,0.114227,0.0898}, /*cmy*/
          {2.930807,1.2143,5.2042,-2.9749}, /*cfy*/
          {-0.2161,0.00096,97.8045,4.76508,0.070323,0.3733}, /*cmz*/
          {1.279452,5.7578,3.5049,-3.2821} /*cfz*/
     },
     {
          2458764.0,
          {0.1693,-0.0001,93.6681,4.46478,0.065523,0.3563}, /*cmx*/
          {4.606768,2.7844,0.5328,-0.212}, /*cfx*/
          {0.1237,0.00012,132.0941,6.89542,0.116072,0.0665}, /*cmy*/
          {2.982301,1.2598,5.2413,-2.7984}, /*cfy*/
          {-0.2098,-6e-05,99.5556,4.89162,0.072816,0.3999}, /*cmz*/
          {1.326287,5.8083,3.558,-3.3568} /*cfz*/
     },
     {
          2458805.0,
          {0.1817,-0.00094,91.0885,4.35832,0.064545,0.356}, /*cmx*/
          {4.654914,2.8375,0.5971,-0.148}, /*cfx*/
          {0.1403,-0.00033,132.177,6.9739,0.117506,0.0547}, /*cmy*/
          {3.019703,1.2915,5.266,-2.8335}, /*cfy*/
          {-0.2437,0.00111,102.1693,5.03617,0.074982,0.4231}, /*cmz*/
          {1.357497,5.8313,3.5745,-3.3003} /*cfz*/
     },
     {
          2458846.0,
          {0.1664,-0.0001,89.4171,4.32912,0.065048,0.3626}, /*cmx*/
          {4.688594,2.8854,0.6556,-0.1951}, /*cfx*/
          {0.1269,0.00033,132.2479,7.00706,0.117912,0.0535}, /*cmy*/
          {3.045784,1.3145,5.2851,-2.5031}, /*cfy*/
          {-0.2204,0.00025,103.6942,5.09588,0.075399,0.4247}, /*cmz*/
          {1.380473,5.8416,3.5747,-3.3548} /*cfz*/
     },
     {
          2458887.0,
          {0.1855,-0.00078,89.9625,4.39222,0.066752,0.3757}, /*cmx*/
          {4.705424,2.9172,0.6959,-0.1482}, /*cfx*/
          {0.145,-0.00047,132.3473,7.00283,0.117348,0.0382}, /*cmy*/
          {3.068663,1.3362,5.3055,-2.7434}, /*cfy*/
          {-0.2206,0.00117,103.0793,5.00862,0.073431,0.406}, /*cmz*/
          {1.404374,5.8554,3.5842,-3.3022} /*cfz*/
     },
     {
          2458928.0,
          {0.1767,-0.00019,92.5501,4.52414,0.069016,0.3879}, /*cmx*/
          {4.715675,2.9373,0.7191,-0.1925}, /*cfx*/
          {0.1289,0.00047,132.5118,6.98199,0.116388,0.0445}, /*cmy*/
          {3.097756,1.3648,5.3333,-2.0604}, /*cfy*/
          {-0.1796,0.00037,100.3089,4.80604,0.069935,0.3792}, /*cmz*/
          {1.439494,5.8873,3.6186,-3.3507} /*cfz*/
     },
     {
          2458969.0,
          {0.1889,-0.00077,96.1754,4.66138,0.070904,0.4}, /*cmx*/
          {4.730065,2.955,0.7392,-0.1615}, /*cfx*/
          {0.1684,-0.00069,132.7446,6.96257,0.115283,0.0225}, /*cmy*/
          {3.136619,1.4018,5.3692,-1.0772}, /*cfy*/
          {-0.1701,0.00091,96.2944,4.54451,0.06593,0.3564}, /*cmz*/
          {1.488704,5.9416,3.686,-3.3064} /*cfz*/
     },
     {
          2459010.0,
          {0.1805,-0.0005,99.5313,4.76868,0.07223,0.4041}, /*cmx*/
          {4.757832,2.9817,0.7657,-0.1766}, /*cfx*/
          {0.1577,0.00064,132.9675,6.9552,0.11445,0.0648}, /*cmy*/
          {3.185831,1.4478,5.4131,-0.9239}, /*cfy*/
          {-0.1468,0.00047,92.1899,4.31481,0.063091,0.3388}, /*cmz*/
          {1.551237,6.0199,3.7838,-3.3215} /*cfz*/
     },
     {
          2459051.0,
          {0.1784,-0.00067,101.6639,4.80803,0.072542,0.4016}, /*cmx*/
          {4.799375,3.0184,0.8025,-0.1612}, /*cfx*/
          {0.1995,-0.00066,133.2263,6.97144,0.114089,0.0775}, /*cmy*/
          {3.242077,1.4989,5.4612,-0.3566}, /*cfy*/
          {-0.1432,0.00056,89.3514,4.18322,0.062323,0.3326}, /*cmz*/
          {1.618162,6.1101,3.8961,-3.298} /*cfz*/
     },
     {
          2459092.0,
          {0.1678,-0.00062,101.9079,4.7812,0.072157,0.3921}, /*cmx*/
          {4.85184,3.065,0.8483,-0.1613}, /*cfx*/
          {0.1885,0.00055,133.4836,7.02469,0.114691,0.113}, /*cmy*/
          {3.300309,1.5506,5.5077,-0.5664}, /*cfy*/
          {-0.1436,0.00043,88.7118,4.19868,0.064118,0.3407}, /*cmz*/
          {1.67919,6.1935,3.9925,-3.2969} /*cfz*/
     },
     {
          2459133.0,
          {0.1529,-0.00042,100.3303,4.7001,0.071285,0.3789}, /*cmx*/
          {4.906575,3.117,0.9025,-0.1672}, /*cfx*/
          {0.2358,-0.00096,133.8131,7.10611,0.115932,0.1376}, /*cmy*/
          {3.352077,1.5942,5.5452,-0.2851}, /*cfy*/
          {-0.1517,0.0003,90.3696,4.32597,0.06709,0.3609}, /*cmz*/
          {1.724285,6.2472,4.0473,-3.3033} /*cfz*/
     },
     {
          2459174.0,
          {0.1524,-0.00078,97.8981,4.62552,0.071097,0.3693}, /*cmx*/
          {4.954515,3.1716,0.9614,-0.1417}, /*cfx*/
          {0.2194,0.00026,134.0307,7.1826,0.117177,0.1611}, /*cmy*/
          {3.391032,1.6262,5.5713,-0.445}, /*cfy*/
          {-0.1695,0.0007,92.9933,4.4729,0.069445,0.3802}, /*cmz*/
          {1.753283,6.2686,4.0595,-3.288} /*cfz*/
     },
     {
          2459215.0,
          {0.139,-0.0002,96.358,4.60964,0.071982,0.3695}, /*cmx*/
          {4.987683,3.2191,1.015,-0.1769}, /*cfx*/
          {0.2385,-0.00087,134.1933,7.21573,0.117462,0.1648}, /*cmy*/
          {3.417547,1.6483,5.5905,-0.2874}, /*cfy*/
          {-0.1613,0.0003,94.6124,4.52401,0.069479,0.3842}, /*cmz*/
          {1.773949,6.2732,4.0543,-3.3256} /*cfz*/
     }

};

static unsigned idn_list[] = {2,18,35,54,74};
static double freq_list[] = {2.493,1.5162,0.7217,0.4667,4.488};
static double delt_list[] = {258.0,242.0,223.0,206.0,41.0};

BDL_Dataset uranus_1020 = {
     5, /*nsat*/
     2455197.5, /*djj*/
     idn_list,
     freq_list,
     delt_list,
     moonrecords
};
