%{!?python_sitearch: %define python_sitearch %(%{__python} -c "from distutils.sysconfig import get_python_lib; print get_python_lib(1)")}

Name: picviz
Version: 0.2.3
Release: 1%{?dist}
Summary: Parallel coordinates plotter

License: GPLv3+
Group: Applications/Engineering
URL: http://www.wallinfire.net/picviz
Source0: http://www.wallinfire.net/picviz/attachment/wiki/ReleasesDownload/%{name}-%{version}.tar.gz
Source1: %{name}.desktop
Patch0: picviz-0.2.3-pkgconfig-path.patch
BuildRoot: %{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)

BuildRequires: cmake
BuildRequires: bison
BuildRequires: flex
BuildRequires: python-devel
BuildRequires: pkgconfig
Requires(post): /sbin/ldconfig
Requires(postun): /sbin/ldconfig

%package devel
Summary: Picviz development files
Group: Development/Libraries
Requires: %{name} = %{version}-%{release}
Requires: pkgconfig

%package gui
Summary: Graphical frontend for picviz
Group: Applications/Engineering
BuildRequires: desktop-file-utils
Requires: %{name} = %{version}-%{release}
Requires: PyQt4

%package plugin-plplot
Summary: Plplot plugin for picviz
Group: Applications/Engineering
BuildRequires: plplot-devel
BuildRequires: libtool-ltdl-devel
Requires: %{name} = %{version}-%{release}
Requires: plplot-libs

%description
Picviz is a parallel coordinates plotter which enables easy scripting
from various input (tcpdump, syslog, iptables logs, apache logs,
etc..) to visualize your data and discover interesting results
quickly.

Its primary goal is to graph data in order to be able to quickly
analyze problems and find correlations among variables. With security
analysis in mind, the program has been designed to be very flexible,
able to graph millions of events.

The language is designed to be close to the graphviz graph description
language.

%description devel
Header files for libpicviz.

%description gui
Graphical frontend for picviz.

%description plugin-plplot
Plugin for generating output using the plplot library.

%prep
%setup -q
%patch0 -p1 -b .pkgconfig-path

%build
mkdir -p build
pushd build
%cmake -DCMAKE_SKIP_RPATH:BOOL=ON ..
make %{?_smp_mflags}
popd

pushd src/libpicviz/bindings/python
python ./setup.py build
popd

pushd src/frontend
python ./setup.py build
popd

%install
rm -rf %{buildroot}
make install DESTDIR=%{buildroot}

pushd src/libpicviz/bindings/python
python ./setup.py install --root=%{buildroot} --install-lib=%{python_sitearch}
popd
chmod 755 %{buildroot}/%{python_sitearch}/picviz.so

pushd src/frontend
python ./setup.py install --root=%{buildroot} --install-lib=%{python_sitearch}
popd

install -d -m 755 %{buildroot}/%{_datadir}/%{name}
install -p -m 755 tools/* %{buildroot}/%{_datadir}/%{name}

desktop-file-install --vendor="fedora" --dir=%{buildroot}/%{_datadir}/applications %{SOURCE1}

%clean
rm -rf %{buildroot}

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%files
%defattr(-,root,root,-)
%doc COPYING README doc/*
%dir %{_datadir}/%{name}
%{_datadir}/%{name}/*
%{_libdir}/*.so.*
%dir %{_libdir}/%{name}
%{_libdir}/%{name}/*.so
%exclude %{_libdir}/%{name}/libpicvizoutplplot.so
%{python_sitearch}/picviz.so
%{python_sitearch}/Picviz*.egg-info
%{_bindir}/pcv

%files devel
%defattr(-,root,root,-)
%{_libdir}/libpicviz.so
%{_libdir}/pkgconfig/picviz.pc
%{_includedir}/*

%files gui
%defattr(-,root,root,-)
%dir %{python_sitearch}/PicvizGui
%{python_sitearch}/PicvizGui/*
%{python_sitearch}/picviz_gui*.egg-info
%{_bindir}/picviz-gui
%{_datadir}/applications/fedora-%{name}.desktop

%files plugin-plplot
%defattr(-,root,root,-)
%{_libdir}/%{name}/libpicvizoutplplot.so

%changelog
* Thu Aug  7 2008 Tomas Heinrich <theinric@redhat.com> 0.2.3-1
- Initial build

