<?php
/**
 * ImageGenerator to create the prettythumb view (rounded, shadowed thumbnails).
 *
 * @author Michael J. Rubinsky <mrubinsk@horde.org>
 * @package Ansel
 */
class Ansel_ImageGenerator_RoundedThumb extends Ansel_ImageGenerator
{
    public $need = array('RoundCorners', 'DropShadow');

    public function __construct($params)
    {
        parent::__construct($params);
        $this->title = _("Rounded Corners");
    }

    /**
     *
     * @return Horde_Image
     */
    protected function _create()
    {
        $this->_image->resize(min($GLOBALS['conf']['thumbnail']['width'], $this->_dimensions['width']),
                              min($GLOBALS['conf']['thumbnail']['height'], $this->_dimensions['height']),
                              true);

        /* Don't bother with these effects for a stack image
         * (which will have a negative gallery_id). */
        if ($this->_image->gallery > 0) {
            if (is_null($this->_style)) {
                $gal = $GLOBALS['injector']->getInstance('Ansel_Storage')->getGallery($this->_image->gallery);
                $styleDef = $gal->getStyle();
            } else {
                $styleDef = $this->_style;
            }

            try {
                /* Apply the effects - continue on error, but be sure to log */
                $this->_image->addEffect('RoundCorners', array('border' => 2,
                                                               'bordercolor' => '#333'));

                $this->_image->addEffect('DropShadow', array('background' => $styleDef->background,
                                                             'padding' => 5,
                                                             'distance' => 5,
                                                             'fade' => 3));
                if ($GLOBALS['conf']['thumbnail']['unsharp'] && Ansel::isAvailable('Unsharpmask')) {
                    $this->_image->addEffect('Unsharpmask',
                                             array('radius' => $GLOBALS['conf']['thumbnail']['radius'],
                                                   'threshold' => $GLOBALS['conf']['thumbnail']['threshold'],
                                                   'amount' => $GLOBALS['conf']['thumbnail']['amount']));
                }

                $this->_image->applyEffects();
            } catch (Horde_Image_Exception $e) {
                throw new Ansel_Exception($e);
            }

            return $this->_image->getHordeImage();
        }
    }

}
