// Minimal symmetric quadrature rules for a triangle from https://doi.org/10.1016/j.camwa.2015.03.017
// This file was generated by lib/petsc/bin/maint/petscdt_create_quadrature_headers.py
#ifndef PETSCDTTRIQUADRULES_H
#define PETSCDTTRIQUADRULES_H

#include <petscsys.h>

static const PetscReal PetscDTWVTriQuad_1_weights[] = {PetscRealConstant(2.00000000000000000000000000000000000e+00)};

static const PetscReal PetscDTWVTriQuad_1_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01)};

static const PetscReal PetscDTWVTriQuad_2_weights[] = {PetscRealConstant(6.66666666666666666666666666666666635e-01)};

static const PetscReal PetscDTWVTriQuad_2_orbits[] = {PetscRealConstant(1.66666666666666666666666666666666659e-01), PetscRealConstant(6.66666666666666666666666666666666635e-01)};

static const PetscReal PetscDTWVTriQuad_4_weights[] = {PetscRealConstant(4.46763179356022931390014016866245598e-01), PetscRealConstant(2.19903487310643735276652649800421061e-01)};

static const PetscReal PetscDTWVTriQuad_4_orbits[] = {PetscRealConstant(4.45948490915964886318329253883051984e-01), PetscRealConstant(1.08103018168070227363341492233896033e-01), PetscRealConstant(9.15762135097707434595714634022014804e-02), PetscRealConstant(8.16847572980458513080857073195597039e-01)};

static const PetscReal PetscDTWVTriQuad_5_weights[] = {PetscRealConstant(4.50000000000000000000000000000000010e-01), PetscRealConstant(2.51878361089654305191367891000362687e-01), PetscRealConstant(2.64788305577012361475298775666303977e-01)};

static const PetscReal PetscDTWVTriQuad_5_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(1.01286507323456338800987361915123836e-01), PetscRealConstant(7.97426985353087322398025276169752328e-01), PetscRealConstant(4.70142064105115089770441209513447613e-01), PetscRealConstant(5.97158717897698204591175809731048219e-02)};

static const PetscReal PetscDTWVTriQuad_6_weights[] = {PetscRealConstant(1.01689812740413633841873618213737963e-01), PetscRealConstant(2.33572551452758732050579222771158894e-01), PetscRealConstant(1.65702151236747150387106912840884901e-01)};

static const PetscReal PetscDTWVTriQuad_6_orbits[] = {PetscRealConstant(6.30890144915022283403316028708191300e-02), PetscRealConstant(8.73821971016995543319336794258361644e-01), PetscRealConstant(2.49286745170910421291638553107019076e-01),
                                                      PetscRealConstant(5.01426509658179157416722893785961848e-01), PetscRealConstant(5.31450498448169473532496716313981651e-02), PetscRealConstant(6.36502499121398647230142594412049640e-01),
                                                      PetscRealConstant(3.10352451033784405416607733956552146e-01)};

static const PetscReal PetscDTWVTriQuad_7_weights[] = {PetscRealConstant(3.30901002215842620719558969458348911e-02), PetscRealConstant(2.55888342460311145565802470369292636e-01), PetscRealConstant(1.54173292371972135669643041667482776e-01), PetscRealConstant(1.11757465806399561679632628842028190e-01)};

static const PetscReal PetscDTWVTriQuad_7_orbits[] = {PetscRealConstant(3.37306485545878487149717263008162317e-02), PetscRealConstant(9.32538702890824302570056547398367537e-01), PetscRealConstant(2.41577382595403558950186769837781999e-01),
                                                      PetscRealConstant(5.16845234809192882099626460324436002e-01), PetscRealConstant(4.74309692504718234209580735949185780e-01), PetscRealConstant(5.13806149905635315808385281016284391e-02),
                                                      PetscRealConstant(4.70366446525952333414099753568849895e-02), PetscRealConstant(7.54280040550053177356239324628119970e-01), PetscRealConstant(1.98683314797351589302350700014995040e-01)};

static const PetscReal PetscDTWVTriQuad_8_weights[] = {PetscRealConstant(2.88631215355574336502182220978129237e-01), PetscRealConstant(1.90183268534569249587792208777168633e-01), PetscRealConstant(2.06434741069436500563583100584258068e-01), PetscRealConstant(6.49169952463961606218518566835611904e-02), PetscRealConstant(5.44606283488699885296893801478178481e-02)};

static const PetscReal PetscDTWVTriQuad_8_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(4.59292588292723156028815514494169350e-01), PetscRealConstant(8.14148234145536879423689710116613481e-02),
                                                      PetscRealConstant(1.70569307751760206622293501491464506e-01), PetscRealConstant(6.58861384496479586755412997017070988e-01), PetscRealConstant(5.05472283170309754584235505965989197e-02),
                                                      PetscRealConstant(8.98905543365938049083152898806802161e-01), PetscRealConstant(8.39477740995760533721383453929445768e-03), PetscRealConstant(7.28492392955404281241000379176061966e-01),
                                                      PetscRealConstant(2.63112829634638113421785786284643576e-01)};

static const PetscReal PetscDTWVTriQuad_9_weights[] = {PetscRealConstant(1.94271592565597667638483965014577269e-01), PetscRealConstant(1.55655082009548558633478712598807923e-01), PetscRealConstant(1.59295477854420506065783548528090548e-01),
                                                       PetscRealConstant(6.26694004542781410737096625744186273e-02), PetscRealConstant(5.11553513173960625233575971179996460e-02), PetscRealConstant(8.65670787545787545787545787545787526e-02)};

static const PetscReal PetscDTWVTriQuad_9_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(4.37089591492936637269930364435354971e-01), PetscRealConstant(1.25820817014126725460139271129290058e-01),
                                                      PetscRealConstant(1.88203535619032730240961280467335542e-01), PetscRealConstant(6.23592928761934539518077439065328819e-01), PetscRealConstant(4.89682519198737627783706924836192818e-01),
                                                      PetscRealConstant(2.06349616025247444325861503276144129e-02), PetscRealConstant(4.47295133944527098651065899662763588e-02), PetscRealConstant(9.10540973211094580269786820067447282e-01),
                                                      PetscRealConstant(3.68384120547362836348175987833851049e-02), PetscRealConstant(7.41198598784498020690079873523423793e-01), PetscRealConstant(2.21962989160765695675102527693191078e-01)};

static const PetscReal PetscDTWVTriQuad_10_weights[] = {PetscRealConstant(1.63486658292571932856237369968355216e-01), PetscRealConstant(2.67059376262991325511459567981373070e-02), PetscRealConstant(9.19159272094894560275758192650956353e-02),
                                                        PetscRealConstant(1.27809812792848090865797467525306648e-01), PetscRealConstant(6.83692963259188572573831680826845816e-02), PetscRealConstant(5.05955154145767687780855813656664345e-02)};

static const PetscReal PetscDTWVTriQuad_10_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(3.20553732169435129309845893364897379e-02), PetscRealConstant(9.35889253566112974138030821327020524e-01),
                                                       PetscRealConstant(1.42161101056564385092162103190958311e-01), PetscRealConstant(7.15677797886871229815675793618083377e-01), PetscRealConstant(3.21812995288835421225097560986048687e-01),
                                                       PetscRealConstant(5.30054118927344028277095673945694069e-01), PetscRealConstant(1.48132885783820550497806765068257172e-01), PetscRealConstant(2.96198894887297676338362694260427776e-02),
                                                       PetscRealConstant(6.01233328683459245454742893458687815e-01), PetscRealConstant(3.69146781827810986911420837115269408e-01), PetscRealConstant(2.83676653399384392504357555781301898e-02),
                                                       PetscRealConstant(8.07930600922879065079949902881744115e-01), PetscRealConstant(1.63701733737182495669614341540125695e-01)};

static const PetscReal PetscDTWVTriQuad_11_weights[] = {PetscRealConstant(1.71522359464448434276398250730654000e-01), PetscRealConstant(2.08637410257893917460569841973246348e-02), PetscRealConstant(1.41031368223433156684147718345856748e-01),
                                                        PetscRealConstant(7.72615184740386449532676091788022999e-02), PetscRealConstant(3.32125461091707391527516785501121236e-02), PetscRealConstant(1.34632308158936602395674411246575569e-01),
                                                        PetscRealConstant(2.05805791459065549861612549679590599e-02), PetscRealConstant(8.06649532810011051684898358175962588e-02)};

static const PetscReal PetscDTWVTriQuad_11_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(2.84854176143719094798163668050904875e-02), PetscRealConstant(9.43029164771256181040367266389819025e-01),
                                                       PetscRealConstant(2.10219956703178257008062268345792615e-01), PetscRealConstant(5.79560086593643485983875463308414771e-01), PetscRealConstant(1.02635482712246430449115069884944155e-01),
                                                       PetscRealConstant(7.94729034575507139101769860230111690e-01), PetscRealConstant(4.95891900965890913064940119003615983e-01), PetscRealConstant(8.21619806821817387011976199276803416e-03),
                                                       PetscRealConstant(4.38465926764352191023335862842519482e-01), PetscRealConstant(1.23068146471295617953328274314961084e-01), PetscRealConstant(1.49324788652082386195725787877173544e-01),
                                                       PetscRealConstant(8.43349783661853162198991436398824917e-01), PetscRealConstant(7.32542768606445160528277572400153925e-03), PetscRealConstant(4.60105001654299558899597762948672729e-02),
                                                       PetscRealConstant(6.64408374196864197403547676332515738e-01), PetscRealConstant(2.89581125637705846706492547372616941e-01)};

static const PetscReal PetscDTWVTriQuad_12_weights[] = {PetscRealConstant(4.85336761629040663014359451512161690e-02), PetscRealConstant(5.69721041377550899993889478150308904e-02), PetscRealConstant(1.25082426391805520938647562891039680e-01),
                                                        PetscRealConstant(1.58632850199472769186295758117194679e-02), PetscRealConstant(9.98366698561218842381034441219885979e-02), PetscRealConstant(4.35671700772151158652628726785836459e-02),
                                                        PetscRealConstant(8.64547273188284210982665418337184629e-02), PetscRealConstant(3.01673551530228771717011809255338252e-02)};

static const PetscReal PetscDTWVTriQuad_12_orbits[] = {PetscRealConstant(4.88203750945541551778008123868814767e-01), PetscRealConstant(2.35924981089168964439837522623704665e-02), PetscRealConstant(1.09257827659354290583747312004308723e-01),
                                                       PetscRealConstant(7.81484344681291418832505375991382554e-01), PetscRealConstant(2.71462507014926084877995948022545085e-01), PetscRealConstant(4.57074985970147830244008103954909829e-01),
                                                       PetscRealConstant(2.46463634363355947667311972143345750e-02), PetscRealConstant(9.50707273127328810466537605571330850e-01), PetscRealConstant(4.40111648658593111013453703072908191e-01),
                                                       PetscRealConstant(1.19776702682813777973092593854183617e-01), PetscRealConstant(2.91655679738340960533913811933940653e-01), PetscRealConstant(6.85310163906391899984444686137130236e-01),
                                                       PetscRealConstant(2.30341563552671394816415019289291111e-02), PetscRealConstant(1.16296019677926586630748134149701116e-01), PetscRealConstant(6.28249751683556066837896138367229162e-01),
                                                       PetscRealConstant(2.55454228638517346531355727483069674e-01), PetscRealConstant(8.51337792510240041618003610432058384e-01), PetscRealConstant(1.27279717233589368787841874747382335e-01),
                                                       PetscRealConstant(2.13824902561705895941545148205592332e-02)};

static const PetscReal PetscDTWVTriQuad_13_weights[] = {PetscRealConstant(1.35920073173663288563548849361769759e-01), PetscRealConstant(4.79888038577894615474215989019193070e-02), PetscRealConstant(1.16556970238399962809534167026679618e-01),
                                                        PetscRealConstant(1.11203935060906657414514932020922939e-01), PetscRealConstant(1.21046742070783436835856000645816491e-02), PetscRealConstant(4.83580796231876382748914911461215177e-02),
                                                        PetscRealConstant(2.99308022103313345264917142658068753e-02), PetscRealConstant(6.92825522816967409319736570218364453e-02), PetscRealConstant(1.91813620070865254451901803322217833e-02)};

static const PetscReal PetscDTWVTriQuad_13_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(4.89076946452539349900689719090204415e-01), PetscRealConstant(2.18461070949213001986205618195912174e-02),
                                                       PetscRealConstant(2.21372286291832900654812554705079070e-01), PetscRealConstant(5.57255427416334198690374890589841859e-01), PetscRealConstant(4.26941414259800406020812535031374202e-01),
                                                       PetscRealConstant(1.46117171480399187958374929937251597e-01), PetscRealConstant(2.15096811088431838692913135340520647e-02), PetscRealConstant(9.56980637782313632261417372931895871e-01),
                                                       PetscRealConstant(8.78954830321973245930935025003331239e-02), PetscRealConstant(7.48507115899952195173018595788709684e-01), PetscRealConstant(1.63597401067850480233887901710957217e-01),
                                                       PetscRealConstant(1.10922042803463395412869545221674506e-01), PetscRealConstant(8.64707770295442775302545950895693184e-01), PetscRealConstant(2.43701869010938292845845038826323092e-02),
                                                       PetscRealConstant(3.08441760892117774658471852541245331e-01), PetscRealConstant(6.23545995553675570815854353186236564e-01), PetscRealConstant(6.80122435542066545256737942725181053e-02),
                                                       PetscRealConstant(5.12638910238236855932940334112910008e-03), PetscRealConstant(7.22357793124187965260620132304784030e-01), PetscRealConstant(2.72515817773429666180050464354086870e-01)};

static const PetscReal PetscDTWVTriQuad_14_weights[] = {PetscRealConstant(8.43251774739860350764608746483722643e-02), PetscRealConstant(6.55767070882507012826219574772506885e-02), PetscRealConstant(2.88673993395533352034198429613066343e-02),
                                                        PetscRealConstant(4.37671627388577812816898919266519414e-02), PetscRealConstant(1.03548209014583172629569820332792803e-01), PetscRealConstant(9.84680720480016336365204701808430982e-03),
                                                        PetscRealConstant(2.88726162270676809921773839980316070e-02), PetscRealConstant(4.93315064251273479257504903672724557e-02), PetscRealConstant(7.71430215741213664569780556208217199e-02),
                                                        PetscRealConstant(1.00204576770013435397201861649782335e-02)};

static const PetscReal PetscDTWVTriQuad_14_orbits[] = {PetscRealConstant(1.77205532412543436956610690465059082e-01), PetscRealConstant(6.45588935174913126086778619069881836e-01), PetscRealConstant(4.17644719340453922509440822185643448e-01),
                                                       PetscRealConstant(1.64710561319092154981118355628713104e-01), PetscRealConstant(6.17998830908726012674788284369357911e-02), PetscRealConstant(8.76400233818254797465042343126128418e-01),
                                                       PetscRealConstant(4.88963910362178638677376020452390243e-01), PetscRealConstant(2.20721792756427226452479590952195143e-02), PetscRealConstant(2.73477528308838659754944283262698573e-01),
                                                       PetscRealConstant(4.53044943382322680490111433474602902e-01), PetscRealConstant(1.93909612487010481782500950545294776e-02), PetscRealConstant(9.61218077502597903643499809890941045e-01),
                                                       PetscRealConstant(2.98372882136257752970831518059612720e-01), PetscRealConstant(6.86980167808087837358627154020313045e-01), PetscRealConstant(1.46469500556544096705413279200742108e-02),
                                                       PetscRealConstant(5.71247574036479390356771242189146926e-02), PetscRealConstant(7.70608554774996482589033274167427932e-01), PetscRealConstant(1.72266687821355578375289601613657375e-01),
                                                       PetscRealConstant(3.36861459796345001744055197088925405e-01), PetscRealConstant(5.70222290846683173497696213362354291e-01), PetscRealConstant(9.29162493569718247582485895487203647e-02),
                                                       PetscRealConstant(1.26833093287202508724640109549267126e-03), PetscRealConstant(8.79757171370171129514571636974601817e-01), PetscRealConstant(1.18974497696956845398181961929905512e-01)};

static const PetscReal PetscDTWVTriQuad_15_weights[] = {PetscRealConstant(8.86707747643681507751986813140648104e-02), PetscRealConstant(8.54275631429211340827258387456683563e-02), PetscRealConstant(3.28894751252503275373600173770182572e-02),
                                                        PetscRealConstant(3.47922960015268291154531017685095066e-02), PetscRealConstant(9.35667234574192647125377895615484771e-02), PetscRealConstant(1.91476923649201724131385072531871167e-02),
                                                        PetscRealConstant(5.92154927581075113855260527672987860e-03), PetscRealConstant(3.12051456611519295035498316570008457e-02), PetscRealConstant(8.05970674403619923672866982171301535e-03),
                                                        PetscRealConstant(5.74411738504026804613312833433017136e-02), PetscRealConstant(2.33452423631516906791540110886731717e-02), PetscRealConstant(6.26309525699385688234858272123029802e-02)};

static const PetscReal PetscDTWVTriQuad_15_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(4.05362214133975477866756110719750872e-01), PetscRealConstant(1.89275571732049044266487778560498304e-01),
                                                       PetscRealConstant(7.01735528999860174843597521434285917e-02), PetscRealConstant(8.59652894200027965031280495713142817e-01), PetscRealConstant(4.74170681438019791978690695274105882e-01),
                                                       PetscRealConstant(5.16586371239604160426186094517881886e-02), PetscRealConstant(2.26378713420349598290725581084619288e-01), PetscRealConstant(5.47242573159300803418548837830761375e-01),
                                                       PetscRealConstant(4.94996956769126184237799647683910870e-01), PetscRealConstant(1.00060864617476315244007046321782609e-02), PetscRealConstant(1.58117262509886455589517337838675350e-02),
                                                       PetscRealConstant(9.68376547498022708882096532432264930e-01), PetscRealConstant(1.83761123856810919610443955813958966e-02), PetscRealConstant(6.66975644801868089946323539203712071e-01),
                                                       PetscRealConstant(3.14648242812450818092632065214892032e-01), PetscRealConstant(9.13923703730839503655181749098653308e-03), PetscRealConstant(9.19912157726236064902860595296792411e-01),
                                                       PetscRealConstant(7.09486052364555400605875872122211043e-02), PetscRealConstant(1.90535589476393933430690249685964151e-01), PetscRealConstant(7.15222356931450701883979368783730432e-01),
                                                       PetscRealConstant(9.42420535921553646853303815303054178e-02), PetscRealConstant(1.68068645222414355464777588583629471e-01), PetscRealConstant(8.13292641049419269912258313013357957e-01),
                                                       PetscRealConstant(1.86387137281663746229640984030125719e-02), PetscRealConstant(3.38950611475277189214593004670451961e-01), PetscRealConstant(5.65252664877114214451851934366756315e-01),
                                                       PetscRealConstant(9.57967236476085963335550609627917242e-02)};

static const PetscReal PetscDTWVTriQuad_16_weights[] = {PetscRealConstant(9.05291321476375857986828047514979116e-02), PetscRealConstant(8.21858462873978990828598377438463442e-02), PetscRealConstant(8.14236666248507185047276046098922299e-02),
                                                        PetscRealConstant(2.95632693804488079603643752064387255e-02), PetscRealConstant(5.88368193979761957212227044455654107e-02), PetscRealConstant(8.83709262430113785076846357830921745e-03),
                                                        PetscRealConstant(5.19486665965543166406045836940668802e-02), PetscRealConstant(3.78765449288313979390924276134188201e-02), PetscRealConstant(3.30893342967009638479162789620443085e-03),
                                                        PetscRealConstant(3.00172035685716121651369645217149509e-02), PetscRealConstant(1.58951878667849976211991962181080945e-02), PetscRealConstant(6.39672201587401375696281232878662239e-02),
                                                        PetscRealConstant(1.07823742336976228067640750317117516e-02)};

static const PetscReal PetscDTWVTriQuad_16_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(2.45990070467141734471717779767080184e-01), PetscRealConstant(5.08019859065716531056564440465839632e-01),
                                                       PetscRealConstant(4.15584896885420513220980676184012749e-01), PetscRealConstant(1.68830206229158973558038647631974550e-01), PetscRealConstant(8.53555665867003217553248855213653109e-02),
                                                       PetscRealConstant(8.29288866826599356489350228957269378e-01), PetscRealConstant(1.61918644191271226876883267012342420e-01), PetscRealConstant(6.76162711617457546246233465975315112e-01),
                                                       PetscRealConstant(5.00000000000000000000000000000000000e-01), PetscRealConstant(0.00000000000000000000000000000000000e+00), PetscRealConstant(4.75280727545942104088257790534511968e-01),
                                                       PetscRealConstant(4.94385449081157918234844189309761125e-02), PetscRealConstant(5.47551749147031128917237113965837125e-02), PetscRealConstant(7.54170061444767807854989036629145266e-01),
                                                       PetscRealConstant(1.91074763640529079253287251974271022e-01), PetscRealConstant(2.32034277688137090374885412716003892e-02), PetscRealConstant(9.68244368030958679184597594208125965e-01),
                                                       PetscRealConstant(8.55220420022761177791386452027359798e-03), PetscRealConstant(1.89317782804059149817152705273881471e-02), PetscRealConstant(6.49303698245446408129626495781908015e-01),
                                                       PetscRealConstant(3.31764523474147676888658233690703838e-01), PetscRealConstant(1.90301297436974487909352121574817207e-02), PetscRealConstant(9.00273703270429626137006917193871841e-01),
                                                       PetscRealConstant(8.06961669858729250720578706486464385e-02), PetscRealConstant(1.02606190239398096301724851614571753e-01), PetscRealConstant(5.89148840564247918790286700628427787e-01),
                                                       PetscRealConstant(3.08244969196353984907988447757000412e-01), PetscRealConstant(5.93635001682226990748196761065799418e-03), PetscRealConstant(8.06621867499395642451430326307064620e-01),
                                                       PetscRealConstant(1.87441782483782087641087706082277338e-01)};

static const PetscReal PetscDTWVTriQuad_17_weights[] = {PetscRealConstant(5.46218530562042150475576951080594866e-02), PetscRealConstant(5.54777515527528430922498518465928957e-03), PetscRealConstant(5.00389019009947155941150603527654529e-02),
                                                        PetscRealConstant(5.26252611760359699120688303471593071e-02), PetscRealConstant(2.49180016046108841905000857308273671e-02), PetscRealConstant(7.54324743055905600328576119359104562e-02),
                                                        PetscRealConstant(1.59566004118591866485652442901310506e-02), PetscRealConstant(4.49755450933821328846443115603380063e-02), PetscRealConstant(2.07968799116790729272571307561765471e-02),
                                                        PetscRealConstant(4.11157966409090349920116591628438478e-02), PetscRealConstant(1.73844290020023831375478508809914723e-02), PetscRealConstant(9.16869680347173368589921474155920100e-03),
                                                        PetscRealConstant(5.23432518706739745142457876116025282e-02)};

static const PetscReal PetscDTWVTriQuad_17_orbits[] = {PetscRealConstant(4.17103444361599201605122916371999621e-01), PetscRealConstant(1.65793111276801596789754167256000757e-01), PetscRealConstant(1.47554916607539534031541793007952979e-02),
                                                       PetscRealConstant(9.70489016678492093193691641398409404e-01), PetscRealConstant(4.65597871618890301895891590846937728e-01), PetscRealConstant(6.88042567622193962082168183061245432e-02),
                                                       PetscRealConstant(1.80358116266370620185843072229380414e-01), PetscRealConstant(6.39283767467258759628313855541239075e-01), PetscRealConstant(6.66540634795969297567667483984988561e-02),
                                                       PetscRealConstant(8.66691873040806140486466503203002288e-01), PetscRealConstant(2.85706502436586628001837878744692008e-01), PetscRealConstant(4.28586995126826743996324242510615984e-01),
                                                       PetscRealConstant(1.60176423621192968424073121332647932e-02), PetscRealConstant(8.24790070165088024434290608180820176e-01), PetscRealConstant(1.59192287472792678723302079685915079e-01),
                                                       PetscRealConstant(3.06281591746186541535309493854873394e-01), PetscRealConstant(6.26369030386452262068722302797812352e-01), PetscRealConstant(6.73493778673611963959682033473143023e-02),
                                                       PetscRealConstant(1.32296727600868933070167133491055651e-02), PetscRealConstant(5.71294867944684051850649111695958611e-01), PetscRealConstant(4.15475459295229054842334174954935824e-01),
                                                       PetscRealConstant(7.80423405682824241713308705193131194e-02), PetscRealConstant(7.53235145936458118896427399114359904e-01), PetscRealConstant(1.68722513495259456932241730366326976e-01),
                                                       PetscRealConstant(1.31358708340026949666036394299696521e-02), PetscRealConstant(7.15072259110642461515924620376363037e-01), PetscRealConstant(2.71791870055354843517471740193667359e-01),
                                                       PetscRealConstant(1.15751759031806153480421184016144640e-02), PetscRealConstant(9.15919353297816958377432239139143335e-01), PetscRealConstant(7.25054707990024262745256424592422015e-02),
                                                       PetscRealConstant(1.57505477926869905027610915523700733e-01), PetscRealConstant(5.43275579596159774104648399690242292e-01), PetscRealConstant(2.99218942476970320867740684786056927e-01)};

static const PetscReal PetscDTWVTriQuad_18_weights[] = {PetscRealConstant(7.27114706028533323359884029761513151e-02), PetscRealConstant(6.66089400667802705708310205132498738e-02), PetscRealConstant(2.40932952679994202368535813068038700e-02),
                                                        PetscRealConstant(3.78983430135577320521847245035827587e-02), PetscRealConstant(7.29501788178872740682892959172946882e-02), PetscRealConstant(1.42586520394379413555283096109389911e-02),
                                                        PetscRealConstant(3.31183199040064983361161119792618211e-02), PetscRealConstant(2.75192324698844104758390464183697732e-02), PetscRealConstant(4.75638218003056599031833942231759522e-02),
                                                        PetscRealConstant(9.06106900451413079840910895912955790e-03), PetscRealConstant(1.36802202392143629804555160766495758e-02), PetscRealConstant(3.54949782040408102327899244616909652e-02),
                                                        PetscRealConstant(1.00213217491594434077412713938820535e-02), PetscRealConstant(2.44589625392217955843604819499574221e-03), PetscRealConstant(5.09643506236488789439127678605151494e-02)};

static const PetscReal PetscDTWVTriQuad_18_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(3.99955628067576231680366121769806395e-01), PetscRealConstant(2.00088743864847536639267756460387210e-01),
                                                       PetscRealConstant(4.87580301574869562313185532700103246e-01), PetscRealConstant(2.48393968502608753736289345997935552e-02), PetscRealConstant(4.61809506406449231368712937791837073e-01),
                                                       PetscRealConstant(7.63809871871015372625741244163258542e-02), PetscRealConstant(2.42264702514271962204939233297139467e-01), PetscRealConstant(5.15470594971456075590121533405721017e-01),
                                                       PetscRealConstant(3.88302560886855947102208202991309036e-02), PetscRealConstant(9.22339487822628810579558359401738193e-01), PetscRealConstant(9.19477421216431967358843945016815118e-02),
                                                       PetscRealConstant(8.16104515756713606528231210996636976e-01), PetscRealConstant(4.58049158598607811285920925059577317e-02), PetscRealConstant(7.70372376214675213229309957505842194e-01),
                                                       PetscRealConstant(1.83822707925464005642097949988200122e-01), PetscRealConstant(2.06349257433837933419345185175577418e-01), PetscRealConstant(6.70953985194234513161155697767001069e-01),
                                                       PetscRealConstant(1.22696757371927553419499117057421489e-01), PetscRealConstant(3.89761103347338253692169134281067626e-03), PetscRealConstant(6.00418954634256914765862968120400983e-01),
                                                       PetscRealConstant(3.95683434332269702697215340536788388e-01), PetscRealConstant(1.34620167414449892143601050962882285e-02), PetscRealConstant(8.78342189467521717755850351677828266e-01),
                                                       PetscRealConstant(1.08195793791033293029789543225883457e-01), PetscRealConstant(4.02602834699080631443836024025457617e-02), PetscRealConstant(6.39988092004714594911046293338189771e-01),
                                                       PetscRealConstant(3.19751624525377341944570104259264468e-01), PetscRealConstant(5.29833518660976530078710089623527944e-03), PetscRealConstant(7.58929479855198494045149453834361255e-01),
                                                       PetscRealConstant(2.35772184958191740654063445269403465e-01), PetscRealConstant(5.48360042042318992418009774686990385e-04), PetscRealConstant(9.72360728962795666781798630058172698e-01),
                                                       PetscRealConstant(2.70909109951620142257833601671402630e-02), PetscRealConstant(1.20587695163924643176785053210643772e-01), PetscRealConstant(5.45918775386194599808694021075927202e-01),
                                                       PetscRealConstant(3.33493529449880757014520925713429074e-01)};

static const PetscReal PetscDTWVTriQuad_19_weights[] = {PetscRealConstant(6.89387954080246698120264169137141490e-02), PetscRealConstant(1.42185131955962610754381949443812224e-02), PetscRealConstant(2.06435102858885633793752715112996953e-02),
                                                        PetscRealConstant(3.04687021860365991624316179706153644e-02), PetscRealConstant(4.59671800534832124606203375455940374e-02), PetscRealConstant(6.30750697863099501530503897632872274e-02),
                                                        PetscRealConstant(4.93038296963817065810271603280873299e-02), PetscRealConstant(3.53064555288569531944851778989483626e-03), PetscRealConstant(6.35060387320061539418974449993407205e-02),
                                                        PetscRealConstant(1.93909689737100915978594664571338820e-02), PetscRealConstant(5.26926439547814663703629976900645955e-02), PetscRealConstant(6.56415310367163851189068346233285983e-03),
                                                        PetscRealConstant(3.62158898624249001293051273971333980e-02), PetscRealConstant(5.85263020694040081229365769811397477e-03), PetscRealConstant(3.22043255280482164199840269652875835e-02),
                                                        PetscRealConstant(1.69117749990729936350421409071818885e-02), PetscRealConstant(6.65440272571877651794636251088257039e-03)};

static const PetscReal PetscDTWVTriQuad_19_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(5.25238903512089670147565060224366915e-02), PetscRealConstant(8.94952219297582065970486987955126617e-01),
                                                       PetscRealConstant(4.92512675041336869496897663589624726e-01), PetscRealConstant(1.49746499173262610062046728207505477e-02), PetscRealConstant(1.11448873323021376452705295704714309e-01),
                                                       PetscRealConstant(7.77102253353957247094589408590571287e-01), PetscRealConstant(4.59194201039543657470193928950812985e-01), PetscRealConstant(8.16115979209126850596121420983740297e-02),
                                                       PetscRealConstant(4.03969722551901196608037508536179537e-01), PetscRealConstant(1.92060554896197606783924982927640927e-01), PetscRealConstant(1.78170104781764310842771841000729780e-01),
                                                       PetscRealConstant(6.43659790436471378314456317998540439e-01), PetscRealConstant(1.16394611837894469209866999446273638e-02), PetscRealConstant(9.76721077632421106158026600110745176e-01),
                                                       PetscRealConstant(2.55161632913607697508749449021043292e-01), PetscRealConstant(4.89676734172784604982501101957913416e-01), PetscRealConstant(1.30697676268032404569608942347127650e-01),
                                                       PetscRealConstant(8.30156464400275374105719186549981383e-01), PetscRealConstant(3.91458593316922213246718711028910149e-02), PetscRealConstant(3.11317629809541252775130649786984519e-01),
                                                       PetscRealConstant(5.59369805720300914158853798356514002e-01), PetscRealConstant(1.29312564470157833066015551856501479e-01), PetscRealConstant(2.06892589660480761010570185940547822e-03),
                                                       PetscRealConstant(6.33313293128784133046867658991000573e-01), PetscRealConstant(3.64617780974611059343026639149593948e-01), PetscRealConstant(7.45602946016266785370651254126517829e-02),
                                                       PetscRealConstant(7.04004819966042109880879190781659201e-01), PetscRealConstant(2.21434885432331211582055683805688992e-01), PetscRealConstant(5.00728825735449113349109438258286844e-03),
                                                       PetscRealConstant(8.52566954376889199678253315174004952e-01), PetscRealConstant(1.42425757365756309188255590443412179e-01), PetscRealConstant(4.08880111960168761391278955287946173e-02),
                                                       PetscRealConstant(6.05083979068707964112849419188932407e-01), PetscRealConstant(3.54028009735275159748022685282272928e-01), PetscRealConstant(2.41894578960579568578028997193141377e-01),
                                                       PetscRealConstant(7.43181368957436359746570616731497975e-01), PetscRealConstant(1.49240520819840716754003860753606240e-02), PetscRealConstant(6.00862753223066979923962459578579164e-02),
                                                       PetscRealConstant(9.30137698876805146656288025078018989e-01), PetscRealConstant(9.77602580088815535131572896412304600e-03)};

static const PetscReal PetscDTWVTriQuad_20_weights[] = {PetscRealConstant(5.56404428058124636315667882538980513e-02), PetscRealConstant(5.63328052300809901286417841247306969e-02), PetscRealConstant(3.19536316426647944789458473306577694e-03),
                                                        PetscRealConstant(3.13209231042981336844070036488942015e-02), PetscRealConstant(3.66938518970116579192528541181380465e-02), PetscRealConstant(3.78095997329297907473141626407995995e-02),
                                                        PetscRealConstant(8.64510164266231010469272215780677435e-03), PetscRealConstant(5.51522025162818360535508908632773918e-02), PetscRealConstant(2.84073012136337619676804659244792901e-02),
                                                        PetscRealConstant(8.81158967423399025613127081578538403e-03), PetscRealConstant(2.39455943158187600805852561449991661e-02), PetscRealConstant(4.51947840850346211792351505839295613e-03),
                                                        PetscRealConstant(3.46689022688773322487306260580357352e-02), PetscRealConstant(1.65828461104554308510494506356304760e-02), PetscRealConstant(3.08904312883969193774816506508534169e-02),
                                                        PetscRealConstant(1.47827260010211919128768744527703816e-02), PetscRealConstant(4.67669829273109477301843109377818525e-02), PetscRealConstant(1.43128009538307414597253464311717363e-02)};

static const PetscReal PetscDTWVTriQuad_20_orbits[] = {PetscRealConstant(3.33333333333333333333333333333333317e-01), PetscRealConstant(2.54579267673339112384852648127384608e-01), PetscRealConstant(4.90841464653321775230294703745230735e-01),
                                                       PetscRealConstant(1.09761410283977640396480118588797861e-02), PetscRealConstant(9.78047717943204471920703976282240428e-01), PetscRealConstant(1.09383596711714597016872474899833628e-01),
                                                       PetscRealConstant(7.81232806576570805966255050200332744e-01), PetscRealConstant(1.86294997744540942771732508057624336e-01), PetscRealConstant(6.27410004510918114456534983884751328e-01),
                                                       PetscRealConstant(4.45551056955924815187222278434214383e-01), PetscRealConstant(1.08897886088150369625555443131571187e-01), PetscRealConstant(3.73108805988846939935037162872162158e-02),
                                                       PetscRealConstant(9.25378238802230612012992567425567568e-01), PetscRealConstant(3.93425347817099858678963743503277586e-01), PetscRealConstant(2.13149304365800282642072512993444828e-01),
                                                       PetscRealConstant(4.76245611540499013210351872232590978e-01), PetscRealConstant(4.75087769190019735792962555348180931e-02), PetscRealConstant(7.57078050469652826323345852856152620e-03),
                                                       PetscRealConstant(8.33295511838236247172151190043086572e-01), PetscRealConstant(1.59133707657067224564615351428351854e-01), PetscRealConstant(4.65603649076643165137695546052680653e-02),
                                                       PetscRealConstant(7.54921502863547505106208742386882967e-01), PetscRealConstant(1.98518132228788178380021703007848968e-01), PetscRealConstant(6.40905856084340600498656676178301729e-02),
                                                       PetscRealConstant(9.31054476783942186661769180803256055e-01), PetscRealConstant(4.85493760762375328836515157891377252e-03), PetscRealConstant(5.49874791429868106342272485158147754e-02),
                                                       PetscRealConstant(6.11877703547425699938147653821642741e-01), PetscRealConstant(3.33134817309587489427625097662542532e-01), PetscRealConstant(9.99522962881386553829078233471162010e-02),
                                                       PetscRealConstant(8.61684018936486749244480824205732291e-01), PetscRealConstant(3.83636847753745953726113524471515084e-02), PetscRealConstant(1.06227204720270042362554302053892438e-01),
                                                       PetscRealConstant(6.78165737889635554607997729995615973e-01), PetscRealConstant(2.15607057390094403029447967950491589e-01), PetscRealConstant(4.20023758816224079646442916947268955e-01),
                                                       PetscRealConstant(5.70144692890973359775045847324044273e-01), PetscRealConstant(9.83154829280256057851123572868674818e-03), PetscRealConstant(3.17860123835772015975967671630259648e-01),
                                                       PetscRealConstant(5.42331804172428085429880844401323216e-01), PetscRealConstant(1.39808071991799898594151483968417184e-01), PetscRealConstant(1.07372128560110873305245610078957647e-02),
                                                       PetscRealConstant(7.08681375720323677831988908448040975e-01), PetscRealConstant(2.80581411423665234837486530544063212e-01)};

static const PetscInt PetscDTWVTriQuad_max_degree = 20;

static const PetscInt PetscDTWVTriQuad_num_nodes[] = {1, 1, 3, 6, 6, 7, 12, 15, 16, 19, 25, 28, 33, 37, 42, 49, 55, 60, 67, 73, 79};

static const PetscInt PetscDTWVTriQuad_num_orbits[] = {1, 0, 0, 1, 0, 0, 0, 1, 0, 0, 2, 0, 0, 2, 0, 1, 2, 0, 0, 2, 1, 0, 3, 1, 1, 3, 1, 1, 4, 1, 1, 2, 3, 1, 5, 2, 0, 5, 3, 1, 4, 4, 0, 6, 4, 1, 6, 5, 1, 6, 6, 0, 6, 7, 1, 6, 8, 1, 8, 8, 1, 8, 9};

static const PetscReal *PetscDTWVTriQuad_weights[] = {PetscDTWVTriQuad_1_weights,  PetscDTWVTriQuad_1_weights,  PetscDTWVTriQuad_2_weights,  PetscDTWVTriQuad_4_weights,  PetscDTWVTriQuad_4_weights,  PetscDTWVTriQuad_5_weights,
                                                      PetscDTWVTriQuad_6_weights,  PetscDTWVTriQuad_7_weights,  PetscDTWVTriQuad_8_weights,  PetscDTWVTriQuad_9_weights,  PetscDTWVTriQuad_10_weights, PetscDTWVTriQuad_11_weights,
                                                      PetscDTWVTriQuad_12_weights, PetscDTWVTriQuad_13_weights, PetscDTWVTriQuad_14_weights, PetscDTWVTriQuad_15_weights, PetscDTWVTriQuad_16_weights, PetscDTWVTriQuad_17_weights,
                                                      PetscDTWVTriQuad_18_weights, PetscDTWVTriQuad_19_weights, PetscDTWVTriQuad_20_weights};

static const PetscReal *PetscDTWVTriQuad_orbits[] = {PetscDTWVTriQuad_1_orbits,  PetscDTWVTriQuad_1_orbits,  PetscDTWVTriQuad_2_orbits,  PetscDTWVTriQuad_4_orbits,  PetscDTWVTriQuad_4_orbits,  PetscDTWVTriQuad_5_orbits,  PetscDTWVTriQuad_6_orbits,
                                                     PetscDTWVTriQuad_7_orbits,  PetscDTWVTriQuad_8_orbits,  PetscDTWVTriQuad_9_orbits,  PetscDTWVTriQuad_10_orbits, PetscDTWVTriQuad_11_orbits, PetscDTWVTriQuad_12_orbits, PetscDTWVTriQuad_13_orbits,
                                                     PetscDTWVTriQuad_14_orbits, PetscDTWVTriQuad_15_orbits, PetscDTWVTriQuad_16_orbits, PetscDTWVTriQuad_17_orbits, PetscDTWVTriQuad_18_orbits, PetscDTWVTriQuad_19_orbits, PetscDTWVTriQuad_20_orbits};

#endif // #define PETSCDTTRIQUADRULES_H
