/* Copyright (C) 2022-2024 Marco Scarpetta
 *
 * This file is part of PDF Mix Tool.
 *
 * PDF Mix Tool is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * PDF Mix Tool is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with PDF Mix Tool. If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef OUTPUTPREVIEW_H
#define OUTPUTPREVIEW_H

#include <QWidget>
#include <poppler/qt6/poppler-qt6.h>

#include "../pdf_edit_lib/definitions.h"
#include "../pdf_edit_lib/pdf_info.h"
#include "../gui_utils.h"

class CachedPage {
public:
    double res;
    QImage image;
};

class OutputPreview : public QWidget
{
    Q_OBJECT
public:
    explicit OutputPreview(QWidget *parent = nullptr);

    ~OutputPreview();

    void set_page_size(double width, double height);

    void set_pdf_info(const PdfInfo &pdf_info);

    void set_multipage_enabled(bool enabled);

    void set_rotation(int rotation);

    void show_crop(double top, double bottom, double left, double right);

    void hide_crop();

    void set_first_page(int page=0);

    int first_page();

public slots:
    void set_multipage(const Multipage &multipage);

protected:
    void paintEvent(QPaintEvent *event) override;

private:
    bool m_has_page_size;
    double m_page_width;
    double m_page_height;
    int m_num_pages;
    Poppler::Document *m_document;
    bool m_multipage_enabled;
    Multipage m_multipage;
    int m_rotation;
    bool m_show_crop;
    double m_crop_top;
    double m_crop_bottom;
    double m_crop_left;
    double m_crop_right;
    int m_first_page;
    QMap<int, CachedPage *> m_page_cache;

    double draw_preview_page(QPainter &painter,
                             int max_width,
                             int max_height,
                             double page_width,
                             double page_height,
                             Multipage::Alignment h_alignment,
                             Multipage::Alignment v_alignment,
                             int draw_pdf_page=-1,
                             const QString &text="");

    void delete_cached_pages();
};

#endif // OUTPUTPREVIEW_H
