'\"
'\" Copyright (c) 2008 Paul H Alfille, MD
'\" (palfille@gmail.com)
'\"
'\" Library manual page for the OWFS -- 1-wire filesystem package
'\" Based on Dallas Semiconductor, Inc's datasheets, and trial and error.
'\"
'\" Free for all use. No waranty. None. Use at your own risk.
'\" $Id$
'\"
.TH OWNET 1 2008 "OWFS Manpage" "One-Wire File System"
.SH NAME
.B ownet
,
.B (libownet)
\- easy C-language 1-wire interface to the owserver protocol
.SH SYNOPSIS
.B libownet
library to link with your program
.SS Handle
.B OWNET_HANDLE
.br
Handle to each owserver connection
.SS Initialization
.B OWNET_HANDLE OWNET_init( const char * 
.I owserver_tcp_address_and_port 
.B )
.br
Associate an 
.B owserver (1)
tcp/ip address with a handle.
.SS Directory listing
.B int OWNET_dirlist( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , char ** 
.I comma_separated_list 
.B )
.br
Create a comma-separated list of directory elements.
.PP
.B int OWNET_dirprocess( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , void (*
.I dirfunc
.B ) (void *, const char *), void * 
.I passed_on_value 
.B )
.br
.B void 
.I dirfunc
.B ( void *
.I passed_on_value
.B , const char *
.I directory_element
.B )
.br
Apply function 
.I dirfunc
to each directory element, along with an arbitrary passed_on_value.
.SS Get data
.B int OWNET_read( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , const char ** 
.I return_string
.B )
.br
Read a value (of specified size) from a 1-wire device.
.PP
.B int OWNET_lread( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , const char ** 
.I return_string
.B , size_t 
.I size
.B , off_t 
.I offset
.B )
.br
Read a value (of specified size and offset) from a 1-wire device.
.PP
.B int OWNET_present( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B )
.br
Check if a 1-wire device is present.
.SS Set data
.B int OWNET_put( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , const char * 
.I value_string
.B , size_t 
.I size
.B )
.br
Write a value (of specified size) to a 1-wire device.
.PP
.B int OWNET_lwrite( OWNET_HANDLE 
.I owserver_handle 
.B , const char * 
.I onewire_path
.B , const char * 
.I value_string
.B , size_t 
.I size
.B , off_t 
.I offset
.B )
.br
Write a value (of specified size and offset) to a 1-wire device.
.SS Close
.B void OWNET_close( OWNET_HANDLE 
.I owserver_handle 
.B )
.br
Close the connection to a particular owserver.
.PP
.B void OWNET_closeall( void )
.br
Close all open owserver connections.
.PP
.B void OWNET_finish( void )
.br
Close all open owserver connections and free all memory.
.SS Temperature scale
.B void OWNET_set_temperature_scale( char 
.I temperature_scale
.B )
.br
.B char OWNET_get_temperature_scale( void )
.br
Set and retrieve the temperature scale used for all communications.
.SS Device format
.B void OWNET_set_device_format( const char * 
.I device_format
.B )
.br
.B const char * OWNET_get_device_format( void )
.br
Set and retrieve the 1-wire device serial number format used for all communications.
.SH FUNCTIONS
.SS OW_init
.I OW_init_string
offers the full flexibility of the
.B owfs (1)
and
.B owhttpd (1)
command line.
.TP
.I Arguments
Can be as simple as jus the device name, a full parameter specification.
One or more device names (includes tcp, serial, usb...) and command line switches. See
.B owfs (1)
for full syntax.
.TP
.I Returns
0 for success. \-1 on error and
.I errno
will be set.
.I OW_finish
does not need to be called if
.I OW_init
fails.
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_init_args
.I OW_init_args
offers the full flexibility of the
.B owfs (1)
and
.B owhttpd (1)
command line.
.TP
.I Arguments
One or more device names (includes tcp, serial, usb...) and command line switches. See
.B owfs (1)
for full syntax. Unlike
.I OW_init_string
the arguments are in argv/argc format.
.TP
.I Returns
0 for success. \-1 on error and
.I errno
will be set.
.I OW_finish
does not need to be called if
.I OW_init
fails.
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_get
.I OW_get
is used to get directory listings and file contents. The results are put in a dynamically allocated buffer.
.TP
.I Arguments
.I path
is the path to the directory or file (property).
.I *buffer
returns a pointer to a buffer containing the directory (comma separated) or value.
.I buffer_length
returns the length of the value/string in
.I buffer
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.TP
.I Important note
.I buffer
is allocated ( with malloc ) by
.I OW_get
but must be freed in your program. See
.B malloc (3)
and
.B free (3)
.SS OW_lread
.I OW_lread
is used to read 1-wire memory chips. Think of it as a combination of
.I lseek
and
.I read
It allows random-access to the memory, specifying location and length. Unlike
.I OW_get
directories cannot be obtained and the buffer must be pre-allocated rather than allocated by the routine.
.I buffer
must be at least
.I size
length.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the (pre-allocated) memory area where the value will be placed.
.I size
is the length of bytes requested.
.I offset
is the position in file to start reading.
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_put
.I OW_put
is an easy way to write to 1-wire chips.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the value to be written.
.I buffer_length
is the length of the value
.I buffer.
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_lwrite
.I OW_lwrite
is the companion of
.I OW_lread.
It allows writing to arbitrary positions in 1-wire memory.
Think of it as a combination of
.I lseek
and
.I write.
.I buffer
must be at least
.I size
length.
.TP
.I Arguments
.I path
is the path to the file (property).
.I buffer
is the data to be written.
.I size
is the length of bytes to be written.
.I offset
is the position in file to start writing.
.TP
.I Returns
number of bytes on success. \-1 on error (and
.I errno
is set).
.TP
.I Sequence
One of the
.I init
functions must be called before accessing the 1-wire bus.
.I OW_finish
is optional.
.SS OW_finish
.I OW_finish
cleans up the
.I OWFS
1-wire routines, releases devices and memory.
.TP
.I Arguments
None.
.TP
.I Returns
None
.TP
.I Sequence
.I OW_finish
is optional since cleanup is automatic on program exit.
.SH "DESCRIPTION"
.so man1/description.1so
.SS libowcapi
.B libowcapi (1)
is an encapsulation of the full
.B libow
library for C programs.
.PP
.B libowcapi (1)
allows a C program to use
.I OWFS
principles (consistent naming scheme, multiple adapters, devices, and compatibility) directly from a C program. There are analogous modules for other programming languages:
.TP
.I C
libowcapi
.TP
.I perl
owperl
.TP
.I php
owphp
.TP
.I python
owpython
.TP
.I tcl
owtcl
.SH EXAMPLE
/* Simple directory listing -- no error checking */
.br
#include <ownetapi.h>
.br
char * buf;
.br
size_t s ;
.br
OWNET_init("localhost:4304");
.br
OWNET_dirlist("/",&buf,&s) ;
.br
printf("Directory %s\n",buf);
.br
free(buf);
.br
OWNET_finish() ;
.SH SEE ALSO
.so man1/seealso.1so
.SH AVAILABILITY
http://www.owfs.org
.SH AUTHOR
Paul Alfille (paul.alfille@gmail.com)
