#ifndef OSMIUM_OSM_HPP
#define OSMIUM_OSM_HPP

/*

Copyright 2012 Jochen Topf <jochen@topf.org> and others (see README).

This file is part of Osmium (https://github.com/joto/osmium).

Osmium is free software: you can redistribute it and/or modify it under the
terms of the GNU Lesser General Public License or (at your option) the GNU
General Public License as published by the Free Software Foundation, either
version 3 of the Licenses, or (at your option) any later version.

Osmium is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR A
PARTICULAR PURPOSE. See the GNU Lesser General Public License and the GNU
General Public License for more details.

You should have received a copy of the Licenses along with Osmium. If not, see
<http://www.gnu.org/licenses/>.

*/

namespace Osmium {

    /**
    *  @brief Basic classes for tags, nodes, ways, etc.
    */
    namespace OSM {
    } // namespace OSM

} // namespace Osmium

#include <osmium/osm/types.hpp>
#include <osmium/osm/tag.hpp>
#include <osmium/osm/tag_list.hpp>
#include <osmium/osm/object.hpp>
#include <osmium/osm/node.hpp>
#include <osmium/osm/way.hpp>
#include <osmium/osm/relation_member.hpp>
#include <osmium/osm/relation_member_list.hpp>
#include <osmium/osm/relation.hpp>
#include <osmium/osm/area.hpp>

#endif // OSMIUM_OSM_HPP
