# SPDX-FileCopyrightText: 2023 Greenbone AG
# Some text descriptions might be excerpted from (a) referenced
# source(s), and are Copyright (C) by the respective right holder(s).
#
# SPDX-License-Identifier: GPL-2.0-or-later

if(description)
{
  script_oid("0.0.0.0.0.0.0.0.0.1");
  script_version("2022-11-14T13:47:12+0000");
  script_tag(name:"cvss_base", value:"9.0");
  script_tag(name:"cvss_base_vector", value:"AV:N/AC:L/Au:N/C:N/I:N/A:C");
  script_tag(name:"last_modification", value:"2022-11-14 13:47:12 +0000 (Mon, 14 Feb 2022)");
  script_tag(name:"creation_date", value:"2013-04-16 11:21:21 +0530 (Tue, 16 Apr 2013)");
  script_name("that is a very long and descriptive name");

  script_category(ACT_DENIAL);
  script_tag(name:"qod_type", value:"remote_vul");
  script_copyright("Copyright (C) 2022 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("ssh_detect.nasl");
  script_require_ports("Services/ssh", 22);
  script_mandatory_keys("ssh/blubb/detected");

  script_tag(name:"impact", value:"Successful exploitation will allow remote attackers to destroy the world. Lets sing the doom song now.");

  script_tag(name:"affected", value:"Everything.");

  script_tag(name:"insight", value:"The flaw is very risky...
  ...
  quasi exponential. Doom.");

  script_tag(name:"solution", value:"Upgrade.");

  script_tag(name:"solution_type", value:"VendorFix");
  script_tag(name:"summary", value:"This triggered by something, probably sending bytes");

  exit(0);
}

include("ssh_func.inc");
include("misc_func.inc");
include("port_service_func.inc");

port = ssh_get_port(default:22);
banner = ssh_get_serverbanner(port:port);
if (!banner || "Blubb" >!< banner)
  exit(0);

soc = open_sock_tcp(port);
if(!soc)
  exit(0);

ini_req = raw_string(0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                     0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                     0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                     0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                     0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42);

req = raw_string(0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,

                 ##3rd byte in this next line causes crash
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42, 0x42,
                 0x42);


send(socket:soc, data:ini_req);
recv(socket:soc, length:1024);

send(socket:soc, data:req);
recv(socket:soc, length:1024);

close(soc);

sleep(5);

soc2 = open_sock_tcp(port);
if(!soc2)
{
  security_message(port);
  exit(0);
}
else
{
  resp = recv(socket:soc2, length:1024);
  if("Blubb" >!< resp)
  {
    close(soc2);
    security_message(port);
    exit(0);
  }
}

close(soc2);
