###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_neon_detect.nasl 4213 2009-08-26 20:41:29Z aug $
#
# WebDAV Neon Version Detection
#
# Authors:
# Sharath S <sharaths@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900827);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("WebDAV Neon Version Detection");
  desc = "
  Overview: This script detects the installed version of WebDAV Neon and
  sets the reuslt in KB.

  Risk Factor: None";

  script_description(desc);
  script_summary("Set KB for the version of WebDAV Neon");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  exit(0);
}


include("ssh_func.inc");
include("version_func.inc");

neon_sock = ssh_login_or_reuse_connection();
if(!neon_sock){
  exit(0);
}

paths = find_file(file_name:"neon-config", file_path:"/", useregex:TRUE,
                  regexpar:"$", sock:neon_sock);

foreach binName (paths)
{
  neonVer = get_bin_version(full_prog_name:chomp(binName), sock:neon_sock,
                            version_argv:"--version",
                            ver_pattern:"neon ([0-9]+\.[0-9]+\.[0-9]+)");

  if(neonVer[1] != NULL)
  {
    set_kb_item(name:"WebDAV/Neon/Ver", value:neonVer[1]);
    security_note(data:"WebDAV Neon version " + neonVer[1] + 
                       " was detected on the host");
    ssh_close_connection();
    exit(0);
  }
}
ssh_close_connection();
