###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_admin_news_tools_detect.nasl 3594 2009-07-30 12:41:24Z jul $
#
# Admin News Tools Version Detection
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900904);
  script_version("Revision: 1.0$");
  script_tag(name:"risk_factor", value:"None");
  script_name("Admin News Tools Version Detection");
  desc = "

  Overview: This script detects the installed version of Admin News Tool
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Admin News Tool");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Service detection");
  script_dependencies("http_version.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");

antPort = get_http_port(default:80);
if(!antPort){
  exit(0);
}

foreach dir (make_list("/ant","/Ant","/ANT", cgi_dirs()))
{
  foreach path (make_list("/news/admin/index.php", "/Lisez%20moi.txt",
                                                   "/Readme.txt"))
  {
    sndReq = http_get(item:string(dir, path), port:antPort);
    rcvRes = http_send_recv(port:antPort, data:sndReq);

    if(("200 OK" >< rcvRes) && ("Admin News Tools" >< rcvRes))
    {
      antVer = eregmatch(pattern:"Admin News Tools v([0-9.]+)", string:rcvRes);
      if(antVer[1] != NULL){
        set_kb_item(name:"www/" + antPort + "/Admin-New-Tools",
                            value:antVer[1] + " under " + dir);
        security_note(data:"Admin News Tools version " + antVer[1] +
                " running at location " + dir +  " was detected on the host");
      }
    }
  }
}
