###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_symantec_altiris_ns_detect.nasl 7083 2010-02-11 19:06:24Z feb $
#
# Symantec Altiris Notification Server Version Detection
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
# ###############################################################################

if(description)
{
  script_id(800984);
  script_version("$Revision: 7732 $: 1.0");
  script_tag(name:"risk_factor", value:"None");
  script_name("Symantec Altiris Notification Server Version Detection");
  desc = "
  Overview: This script detects the installed version of Symantec Altiris
  Notification Server and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets Symantec Altiris Notification Server Version in the KB");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Service detection");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\Altiris")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
foreach item (registry_enum_keys(key:key))
{
  altirisName = registry_get_sz(key:key + item, item:"DisplayName");
  if("Altiris Notification Server" >< altirisName)
  {
    altirisVer1 = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(altirisVer1 != NULL ){
      set_kb_item(name:"Symantec/AltirisNS/Ver", value:altirisVer1);
      security_note(data:"Symantec Altiris Notification Server version " + 
                          altirisVer1 + " was detected on the host");

    }
  }

  if("Altiris NS" >< altirisName)
  {
    altirisVer2 = registry_get_sz(key:key + item, item:"DisplayVersion");
    if(altirisVer2 != NULL)
    {
      set_kb_item(name:"Symantec/AltirisNS/SP", value:altirisVer2);
      security_note(data:"Symantec Altiris Notification Server version " + 
                          altirisVer2 + " was detected on the host");
    }
  }
}
