###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_mysql_dos_n_spoofing_vuln.nasl 5988 2009-12-03 21:29:17Z dec $
#
# MySQL Denial Of Service and Spoofing Vulnerabilities
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(801064);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"6.4");
  script_tag(name:"risk_factor", value:"High");
  script_cve_id("CVE-2009-4019","CVE-2009-4028");
  script_name("MySQL Denial Of Service and Spoofing Vulnerabilities");
  desc = "
  Overview: The host is running MySQL and is prone to Denial Of Service
  and Spoofing Vulnerabilities

  Vulnerability Insight:
  The flaws are due to:
  - mysqld does not properly handle errors during execution of certain SELECT
    statements with subqueries, and does not preserve certain null_value flags
    during execution of statements that use the 'GeomFromWKB()' function.
  - An error in 'vio_verify_callback()' function in 'viosslfactories.c', when
    OpenSSL is used, accepts a value of zero for the depth of X.509 certificates.

  Impact:
  Successful exploitation could allow users to cause a Denial of Service and
  man-in-the-middle attackers to spoof arbitrary SSL-based MySQL servers via
  a crafted certificate.

  Impact Level: Application

  Affected Software/OS:
  MySQL 5.0.x before 5.0.88 and 5.1.x before 5.1.41 on all running platform.

  Fix: Upgrade to MySQL version 5.0.88 or 5.1.41
  For Updates Refer, http://dev.mysql.com/downloads

  References:
  http://bugs.mysql.com/47780
  http://bugs.mysql.com/47320
  http://marc.info/?l=oss-security&m=125881733826437&w=2
  http://dev.mysql.com/doc/refman/5.0/en/news-5-0-88.html

  CVSS Score:
    CVSS Base Score      : 6.4 (AV:N/AC:L/Au:NR/C:N/I:P/A:P)
    CVSS Temporal Score  : 4.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of MySQL");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Denial of Service");
  script_dependencies("mysql_version.nasl");
  script_require_ports("Services/mysql", 3306);
  exit(0);
}


include("misc_func.inc");
include("version_func.inc");

sqlPort = get_kb_item("Services/mysql");
if(!sqlPort){
  sqlPort = 3306;
}

if(!get_port_state(sqlPort)){
  exit(0);
}

mysqlVer = get_mysql_version(port:sqlPort);
if(isnull(mysqlVer)){
  exit(0);
}

mysqlVer = eregmatch(pattern:"([0-9.a-z]+)", string:mysqlVer);
if(!isnull(mysqlVer[1]))
{
  if(version_in_range(version:mysqlVer[1], test_version:"5.0",test_version2:"5.0.87") ||
     version_in_range(version:mysqlVer[1], test_version:"5.1",test_version2:"5.1.40")){
    security_warning(sqlPort);
  }
}
