###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_lussumo_vanilla_xss_vuln.nasl 2613 2009-06-04 15:11:27Z june $
#
# Vanilla 'RequestName' Cross-Site Scripting Vulnerability
#
# Authors:
# Antu Sanadi<santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800623);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-1845");
  script_bugtraq_id(35114);
  script_name("Vanilla 'RequestName' Cross-Site Scripting Vulnerability");
  desc = "

  Overview: The host is running Lussumo Vanilla and is prone to Cross-Site
  Scripting Vulnerability.

  Vulnerability Insight:
  Error is caused due to improper sanitization of user supplied input in the
  'RequestName' parameter in '/ajax/updatecheck.php' file.

  Impact:
  Successful exploitation could allow remote attackers to execute arbitrary
  HTML and script code in a user's browser session in context of an affect
  site and it result XSS attack.

  Impact Level: Application.

  Affected Software/OS:
  Lussumo Vanilla 1.1.7 and prior on all running platform.

  Fix: No solution or patch is available as on 04th June, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://getvanilla.com/

  References:
  http://secunia.com/advisories/35234
  http://gsasec.blogspot.com/2009/05/vanilla-v117-cross-site-scripting.html

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:N/I:P/A:N)
    CVSS Temporal Score  : 3.4
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the Version Lussumo Vanilla");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_dependencies("gb_lussumo_vanilla_detect.nasl");
  script_family("Web application abuses");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

vanillaPort = get_http_port(default:80);
if(!vanillaPort){
  exit(0);
}

vanillaVer = get_kb_item("www/" + vanillaPort + "/Lussumo/Vanilla");
if(!vanillaVer){
  exit(0);
}

vanillaVer = eregmatch(pattern:"^(.+) under (/.*)$", string:vanillaVer);

if(!safe_checks() && vanillaVer[2] != NULL)
{
  sndReq = http_get(item:string(vanillaVer[2], "/index.php"), port:vanillaPort);
  rcvRes = http_send_recv(port:vanillaPort, data:sndReq);
  if("Vanilla" >< rcvRes)
  {
    request = http_get(item:vanillaVer[2] + "/ajax/updatecheck.php?PostBack" +
                            "Key=1&ExtensionKey=1&RequestName=1<script>alert" +
                            "(Exploit-XSS)</script>",
                       port:vanillaPort);
    response = http_send_recv(port:vanillaPort, data:request);
    if("Exploit-XSS" >< response)
    {
      security_hole(vanillaPort);
      exit(0);
    }
  }
}

if(vanillaVer[1] != NULL)
{
  if(version_is_less_equal(version:vanillaVer[1], test_version:"1.1.8")){
    security_hole(vanillaPort);
  }
}
