# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 479-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53682);
 script_cve_id("CVE-2004-0003", "CVE-2004-0010", "CVE-2004-0109", "CVE-2004-0177", "CVE-2004-0178");
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.2");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 479-1 (kernel)";
 script_name(name);

 desc = "The remote host is missing an update to kernel-source-2.4.18,
kernel-image-2.4.18-1-alpha, kernel-image-2.4.18-1-i386,
kernel-image-2.4.18-i386bf, kernel-patch-2.4.18-powerpc
announced via advisory DSA 479-1.

Several serious problems have been discovered in the Linux kernel.
This update takes care of Linux 2.4.18 for the alpha, i386 and powerpc
architectures.  The Common Vulnerabilities and Exposures project
identifies the following problems that will be fixed with this update:

CVE-2004-0003

A vulnerability has been discovered in the R128 drive in the Linux
kernel which could potentially lead an attacker to gain
unauthorised privileges.  Alan Cox and Thomas Biege developed a
correction for this

CVE-2004-0010

Arjan van de Ven discovered a stack-based buffer overflow in the
ncp_lookup function for ncpfs in the Linux kernel, which could
lead an attacker to gain unauthorised privileges.  Petr Vandrovec
developed a correction for this.

CVE-2004-0109

zen-parse discovered a buffer overflow vulnerability in the
ISO9660 filesystem component of Linux kernel which could be abused
by an attacker to gain unauthorised root access.  Sebastian
Krahmer and Ernie Petrides developed a correction for this.

CVE-2004-0177

Solar Designer discovered an information leak in the ext3 code of
Linux.  In a worst case an attacker could read sensitive data such
as cryptographic keys which would otherwise never hit disk media.
Theodore Ts'o developed a correction for this.

CVE-2004-0178

Andreas Kies discovered a denial of service condition in the Sound
Blaster driver in Linux.  He also developed a correction.

These problems will also be fixed by upstream in Linux 2.4.26 and
future versions of 2.6.

The following security matrix explains which kernel versions for which
architecture are already fixed.  Kernel images in the unstable Debian
distribution (sid) will be fixed soon.

Architecture    stable (woody)     unstable (sid)    removed in sid
source          2.4.18-14.3        2.4.25-3          --
alpha           2.4.18-15          soon              --
i386            2.4.18-13          soon              --
i386bf          2.4.18-5woody8     soon              --
powerpc         2.4.18-1woody5     2.4.25-8          2.4.22

We recommend that you upgrade your kernel packages immediately, either

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20479-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 479-1 (kernel)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kernel-doc-2.4.18", ver:"2.4.18-14.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-source-2.4.18", ver:"2.4.18-14.3", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-patch-2.4.18-powerpc", ver:"2.4.18-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-generic", ver:"2.4.18-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-smp", ver:"2.4.18-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-generic", ver:"2.4.18-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-smp", ver:"2.4.18-15", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-386", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-586tsc", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-686", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-686-smp", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-k6", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-1-k7", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-386", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-586tsc", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-686", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-686-smp", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-k6", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-1-k7", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-386", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-586tsc", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-686", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-686-smp", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-k6", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-pcmcia-modules-2.4.18-1-k7", ver:"2.4.18-13", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18-bf2.4", ver:"2.4.18-5woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-bf2.4", ver:"2.4.18-5woody8", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-headers-2.4.18", ver:"2.4.18-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-newpmac", ver:"2.4.18-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-powerpc", ver:"2.4.18-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kernel-image-2.4.18-powerpc-smp", ver:"2.4.18-1woody5", rls:"DEB3.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
