/* NessusClient
 * Copyright (C) 1998 Renaud Deraison
 * Copyright (C) 2004 Intevation GmbH
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2
 * as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * In addition, as a special exception, Renaud Deraison
 * gives permission to link the code of this program with any
 * version of the OpenSSL library which is distributed under a
 * license identical to that listed in the included COPYING.OpenSSL
 * file, and distribute linked combinations including the two.
 * You must obey the GNU General Public License in all respects
 * for all of the code used other than OpenSSL.  If you modify
 * this file, you may extend this exception to your version of the
 * file, but you are not obligated to do so.  If you do not wish to
 * do so, delete this exception statement from your version.
 */

#ifndef _NESSUSC_PREFERENCES_H
#define _NESSUSC_PREFERENCES_H

#include "context.h"

int    preferences_init(struct context *);
void   preferences_save(struct context *);
void   preferences_save_as(struct context *, char *);
struct arglist *prefs_get_pluginset(struct context *, char *, struct nessus_plugin *);
int    preferences_process_filename(struct context *, char *);
int    preferences_generate_new_file(struct context *, const char *);
char * preferences_get_altname(struct context *, const char *);
void * prefs_get_default(struct context *, const char *);
void * prefs_get_value(struct context *, const char *);
#define prefs_get_int(context, name) (GPOINTER_TO_SIZE(prefs_get_value(context, name)))
#define prefs_get_string(context, name) ((const char *)prefs_get_value(context, name))
void   prefs_set_value(struct context *, const char *, void *, int);
void   prefs_set_int(struct context *, const char *, int);
void   prefs_set_string(struct context *, const char *, const char *);
int    prefs_has_options(struct context *);
char * prefs_get_nessushome(void);
gboolean preferences_yes_or_one (struct arglist* argl, char* prefname);
    
#ifdef _WIN32
/* applies to some windows misunderstanding */
#define CANNOT_SET_HOMEVAR "\
There is no personal directory known, where Nessus can store the key\n\
and the configuration cache.\n\
\n\
So please set the environment variable NESSUSHOME with explicit path\n\
(eg. C:\\WHAT\\SO\\EVER\\...) to some existing directory.  Make sure that\n\
this variable is set every time you have Windows rebooted.\n\
\n\
Having finshed with the NESSUSHOME variable, close all message boxes\n\
to terminate Nessus, then restart Nessus, again."

#else /* not  _WIN32 */
#define CANNOT_SET_HOMEVAR "\
Your HOME environment variable might be unset,  or your home directiory\n\
might be unaccessable.  So you need to check/set your HOME variable.\n\
\n\
In case you do not want to change HOME, you can alternatively set the\n\
variable NESSUSHOME, instead (do not forget to \"export NESSUSHOME;\"\n\
after setting it.  NESSUSHOME overwrites the meaning of HOME for this\n\
application."
#endif /* _WIN32 */

#endif
