#! /usr/bin/env python

from __future__ import print_function
from openturns import *
import os

TESTPREAMBLE()

PlatformInfo.SetNumericalPrecision(6)

vertices = NumericalSample(0, 3)

vertices.add([0.0, 0.0, 0.0])
vertices.add([0.0, 0.0, 1.0])
vertices.add([0.0, 1.0, 0.0])
vertices.add([0.0, 1.0, 1.0])
vertices.add([1.0, 0.0, 0.0])
vertices.add([1.0, 0.0, 1.0])
vertices.add([1.0, 1.0, 0.0])
vertices.add([1.0, 1.0, 1.0])

simplicies = IndicesCollection(6, [0] * 4)
simplicies[0] = [0, 1, 2, 4]
simplicies[1] = [3, 5, 6, 7]
simplicies[2] = [1, 2, 3, 6]
simplicies[3] = [1, 2, 4, 6]
simplicies[4] = [1, 3, 5, 6]
simplicies[5] = [1, 4, 5, 6]

mesh3D = Mesh(vertices, simplicies)

s = 3
values = Normal(s).getSample(mesh3D.getVerticesNumber())
field = Field(mesh3D, values)
print('field=', field)
print('spatial dim=', field.getSpatialDimension())
print('value[4]=', field.getValueAtIndex(4))
print('nearest[2]=', field.getValueAtNearestPosition(field[2]))
print('mesh=', field.getMesh())
print('spatial mean=', field.getSpatialMean())
print('deformed=', field.asDeformedMesh())
print('description=', field.getDescription())

fname = 'field.vtk'
field.exportToVTKFile(fname)
with open(fname) as f:
    data = f.read()
    print(data)
os.remove(fname)
