/*###############################################################################
# Linux Management Providers (LMP), SSH provider package
# Copyright (C) 2010 Feng Zhanlei, REDFLAG <fengzhanlei@redflag-linux.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by Guillaume BOTTEX <guillaumebottex@uxsystem.net>, UXSystem, 2010
###############################################################################*/

#include "cmpiOpenDRIM_SSHServiceAccessBySAP.h"
#include "OpenDRIM_SSHServiceAccessBySAPAccess.h"

static const CMPIBroker * _broker;

#ifdef CMPI_VER_100
#define SSH_OpenDRIM_SSHServiceAccessBySAPProviderSetInstance SSH_OpenDRIM_SSHServiceAccessBySAPProviderModifyInstance
#endif

int SSH_OpenDRIM_SSHServiceAccessBySAP_init(const CMPIBroker* broker);

int SSH_OpenDRIM_SSHServiceAccessBySAP_finalize();

/* ---------------------------------------------------------------------------*/
/*                      Instance Provider Interface                           */
/* ---------------------------------------------------------------------------*/

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderCleanup(CMPIInstanceMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderEnumInstanceNames(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SSHServiceAccessBySAP> instances;
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_retrieve(_broker, ctx, instances, NULL, errorMessage, "ein");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIObjectPath* op = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIObjectPath(_broker, instances[i]);
		CMReturnObjectPath(rslt, op);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderEnumInstances(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	vector<OpenDRIM_SSHServiceAccessBySAP> instances;
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_retrieve(_broker, ctx, instances, properties, errorMessage, "ei");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	for (size_t i=0; i < instances.size(); i++) {
		CMPIInstance* ci = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIInstance(_broker, instances[i]);
		CMReturnInstance(rslt, ci);
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderGetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SSHServiceAccessBySAP instance;
	SSH_OpenDRIM_SSHServiceAccessBySAP_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_getInstance(_broker, ctx, instance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIInstance* ci = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIInstance(_broker, instance);
	CMReturnInstance(rslt, ci);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderSetInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SSHServiceAccessBySAP newInstance, oldInstance;
	SSH_OpenDRIM_SSHServiceAccessBySAP_toCPP(_broker, ci, newInstance);
	SSH_OpenDRIM_SSHServiceAccessBySAP_toCPP(_broker, cop, oldInstance);
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_getInstance(_broker, ctx, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_setInstance(_broker, ctx, newInstance, oldInstance, properties, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderCreateInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const CMPIInstance* ci) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SSHServiceAccessBySAP instance;
	SSH_OpenDRIM_SSHServiceAccessBySAP_toCPP(_broker, ci, instance);
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != NOT_FOUND) {
		if (errorCode == OK)
			errorCode = ALREADY_EXISTS;
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_createInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMPIObjectPath* _cop = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIObjectPath(_broker, instance);
	CMReturnObjectPath(rslt, _cop);
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderDeleteInstance(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	OpenDRIM_SSHServiceAccessBySAP instance;
	SSH_OpenDRIM_SSHServiceAccessBySAP_toCPP(_broker, cop, instance);
	string errorMessage;
	
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_getInstance(_broker, ctx, instance, NULL, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_deleteInstance(_broker, ctx, instance, errorMessage);
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderExecQuery(CMPIInstanceMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* ref, const char* lang, const char* query) {
	_E_;
	CMReturn(CMPI_RC_ERR_NOT_SUPPORTED);
}

/* ---------------------------------------------------------------------------*/
/*                   End of Instance Provider Interface                       */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                     Association Provider Interface                         */
/* ---------------------------------------------------------------------------*/

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderAssociationCleanup(CMPIAssociationMI * mi, const CMPIContext* ctx, CMPIBoolean terminate) {
	_E_;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_finalize();
	CMPIStatus rc;
	CMSetStatus(&rc, (CMPIrc) errorCode);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderAssociatorNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnObjectPath(rslt, associatedInstances[i].getObjectpath().getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderAssociators(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* resultClass, const char* role, const char* resultRole, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_associator(_broker, ctx, cop, known, assocClass, resultClass, role, resultRole, properties, associatedInstances, leftToRight, errorMessage, "a");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associatedInstances.size(); i++)
		CMReturnInstance(rslt, associatedInstances[i].getHdl());
	CMReturnDone(rslt);
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderReferenceNames(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_SSHServiceAccessBySAP> associationInstances;
	if (leftToRight)
		errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	else
		errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, NULL, errorMessage, "rn");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIObjectPath* op = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIObjectPath(_broker, associationInstances[i]);
		CMReturnObjectPath(rslt, op);
	}
	_L_;
	return rc;
}

CMPIStatus SSH_OpenDRIM_SSHServiceAccessBySAPProviderReferences(CMPIAssociationMI* mi, const CMPIContext* ctx, const CMPIResult* rslt, const CMPIObjectPath* cop, const char* assocClass, const char* role, const char** properties) {
	_E_;
	CMPIStatus rc = {CMPI_RC_OK, NULL};
	
	string errorMessage;
	bool leftToRight;
	vector<Instance> associatedInstances;
	Instance known;
	int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_associator(_broker, ctx, cop, known, assocClass, NULL, role, NULL, NULL, associatedInstances, leftToRight, errorMessage, "an");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	vector<OpenDRIM_SSHServiceAccessBySAP> associationInstances;
	if (leftToRight)
		errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_referenceAntecedentToDependent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	else
		errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_referenceDependentToAntecedent(_broker, ctx, known, associatedInstances, associationInstances, properties, errorMessage, "r");
	if (errorCode != OK) {
		errorMessage = (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
		CMSetStatusWithChars(_broker, &rc, (CMPIrc) errorCode, errorMessage.c_str());
		return rc;
	}
	
	for (size_t i=0; i < associationInstances.size(); i++) {
		CMPIInstance* inst = SSH_OpenDRIM_SSHServiceAccessBySAP_toCMPIInstance(_broker, associationInstances[i]);
		CMReturnInstance(rslt, inst);
	}
	_L_;
	return rc;
}

/* ---------------------------------------------------------------------------*/
/*                  End Of Association Provider Interface                     */
/* ---------------------------------------------------------------------------*/

/* ---------------------------------------------------------------------------*/
/*                              Provider Factory                              */
/* ---------------------------------------------------------------------------*/

int SSH_OpenDRIM_SSHServiceAccessBySAP_init(const CMPIBroker* broker) {
	_E_;
	_broker = broker;
	static bool initialized = false;
	if (!initialized) {
		string errorMessage;
		int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_load(broker, errorMessage);
		if (errorCode != OK) {
			errorMessage += "SSH_OpenDRIM_SSHServiceAccessBySAP_init FAILED: " + (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return -1;
		}
		initialized = true;
	}
	_L_;
	return OK;
}

int SSH_OpenDRIM_SSHServiceAccessBySAP_finalize() {
	_E_;
	static bool finalized = false;
	if (!finalized) {
		string errorMessage;
		int errorCode = SSH_OpenDRIM_SSHServiceAccessBySAP_unload(errorMessage);
		if (errorCode != OK) {
			errorMessage += "SSH_OpenDRIM_SSHServiceAccessBySAP_unload FAILED: " + (string) OpenDRIM_SSHServiceAccessBySAP_classnames[0] + ": " + errorMessage;
			string cmd = "/bin/echo \"" + errorMessage + "\" >> cmpi_prov_debug.txt";
			system(cmd.c_str());
			return errorCode;
		}
		finalized = true;
	}
	_L_;
	return OK;
}

#define SSH_OpenDRIM_SSHServiceAccessBySAP_INIT if (SSH_OpenDRIM_SSHServiceAccessBySAP_init(_broker) < 0) return NULL

CMInstanceMIStub(SSH_OpenDRIM_SSHServiceAccessBySAPProvider, SSH_OpenDRIM_SSHServiceAccessBySAPProvider, _broker, SSH_OpenDRIM_SSHServiceAccessBySAP_INIT);
CMAssociationMIStub(SSH_OpenDRIM_SSHServiceAccessBySAPProvider, SSH_OpenDRIM_SSHServiceAccessBySAPProvider, _broker, SSH_OpenDRIM_SSHServiceAccessBySAP_INIT);

/* ---------------------------------------------------------------------------*/
/*                          End of Provider Factory                           */
/* ---------------------------------------------------------------------------*/
