/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef OPENDRIM_OWNINGCOLLECTIONBIOSACCESS_H_
#define OPENDRIM_OWNINGCOLLECTIONBIOSACCESS_H_

#include "BIOS_Common.h"

#include "OpenDRIM_OwningCollectionBIOS.h"
#include "assocOpenDRIM_OwningCollectionBIOS.h"

int BIOS_OpenDRIM_OwningCollectionBIOS_load(const CMPIBroker* broker, string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_unload(string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_OwningCollectionBIOS>& instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OwningCollectionBIOS_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_OwningCollectionBIOS& instance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningCollectionBIOS& newInstance, const OpenDRIM_OwningCollectionBIOS& oldInstance, const char** properties, string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningCollectionBIOS& instance, string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_OwningCollectionBIOS& instance, string& errorMessage);

int BIOS_OpenDRIM_OwningCollectionBIOS_associatorOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const char** properties, vector<Instance>& OwningElement_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OwningCollectionBIOS_associatorOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const char** properties, vector<Instance>& OwnedElement_associatedInstances, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OwningCollectionBIOS_referenceOwnedElementToOwningElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwnedElement_instance, const vector<Instance>& OwningElement_instances, vector<OpenDRIM_OwningCollectionBIOS>& OpenDRIM_OwningCollectionBIOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OwningCollectionBIOS_referenceOwningElementToOwnedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& OwningElement_instance, const vector<Instance>& OwnedElement_instances, vector<OpenDRIM_OwningCollectionBIOS>& OpenDRIM_OwningCollectionBIOS_instances, const char** properties, string& errorMessage, const string& discriminant);

int BIOS_OpenDRIM_OwningCollectionBIOS_populate(OpenDRIM_OwningCollectionBIOS& instance, string& errorMessage);

#endif /*OPENDRIM_OWNINGCOLLECTIONBIOSACCESS_H_*/
