#! /usr/bin/env python

# This file is part of the dvbobjects library.
# 
# Copyright 2013 Lorenzo Pallara l.pallara@avalpa.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

import string
from dvbobjects.MPEG.Section import Section
from dvbobjects.ATSC.Loops import *
from dvbobjects.utils.MJD import *

######################################################################
class extended_text_table_section(Section):

    table_id = 0xCC

    section_max_size = 4093

    def pack_section_body(self):
	self.table_id_extension = self.ETT_table_id_extension
	self.protocol_version = 0
	
	extended_text_message_bytes = self.extended_text_message.pack()
	
	fmt = "!BL%ds" % len(extended_text_message_bytes)
	return pack(fmt,
	    self.protocol_version,
	    self.ETM_id,
	    extended_text_message_bytes,
            )

