/**************************************************************************
 OmegaT - Computer Assisted Translation (CAT) tool 
          with fuzzy matching, translation memory, keyword search, 
          glossaries, and translation leveraging into updated projects.

 Copyright (C) 2000-2006 Keith Godfrey and Maxym Mykhalchuk
               2007-2012 Didier Briel
               2013 Didier Briel, Piotr Kulik
               2014 Didier Briel, Aaron Madlon-Kay, Piotr Kulik
               Home page: http://www.omegat.org/
               Support center: http://groups.yahoo.com/group/OmegaT/

 This file is part of OmegaT.

 OmegaT is free software: you can redistribute it and/or modify
 it under the terms of the GNU General Public License as published by
 the Free Software Foundation, either version 3 of the License, or
 (at your option) any later version.

 OmegaT is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 GNU General Public License for more details.

 You should have received a copy of the GNU General Public License
 along with this program.  If not, see <http://www.gnu.org/licenses/>.
 **************************************************************************/

package org.omegat.filters3.xml.xliff;

import java.awt.event.ActionEvent;
import java.util.Map;
import java.util.TreeMap;

import javax.swing.AbstractAction;

import org.omegat.filters3.xml.xliff.XLIFFOptions.ID_TYPE;
import org.omegat.util.OStrings;
import org.omegat.util.gui.DockingUI;
import org.omegat.util.gui.StaticUIUtils;

/**
 * Modal dialog to edit XLIFF filter options.
 * 
 * @author Maxym Mykhalchuk
 * @author Didier Briel
 * @author Piotr Kulik
 * @author Aaron Madlon-Kay
 */
@SuppressWarnings("serial")
public class EditXLIFFOptionsDialog extends javax.swing.JDialog {
    /** A return status code - returned if Cancel button has been pressed */
    public static final int RET_CANCEL = 0;
    /** A return status code - returned if OK button has been pressed */
    public static final int RET_OK = 1;

    /** Creates new form EditOpenDocOptionsDialog */
    public EditXLIFFOptionsDialog(java.awt.Dialog parent, Map<String, String> config) {
        super(parent, true);
        this.options = new XLIFFOptions(new TreeMap<String, String>(config));
        initComponents();

        compatibility26CB.setSelected(options.get26Compatibility());
        forceshortcut2fCB.setSelected(options.getForceShortcutToF());
        ignoreTypeForPhTagsCB.setSelected(options.getIgnoreTypeForPhTags());
        ignoreTypeForBptTagsCB.setSelected(options.getIgnoreTypeForBptTags());
        prevAndNextRB.setSelected(options.getAltTransIDType() == ID_TYPE.CONTEXT);
        transIDRB.setSelected(options.getAltTransIDType() == ID_TYPE.ELEMENT_ID);
        transResnameRB.setSelected(options.getAltTransIDType() == ID_TYPE.RESNAME_ATTR);
        
        StaticUIUtils.setEscapeAction(this, new AbstractAction() {
            @Override
            public void actionPerformed(ActionEvent e) {
                doClose(RET_CANCEL);
            }
        });
        DockingUI.displayCentered(this);
    }

    private final XLIFFOptions options;

    public XLIFFOptions getOptions() {
        return options;
    }

    private int returnStatus = RET_CANCEL;

    /** @return the return status of this dialog - one of RET_OK or RET_CANCEL */
    public int getReturnStatus() {
        return returnStatus;
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed"
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        buttonGroup1 = new javax.swing.ButtonGroup();
        buttonPanel = new javax.swing.JPanel();
        okButton = new javax.swing.JButton();
        cancelButton = new javax.swing.JButton();
        jPanel1 = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        compatibility26CB = new javax.swing.JCheckBox();
        jLabel3 = new javax.swing.JLabel();
        prevAndNextRB = new javax.swing.JRadioButton();
        transIDRB = new javax.swing.JRadioButton();
        transResnameRB = new javax.swing.JRadioButton();
        jPanel2 = new javax.swing.JPanel();
        filler1 = new javax.swing.Box.Filler(new java.awt.Dimension(30, 0), new java.awt.Dimension(30, 0), new java.awt.Dimension(30, 32767));
        jLabel4 = new javax.swing.JLabel();
        jLabel1 = new javax.swing.JLabel();
        forceshortcut2fCB = new javax.swing.JCheckBox();
        ignoreTypeForPhTagsCB = new javax.swing.JCheckBox();
        ignoreTypeForBptTagsCB = new javax.swing.JCheckBox();

        setTitle(OStrings.getString("XLIFF_OPTIONS_TITLE")); // NOI18N
        setCursor(new java.awt.Cursor(java.awt.Cursor.DEFAULT_CURSOR));
        setResizable(false);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        buttonPanel.setMinimumSize(new java.awt.Dimension(143, 33));
        buttonPanel.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        org.openide.awt.Mnemonics.setLocalizedText(okButton, OStrings.getString("BUTTON_OK")); // NOI18N
        okButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                okButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(okButton);

        org.openide.awt.Mnemonics.setLocalizedText(cancelButton, OStrings.getString("BUTTON_CANCEL")); // NOI18N
        cancelButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                cancelButtonActionPerformed(evt);
            }
        });
        buttonPanel.add(cancelButton);

        getContentPane().add(buttonPanel, java.awt.BorderLayout.SOUTH);

        jPanel1.setBorder(javax.swing.BorderFactory.createEmptyBorder(3, 3, 3, 3));
        jPanel1.setMinimumSize(new java.awt.Dimension(167, 121));
        jPanel1.setLayout(new java.awt.GridLayout(0, 1));

        org.openide.awt.Mnemonics.setLocalizedText(jLabel2, OStrings.getString("XLIFF_OPTIONS_LABEL")); // NOI18N
        jPanel1.add(jLabel2);

        org.openide.awt.Mnemonics.setLocalizedText(compatibility26CB, OStrings.getString("XLIFF_OPTIONS_26")); // NOI18N
        jPanel1.add(compatibility26CB);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel3, OStrings.getString("XLIFF_OPTIONS_ID")); // NOI18N
        jPanel1.add(jLabel3);

        buttonGroup1.add(prevAndNextRB);
        org.openide.awt.Mnemonics.setLocalizedText(prevAndNextRB, OStrings.getString("XLIFF_OPTIONS_ID_NEXT_PREV")); // NOI18N
        jPanel1.add(prevAndNextRB);

        buttonGroup1.add(transIDRB);
        org.openide.awt.Mnemonics.setLocalizedText(transIDRB, OStrings.getString("XLIFF_OPTIONS_ID_TRANS_UNIT")); // NOI18N
        jPanel1.add(transIDRB);

        buttonGroup1.add(transResnameRB);
        org.openide.awt.Mnemonics.setLocalizedText(transResnameRB, OStrings.getString("XLIFF_OPTIONS_RESNAME_TRANS_UNIT")); // NOI18N
        jPanel1.add(transResnameRB);

        jPanel2.setLayout(new java.awt.BorderLayout());
        jPanel2.add(filler1, java.awt.BorderLayout.WEST);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel4, OStrings.getString("XLIFF_OPTIONS_RESNAME_EXPLANATION")); // NOI18N
        jPanel2.add(jLabel4, java.awt.BorderLayout.CENTER);

        jPanel1.add(jPanel2);

        org.openide.awt.Mnemonics.setLocalizedText(jLabel1, OStrings.getString("XLIFF_OPTIONS_36_ONLY")); // NOI18N
        jPanel1.add(jLabel1);

        org.openide.awt.Mnemonics.setLocalizedText(forceshortcut2fCB, OStrings.getString("XLIFF_OPTIONS_FORCE2F")); // NOI18N
        jPanel1.add(forceshortcut2fCB);

        org.openide.awt.Mnemonics.setLocalizedText(ignoreTypeForPhTagsCB, OStrings.getString("XLIFF_OPTIONS_IGNORE4PH")); // NOI18N
        jPanel1.add(ignoreTypeForPhTagsCB);

        org.openide.awt.Mnemonics.setLocalizedText(ignoreTypeForBptTagsCB, OStrings.getString("XLIFF_OPTIONS_IGNORE4BPT")); // NOI18N
        jPanel1.add(ignoreTypeForBptTagsCB);

        getContentPane().add(jPanel1, java.awt.BorderLayout.CENTER);

        pack();
    }// </editor-fold>//GEN-END:initComponents


    private void okButtonActionPerformed(java.awt.event.ActionEvent evt)// GEN-FIRST:event_okButtonActionPerformed
    {
        options.set26Compatibility(compatibility26CB.isSelected());
        options.setForceShortcutToF(forceshortcut2fCB.isSelected());
        options.setIgnoreTypeForPhTags(ignoreTypeForPhTagsCB.isSelected());
        options.setIgnoreTypeForBptTags(ignoreTypeForBptTagsCB.isSelected());
        if (prevAndNextRB.isSelected()) {
            options.setAltTransIDType(ID_TYPE.CONTEXT);
        } else if (transIDRB.isSelected()) {
            options.setAltTransIDType(ID_TYPE.ELEMENT_ID);
        } else if (transResnameRB.isSelected()) {
        	options.setAltTransIDType(ID_TYPE.RESNAME_ATTR);
        }

        doClose(RET_OK);
    }// GEN-LAST:event_okButtonActionPerformed

    private void cancelButtonActionPerformed(java.awt.event.ActionEvent evt)// GEN-FIRST:event_cancelButtonActionPerformed
    {
        doClose(RET_CANCEL);
    }// GEN-LAST:event_cancelButtonActionPerformed

    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt)// GEN-FIRST:event_closeDialog
    {
        doClose(RET_CANCEL);
    }// GEN-LAST:event_closeDialog


    private void doClose(int retStatus) {
        returnStatus = retStatus;
        setVisible(false);
        dispose();
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.ButtonGroup buttonGroup1;
    private javax.swing.JPanel buttonPanel;
    private javax.swing.JButton cancelButton;
    private javax.swing.JCheckBox compatibility26CB;
    private javax.swing.Box.Filler filler1;
    private javax.swing.JCheckBox forceshortcut2fCB;
    private javax.swing.JCheckBox ignoreTypeForBptTagsCB;
    private javax.swing.JCheckBox ignoreTypeForPhTagsCB;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JButton okButton;
    private javax.swing.JRadioButton prevAndNextRB;
    private javax.swing.JRadioButton transIDRB;
    private javax.swing.JRadioButton transResnameRB;
    // End of variables declaration//GEN-END:variables
}
