PROGRAM gen_fields_vector
!
!
!This program creates Oasis restart files
!for the treatments of vectors for the grids
!at42, bt42, torc and test!
!
!
  IMPLICIT NONE
!
  INCLUDE 'netcdf.inc'
!
!*--------------------Declarations----------------------------
!  
!
  REAL(KIND=8), PARAMETER :: pi=3.14159265359
  REAL(kind=8), PARAMETER :: pi2=2.0*pi
  REAL(KIND=8), PARAMETER :: deg2rad = pi/180
  REAL(KIND=8), PARAMETER :: two=2.
  REAL(KIND=8), PARAMETER :: length = 0.6*pi2
!
!* For the grids:
!
!AT42
  INTEGER, PARAMETER :: jpia=128, jpja=64
  REAL(kind=8), DIMENSION(jpia,jpja) :: rla_lona, rla_lata
  REAL(kind=8), DIMENSION(jpia,jpja) :: rda_lona, rda_lata

!BT42
  INTEGER, PARAMETER :: jpib=6232, jpjb=1
  REAL(kind=8), DIMENSION(jpib,jpjb) :: rla_lonb, rla_latb
  REAL(kind=8), DIMENSION(jpib,jpjb) :: rda_lonb, rda_latb

!TORC
  INTEGER, PARAMETER   :: jpit=182, jpjt=149
  REAL(kind=8), DIMENSION(jpit,jpjt) :: rla_lont, rla_latt
  REAL(kind=8), DIMENSION(jpit,jpjt) :: rda_lont, rda_latt

!TEST1
  INTEGER, PARAMETER   :: jpin=8, jpjn=11
  REAL(kind=8), DIMENSION(jpin,jpjn) :: rla_lonn, rla_latn
  REAL(kind=8), DIMENSION(jpin,jpjn) :: rda_lonn, rda_latn

!TEST2
!  INTEGER, PARAMETER   :: jpin=90, jpjn=87
!  REAL(kind=8), DIMENSION(jpin,jpjn) :: rla_lonn, rla_latn
!  REAL(kind=8), DIMENSION(jpin,jpjn) :: rda_lonn, rda_latn

!TEST RED
!  INTEGER, PARAMETER   :: jpin=6573, jpjn=1
!  REAL(kind=8), DIMENSION(jpin,jpjn) :: rla_lonn, rla_latn
!  REAL(kind=8), DIMENSION(jpin,jpjn) :: rda_lonn, rda_latn

  INTEGER :: il_varid, nc_grids

!
!* For the functions
!
  REAL(kind=8), DIMENSION(:,:), ALLOCATABLE :: &
       field, field_tmp  
!
!* For the auxiliary files
!
  CHARACTER(len=8) :: filename, varname, &
       namlon, namlat
  CHARACTER(len=4) :: namdim(3,2), namgrid(3)
  CHARACTER(len=1) :: comp(2), &
       namgridred(3), namfonc(4)
  INTEGER :: valdim(3,2)
  INTEGER :: i, j, k ,ii         !loop
  INTEGER :: nc_fileid, dim1_id, dim2_id, & 
       ivardim(2), varid, lonid, latid    !netcdf id
         
!*--------------------------------------------------------
!
!** 1. Get grids informations (at42, bt42, torc)
!      -----------------------------------------
  call hdlerr(NF_OPEN &
       ("grids.nc", NF_NOWRITE, nc_grids))

!-- AT42
  call hdlerr(NF_INQ_VARID &
       (nc_grids, 'at42.lon',il_varid))
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_lona))  

  call hdlerr(NF_INQ_VARID &
          (nc_grids, 'at42.lat',il_varid))  
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_lata))

!-- BT42 
  call hdlerr(NF_INQ_VARID &
       (nc_grids, 'bt42.lon',il_varid))
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_lonb))  

  call hdlerr(NF_INQ_VARID &
          (nc_grids, 'bt42.lat',il_varid))  
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_latb))

!-- TORC
  call hdlerr(NF_INQ_VARID &
       (nc_grids, 'torc.lon',il_varid))
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_lont))  

  call hdlerr(NF_INQ_VARID &
          (nc_grids, 'torc.lat',il_varid))  
  call hdlerr(NF_GET_VAR_DOUBLE &
       (nc_grids, il_varid, rla_latt))

!-- TEST
!!$  call hdlerr(NF_INQ_VARID &
!!$       (nc_grids, 'test.lon',il_varid))
!!$  call hdlerr(NF_GET_VAR_DOUBLE &
!!$       (nc_grids, il_varid, rla_lonn))  
!!$
!!$  call hdlerr(NF_INQ_VARID &
!!$          (nc_grids, 'test.lat',il_varid))  
!!$  call hdlerr(NF_GET_VAR_DOUBLE &
!!$       (nc_grids, il_varid, rla_latn))
!!$
  call hdlerr(NF_CLOSE(nc_grids)) 

!-- Convert into radians
  rda_lata(:,:) = rla_lata(:,:) * deg2rad
  rda_lona(:,:) = rla_lona(:,:) * deg2rad

  rda_latb(:,:) = rla_latb(:,:) * deg2rad
  rda_lonb(:,:) = rla_lonb(:,:) * deg2rad

  rda_latt(:,:) = rla_latt(:,:) * deg2rad
  rda_lont(:,:) = rla_lont(:,:) * deg2rad
  
  rda_latn(:,:) = rla_latn(:,:) * deg2rad
  rda_lonn(:,:) = rla_lonn(:,:) * deg2rad
!
!**  2. Creation of the restart files
!       -----------------------------

! Generic creation
! namfonc(k) = name of the functions
! namgrid(j) = name of the grids
! namdim(j,2) = name of the dimensions
! valdim(j,2) = valew of the dimensions
! comp(i=2) = I ou J

  namfonc(1)= 'a' ; namfonc(2)=  'c' ; namfonc(3)= 's'
  namfonc(4)='p' 
!  namfonc(1)= 'j'

  namgrid(1)='at42' ; namgrid(2)='bt42' ; namgrid(3)='torc'
!  namgrid(1)='at42' ; namgrid(2)='bt42' ; namgrid(3)='test'
  namgridred(1)='a' ; namgridred(2)='b' ; namgridred(3)='t'

  namdim(1,1)= 'jpia' ; namdim(1,2)= 'jpja'
  namdim(2,1)= 'jpib' ; namdim(2,2)= 'jpjb' 
  namdim(3,1)= 'jpit' ; namdim(3,2)= 'jpjt'
!  namdim(3,1)= 'jpin' ; namdim(3,2)= 'jpjn'

  valdim(1,1)= jpia ; valdim(1,2)= jpja
  valdim(2,1)= jpib ; valdim(2,2)= jpjb 
  valdim(3,1)= jpit ; valdim(3,2)= jpjt
!  valdim(3,1)= jpin ; valdim(3,2)= jpjn

  comp(1) = 'I' ; comp(2) = 'J'
    
  DO i=1,2   !loop on the 2 composants I and J

     DO j=3,3   !loop on the 3 grids 

        DO k=4,4  !loop on the 3 functions 
!
!* create the files and the variables
!
           filename = namfonc(k)//namgridred(j)// &
                comp(i)//'in.nc'
           print*, filename

           CALL hdlerr(NF_CREATE & 
                (filename, 0, nc_fileid))
           
           CALL hdlerr(NF_DEF_DIM &
                (nc_fileid, namdim(j,1), valdim(j,1), dim1_id))
           
           CALL hdlerr(NF_DEF_DIM &
                (nc_fileid, namdim(j,2), valdim(j,2), dim2_id)) 
           
           ivardim(1)= dim1_id
           ivardim(2)= dim2_id

           varname = namfonc(k)//'_'//namgrid(j)// &
                '_'//comp(i)
           print*, varname

           CALL hdlerr(NF_DEF_VAR &
                (nc_fileid, varname, NF_DOUBLE, 2, ivardim, &
                varid))
           
           namlon = namgrid(j)//'.lon' ; namlat = namgrid(j)//'.lat'

           CALL hdlerr(NF_DEF_VAR &
                (nc_fileid, namlon, NF_DOUBLE, 2, ivardim, &
                lonid))
           
           CALL hdlerr(NF_DEF_VAR &
                (nc_fileid, namlat, NF_DOUBLE, 2, ivardim, &
                latid))  
           
           CALL hdlerr(NF_ENDDEF(nc_fileid))           
!
!* Compute and write valews
!
           IF(namgrid(j)=='at42') THEN
!* Write longitudes and latitudes
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, lonid, rla_lona)) 
          
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, latid, rla_lata))

!* Compute and write the field 
              ALLOCATE(field(jpia,jpja))
              SELECT CASE(namfonc(k))                 
                 CASE('a')
                    ALLOCATE(field_tmp(jpia,jpja))
                    field = COS(rda_lata)*COS(rda_lona)
                    field_tmp = ACOS(-field)/length
                    field = 1.5 + field_tmp
                    DEALLOCATE(field_tmp)
                    
                    print*, field(31,63)
                 CASE('c')
                    field = two + COS(rda_lata)**2 * &
                         COS(two*rda_lona)

                 CASE('s')
                    field = two + SIN(two*rda_lata)**16 * &
                         COS(16.*rda_lona)
                    
                 CASE('j')
                    field = SIN(0.01*rda_lata) * COS(0.45*rda_lona)

                 END SELECT

              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, varid, field))

              DEALLOCATE(field)
              
           ELSEIF(namgrid(j)=='bt42') THEN
!* Write longitudes and latitudes              
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, lonid, rla_lonb)) 
          
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, latid, rla_latb))

!* Compute and write the field
              ALLOCATE(field(jpib,jpjb))
              SELECT CASE(namfonc(k))
                 CASE('a')
                    ALLOCATE(field_tmp(jpib,jpjb))
                    field = COS(rda_latb)*COS(rda_lonb)
                    field_tmp = ACOS(-field)/length
                    field = 1.5 + field_tmp
                    DEALLOCATE(field_tmp)
 
                 CASE('c')
                    field = two + COS(rda_latb)**2 * &
                         COS(two*rda_lonb)

                 CASE('s')
                    field = two + SIN(two*rda_latb)**16 * &
                         COS(16.*rda_lonb) 
 
                 END SELECT

              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, varid, field))

              DEALLOCATE(field)  
            
           ELSEIF(namgrid(j)=='test') THEN
!* Write longitudes and latitudes              
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, lonid, rla_lonn)) 
          
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, latid, rla_latn))

!* Compute and write the field
              ALLOCATE(field(jpin,jpjn))
              SELECT CASE(namfonc(k))
                 CASE('a')
                    ALLOCATE(field_tmp(jpin,jpjn))
                    field = COS(rda_latn)*COS(rda_lonn)
                    field_tmp = ACOS(-field)/length
                    field = 1.5 + field_tmp
                    DEALLOCATE(field_tmp)
 
                 CASE('c')
                    field = two + COS(rda_latn)**2 * &
                         COS(two*rda_lonn)

                 CASE('s')
                    field = two + SIN(two*rda_latn)**16 * &
                         COS(16.*rda_lonn) 
                 CASE('u')
                    field = 1.

                 CASE('z')
                    field = 0.
                 END SELECT

              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, varid, field))

              DEALLOCATE(field)              

           ELSE  !torc
!* Write longitudes and latitudes
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, lonid, rla_lont)) 
          
              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, latid, rla_latt))

!* Compute and write the field
              ALLOCATE(field(jpit,jpjt))
              SELECT CASE(namfonc(k))
              CASE('a')
                 ALLOCATE(field_tmp(jpit,jpjt))
                 field = COS(rda_latt)*COS(rda_lont)
                 field_tmp = ACOS(-field)/length
                 field = 1.5 + field_tmp
                 DEALLOCATE(field_tmp) 

              CASE('c')
                 field = two + COS(rda_latt)**2 * &
                      COS(two*rda_lont)

              CASE('s')
                 field = two + SIN(two*rda_latt)**16 * &
                      COS(16.*rda_lont)  

              CASE('p')  !champ variant bcp au pole nord
!                 field = 1 + COS(rda_lont) * SIN(rda_lont)
                 field = COS(rda_latt) * SIN(rda_latt)
                 
                 END SELECT

              CALL hdlerr(NF_PUT_VAR_DOUBLE &
                   (nc_fileid, varid, field))

              DEALLOCATE(field)                

           END IF

           CALL hdlerr(NF_CLOSE(nc_fileid))

        END DO
     END DO
  END DO

END PROGRAM gen_fields_vector


SUBROUTINE hdlerr(istatus)
  IMPLICIT NONE 
  include 'netcdf.inc'
  INTEGER :: istatus
  
  if (istatus .ne. NF_NOERR) then
     print *, NF_STRERROR(istatus)
     stop 'stopped'
  endif
END SUBROUTINE hdlerr



  
