/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.actions;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.jetspeed.portal.Portlet;
import org.apache.jetspeed.portal.PortletConfig;
import org.apache.jetspeed.portal.portlets.VelocityPortlet;
import org.apache.jetspeed.services.persistence.PersistenceManager;
import org.apache.jetspeed.services.rundata.JetspeedRunData;
import org.apache.jetspeed.services.statemanager.SessionState;
import org.apache.turbine.util.Log;
import org.apache.turbine.util.RunData;
import org.apache.velocity.context.Context;
import org.chefproject.actions.VelocityTeamlet;
import org.chefproject.core.Site;
import org.chefproject.core.SiteEdit;
import org.chefproject.core.ToolConfiguration;
import org.chefproject.core.ToolConfigurationEdit;
import org.chefproject.exception.IdUnusedException;
import org.chefproject.exception.InUseException;
import org.chefproject.exception.PermissionException;
import org.chefproject.service.CourierService;
import org.chefproject.service.PortalService;
import org.chefproject.service.SiteService;
import org.chefproject.service.UsageSessionService;
import org.chefproject.util.FloatAbsenceObservingCourier;
import org.chefproject.util.Menu;
import org.chefproject.util.MenuEntry;
import org.chefproject.util.ObservingCourier;
import org.chefproject.util.Validator;

public abstract class VelocityPortletPaneledAction
extends VelocityTeamlet {
    protected static final String LAYOUT_PANEL = "Layout";
    protected static final String LAYOUT_MAIN = "Main";
    protected static final String LAYOUT_TITLE = "Title";
    protected static final String REQ_PANEL = "panel";
    public static final String STATE_MODE = "mode";
    public static final String STATE_OBSERVER = "obsever";
    public static final String STATE_OBSERVER2 = "obsever2";
    public static final String STATE_PRESENCE_OBSERVER = "presence_observer";
    public static final String STATE_FLOAT = "float";
    public static final String STATE_ACTION = "action";
    public static final String STATE_SITE_EDIT = "site";
    public static final String STATE_TOOL_EDIT = "tool";
    public static final String STATE_MESSAGE = "message";
    public static final String MODE_OPTIONS = "options";
    public static final String PARAM_ACTION = "action";
    static /* synthetic */ Class class$org$apache$jetspeed$portal$portlets$VelocityPortlet;
    static /* synthetic */ Class class$org$apache$velocity$context$Context;
    static /* synthetic */ Class class$org$apache$turbine$util$RunData;
    static /* synthetic */ Class class$org$apache$jetspeed$services$statemanager$SessionState;

    protected void buildNormalContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        this.initState(state, portlet, (JetspeedRunData)rundata);
        context.put(REQ_PANEL, REQ_PANEL);
        context.put("action", state.getAttribute("action"));
        try {
            String panel = rundata.getParameters().getString(REQ_PANEL);
            if (LAYOUT_MAIN.equals(panel) && this.handleFloat(portlet, context, rundata, state)) {
                return;
            }
            if (panel == null) {
                panel = LAYOUT_PANEL;
            }
            context.put("panel-name", panel);
            Class[] types = new Class[]{class$org$apache$jetspeed$portal$portlets$VelocityPortlet == null ? (class$org$apache$jetspeed$portal$portlets$VelocityPortlet = VelocityPortletPaneledAction.class$("org.apache.jetspeed.portal.portlets.VelocityPortlet")) : class$org$apache$jetspeed$portal$portlets$VelocityPortlet, class$org$apache$velocity$context$Context == null ? (class$org$apache$velocity$context$Context = VelocityPortletPaneledAction.class$("org.apache.velocity.context.Context")) : class$org$apache$velocity$context$Context, class$org$apache$turbine$util$RunData == null ? (class$org$apache$turbine$util$RunData = VelocityPortletPaneledAction.class$("org.apache.turbine.util.RunData")) : class$org$apache$turbine$util$RunData, class$org$apache$jetspeed$services$statemanager$SessionState == null ? (class$org$apache$jetspeed$services$statemanager$SessionState = VelocityPortletPaneledAction.class$("org.apache.jetspeed.services.statemanager.SessionState")) : class$org$apache$jetspeed$services$statemanager$SessionState};
            String methodName = "build" + panel + "PanelContext";
            Method method = ((Object)((Object)this)).getClass().getMethod(methodName, types);
            Object[] args = new Object[]{portlet, context, rundata, state};
            String template = (String)method.invoke((Object)this, args);
            if (template == null) {
                template = (String)this.getContext(rundata).get("template") + "-" + panel;
            }
            this.setTemplate(rundata, template);
        }
        catch (NoSuchMethodException e) {
            Log.warn("chef", (Object)((Object)this) + " : ", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.warn("chef", (Object)((Object)this) + " : ", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.warn("chef", (Object)((Object)this) + " : ", (Throwable)e);
        }
        String message = (String)state.getAttribute(STATE_MESSAGE);
        if (message != null) {
            context.put("alertMessage", message);
        }
        state.removeAttribute(STATE_MESSAGE);
    }

    public String buildLayoutPanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        return "chef_Layout";
    }

    public String buildTitlePanelContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        String floatingWindow = rundata.getParameters().getString(STATE_FLOAT);
        String floatingTool = (String)state.getAttribute(STATE_FLOAT);
        if (this.requireResetToolLink() && (floatingTool == null || floatingWindow != null)) {
            context.put("includeReset", "true");
        }
        context.put("action", state.getAttribute("action"));
        String siteId = PortalService.getCurrentSiteId();
        try {
            Site site = SiteService.getSite(siteId);
            ToolConfiguration tool = site.getTool(portlet.getID());
            context.put("title", tool.getTitle());
        }
        catch (Exception any) {
            context.put("title", PersistenceManager.getInstance((Portlet)portlet, (RunData)rundata).getTitle());
        }
        return "chef_Title";
    }

    protected void initState(SessionState state, VelocityPortlet portlet, JetspeedRunData rundata) {
        if (state.getAttribute("action") == null) {
            PortletConfig config = portlet.getPortletConfig();
            state.setAttribute("action", (Object)config.getInitParameter("action"));
        }
    }

    protected boolean handleFloat(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        FloatAbsenceObservingCourier courier;
        boolean rv = false;
        String floating = rundata.getParameters().getString(STATE_FLOAT);
        if (floating == null) {
            if (STATE_FLOAT.equals(state.getAttribute(STATE_FLOAT))) {
                this.buildFloatContext(portlet, context, rundata, state);
                String deliveryId = PortalService.getCurrentClientWindowId(null);
                String mainId = VelocityPortletPaneledAction.mainPanelUpdateId(portlet.getID());
                String titleId = VelocityPortletPaneledAction.titlePanelUpdateId(portlet.getID());
                String pattern = PortalService.getCurrentLocationId(portlet.getID());
                state.setAttribute(STATE_PRESENCE_OBSERVER, (Object)new FloatAbsenceObservingCourier(deliveryId, mainId, titleId, pattern, portlet.getID(), UsageSessionService.getSession().getId()));
                rv = true;
            } else if ("floating".equals(state.getAttribute(STATE_FLOAT))) {
                this.buildFloatingContext(portlet, context, rundata, state);
                rv = true;
            }
        } else if (state.getAttribute(STATE_FLOAT) == null) {
            this.buildCloseContext(portlet, context, rundata, state);
            rv = true;
        }
        if (state.getAttribute(STATE_FLOAT) == null && (courier = (FloatAbsenceObservingCourier)state.getAttribute(STATE_PRESENCE_OBSERVER)) != null) {
            courier.disable();
            state.removeAttribute(STATE_PRESENCE_OBSERVER);
        }
        return rv;
    }

    protected void buildFloatContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        state.setAttribute(STATE_FLOAT, (Object)"floating");
        this.setTemplate(rundata, "chef_float");
    }

    protected void buildFloatingContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        this.setTemplate(rundata, "chef_floating");
    }

    protected void buildCloseContext(VelocityPortlet portlet, Context context, RunData rundata, SessionState state) {
        this.setTemplate(rundata, "chef_close");
    }

    protected String clientWindowId(SessionState state, String toolId) {
        String deliveryId = PortalService.getCurrentClientWindowId(state.getAttribute(STATE_FLOAT) == null ? null : toolId);
        return deliveryId;
    }

    public static String mainPanelUpdateId(String toolId) {
        String id = Validator.escapeJavascript(LAYOUT_MAIN + toolId);
        return id;
    }

    public static String titlePanelUpdateId(String toolId) {
        String id = Validator.escapeJavascript(LAYOUT_TITLE + toolId);
        return id;
    }

    public void doOptions(RunData runData, Context context) {
        String toolId = PortalService.getCurrentToolId();
        String siteId = PortalService.getCurrentSiteId();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(toolId);
        String msg = null;
        try {
            SiteEdit site = SiteService.editSite(siteId);
            ToolConfigurationEdit tool = site.getToolEdit(toolId);
            state.setAttribute(STATE_SITE_EDIT, (Object)site);
            state.setAttribute(STATE_TOOL_EDIT, (Object)tool);
            state.setAttribute(STATE_MODE, (Object)MODE_OPTIONS);
            VelocityPortletPaneledAction.disableObservers(state);
            String currentPanelId = runData.getParameters().getString(REQ_PANEL);
            if (!LAYOUT_MAIN.equals(currentPanelId)) {
                String address = this.clientWindowId(state, toolId);
                String mainPanelId = VelocityPortletPaneledAction.mainPanelUpdateId(toolId);
                CourierService.deliver(address, mainPanelId);
            }
            return;
        }
        catch (IdUnusedException ignore) {
            msg = "due to an internal error.";
        }
        catch (PermissionException e) {
            msg = "you do not have permission to set options for this Worksite.";
        }
        catch (InUseException e) {
            msg = "someone else is configuring this Worksite.";
        }
        state.setAttribute(STATE_MESSAGE, (Object)("Options are unavailable right now: " + msg));
    }

    protected void saveOptions() {
        SessionState state = PortalService.getCurrentToolState();
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_EDIT);
        if (site != null) {
            SiteService.commitEdit(site);
        }
        state.removeAttribute(STATE_SITE_EDIT);
        state.removeAttribute(STATE_TOOL_EDIT);
    }

    protected void cancelOptions() {
        SessionState state = PortalService.getCurrentToolState();
        SiteEdit site = (SiteEdit)state.getAttribute(STATE_SITE_EDIT);
        if (site != null) {
            SiteService.cancelEdit(site);
        }
        state.removeAttribute(STATE_SITE_EDIT);
        state.removeAttribute(STATE_TOOL_EDIT);
    }

    protected void addOptionsMenu(Menu bar, JetspeedRunData data) {
        if (SiteService.allowUpdateSite(PortalService.getCurrentSiteId())) {
            bar.add(new MenuEntry("Options...", "doOptions"));
        }
    }

    public void doReset(RunData runData, Context context) {
        String peid = ((JetspeedRunData)runData).getJs_peid();
        SessionState state = ((JetspeedRunData)runData).getPortletSessionState(peid);
        boolean floating = state.getAttribute(STATE_FLOAT) != null;
        this.resetTool(state);
        String windowToolId = null;
        if (floating) {
            state.setAttribute(STATE_FLOAT, (Object)STATE_FLOAT);
            windowToolId = peid;
        }
        String main = VelocityPortletPaneledAction.mainPanelUpdateId(peid);
        CourierService.deliver(PortalService.getCurrentClientWindowId(windowToolId), main);
    }

    protected void resetTool(SessionState state) {
        state.clear();
    }

    protected boolean requireResetToolLink() {
        return true;
    }

    protected void addAlert(SessionState state, String message) {
        String soFar = (String)state.getAttribute(STATE_MESSAGE);
        soFar = soFar != null ? soFar + " " + message : message;
        state.setAttribute(STATE_MESSAGE, (Object)soFar);
    }

    public static void disableObservers(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer != null) {
            observer.disable();
        }
        if ((observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER2)) != null) {
            observer.disable();
        }
    }

    public static void enableObservers(SessionState state) {
        ObservingCourier observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER);
        if (observer != null) {
            observer.enable();
        }
        if ((observer = (ObservingCourier)state.getAttribute(STATE_OBSERVER2)) != null) {
            observer.enable();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        LAYOUT_PANEL = LAYOUT_PANEL;
        LAYOUT_MAIN = LAYOUT_MAIN;
        LAYOUT_TITLE = LAYOUT_TITLE;
        REQ_PANEL = REQ_PANEL;
        STATE_MODE = STATE_MODE;
        STATE_OBSERVER = STATE_OBSERVER;
        STATE_OBSERVER2 = STATE_OBSERVER2;
        STATE_PRESENCE_OBSERVER = STATE_PRESENCE_OBSERVER;
        STATE_FLOAT = STATE_FLOAT;
        STATE_ACTION = "action";
        STATE_SITE_EDIT = STATE_SITE_EDIT;
        STATE_TOOL_EDIT = STATE_TOOL_EDIT;
        STATE_MESSAGE = STATE_MESSAGE;
        MODE_OPTIONS = MODE_OPTIONS;
        PARAM_ACTION = "action";
    }
}

