/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.notification.ris;

import com.sourceforge.knecs.dsm.resourceobject.Group;
import com.sourceforge.knecs.dsm.resourceobject.IGroupService;
import com.sourceforge.knecs.dsm.resourceobject.RISException;
import com.sourceforge.knecs.dsm.resourceobject.ResourceObject;
import com.sourceforge.knecs.notification.ris.JMSRISService;
import com.sourceforge.knecs.util.CMCSProperties;
import com.sourceforge.knecs.util.LoggerUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class JMSRISGroupService
extends JMSRISService
implements IGroupService {
    private static String CLASSNAME = "com.sourceforge.knecs.dsm.resourceobject.Group";
    private static Vector mClassNames = new Vector();
    String mUser = null;
    String mAuth = null;

    public JMSRISGroupService(String serviceURL) {
        super(serviceURL, mClassNames);
    }

    public void connect(String user, String passwd) {
        this.mLogger.info("calling JMSRISGroupService.connect");
        this.mUser = user;
        this.mAuth = passwd;
        super.connect(user, passwd);
        boolean loadSites = false;
        if (this.mUseCache) {
            if (this.mCacheById.size() == 0) {
                loadSites = true;
            } else if (!this.mCacheById.containsKey("group-worksite.txt")) {
                loadSites = true;
            }
        } else {
            Collection resources = this.getAllResourceObjects(CLASSNAME);
            if (resources.size() == 0) {
                loadSites = true;
            } else {
                Iterator it = resources.iterator();
                boolean found = false;
                while (it.hasNext()) {
                    Group curGroup = (Group)it.next();
                    if (!curGroup.getId().equals("group-worksite.txt")) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    loadSites = true;
                }
            }
        }
        if (loadSites) {
            this.mLogger.info("Trying to load default groups");
            try {
                InputStream is = this.getClass().getResourceAsStream("/site.xml");
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document newsdoc = db.parse(is);
                NodeList nodes = newsdoc.getElementsByTagName("site");
                this.mLogger.info("Saving new base sites: " + nodes.getLength());
                Object groupsite = null;
                for (int idx = 0; idx < nodes.getLength(); ++idx) {
                    Element el = (Element)nodes.item(idx);
                    Element gws = (Element)el.cloneNode(true);
                    this.mLogger.info("Site id is " + el.getAttribute("id"));
                    Group g = new Group();
                    g.setContent(JMSRISGroupService.getContentFromElement(gws));
                    g.setOwnerId(el.getAttribute("id"));
                    g.setDescription(el.getAttribute("description"));
                    g.setDisplayName(el.getAttribute("title"));
                    g.setOpen(new Boolean(el.getAttribute("joinable")));
                    this.save(g);
                }
            }
            catch (Exception e) {
                this.mLogger.severe("Could not load default sites!\n" + e.toString() + "\n" + LoggerUtils.getStackTrace(e));
            }
        }
        this.mLogger.info("end connect");
    }

    public String save(ResourceObject obj) throws RISException {
        if (obj.getId() == null || obj.getId().equals("")) {
            String owner = new String(obj.getOwnerId());
            owner = owner.replace('/', '-');
            owner = owner.replaceAll("\\!", "");
            owner = owner.replaceAll("~", "user-");
            owner = "group-" + owner + ".txt";
            this.mLogger.info("trying to save group with id: " + owner);
            obj.setId(owner);
        }
        return super.save(obj);
    }

    public synchronized Vector getURLFilters() {
        CMCSProperties props = CMCSProperties.getCMCSProperties();
        String svr = props.getProperty("samserver");
        String path = props.getProperty("portalobjects");
        String users = props.getProperty("groups");
        Vector<String> ret = new Vector<String>();
        ret.add("%" + path + "/" + users + "%");
        return ret;
    }

    public void logAllGroups() {
        try {
            Group[] tmp = this.getGroups();
            if (tmp != null) {
                for (int idx = 0; idx < tmp.length; ++idx) {
                    this.mLogger.info("Group-> " + tmp[idx]);
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public Group[] getGroups() throws IOException {
        Collection objects = this.getAllResourceObjects(CLASSNAME);
        Iterator it = objects.iterator();
        Group[] ret = new Group[objects.size()];
        int idx = 0;
        while (it.hasNext()) {
            ret[idx++] = (Group)it.next();
        }
        return ret;
    }

    public Group getGroup(String owner) throws IOException {
        Group ret = null;
        Collection objects = this.getResourceObjectsByOwner(owner, CLASSNAME);
        if (objects != null && objects.size() > 0) {
            Iterator it = objects.iterator();
            ret = (Group)it.next();
        }
        return ret;
    }

    public void addGroup(Group data) throws IOException {
        try {
            this.save(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to save group " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
    }

    public boolean deleteGroup(Group data) throws IOException {
        try {
            this.remove(data);
        }
        catch (RISException risex) {
            this.mLogger.severe("Unable to remove Group " + risex.getMessage());
            throw new IOException(risex.getMessage());
        }
        return true;
    }

    static {
        mClassNames.add(CLASSNAME);
    }
}

