/*
 * Decompiled with CFR 0.152.
 */
package org.chefproject.util;

import java.util.Observable;
import org.apache.turbine.util.Log;
import org.chefproject.core.Event;
import org.chefproject.core.component.FloatAbsenceDelivery;
import org.chefproject.core.component.RefreshDelivery;
import org.chefproject.service.CourierService;
import org.chefproject.util.PresenceObservingCourier;

public class FloatAbsenceObservingCourier
extends PresenceObservingCourier {
    protected String m_toolId = null;
    protected String m_sessionId = null;
    protected String m_titleId = null;

    public FloatAbsenceObservingCourier(String portalPageInstanceId, String mainId, String titleId, String location, String toolId, String sessionId) {
        super(portalPageInstanceId, mainId, location);
        this.m_toolId = toolId;
        this.m_sessionId = sessionId;
        this.m_titleId = titleId;
    }

    protected boolean check(Object arg) {
        if (!(arg instanceof Event)) {
            return false;
        }
        Event event = (Event)arg;
        String function = event.getEvent();
        if (!function.equals("pres.end")) {
            return false;
        }
        if (!this.m_sessionId.equals(event.getSessionId())) {
            return false;
        }
        return super.check(arg);
    }

    public void update(Observable o, Object arg) {
        if (!this.getEnabled()) {
            if (Log.getLogger("chef").isDebugEnabled()) {
                Log.debug("chef", this + ".update [DISABLED]: " + (arg == null ? "null" : arg.toString()));
            }
            return;
        }
        if (!this.check(arg)) {
            return;
        }
        CourierService.deliver(new FloatAbsenceDelivery(this.getDeliveryId(), this.getElementId(), this.m_toolId));
        CourierService.deliver(new RefreshDelivery(this.getDeliveryId(), this.m_titleId));
    }
}

