/*
 * Decompiled with CFR 0.152.
 */
package com.sourceforge.knecs.dsm.basicsearch;

import com.sourceforge.knecs.dsm.basicsearch.BasicSearchQuery;
import com.sourceforge.knecs.dsm.basicsearch.QueryScope;
import com.sourceforge.knecs.util.UrlUtils;
import java.util.Enumeration;
import java.util.Vector;
import org.jdom.Element;

public class FromClause {
    private Vector mQueryScopes = new Vector();

    public boolean empty() {
        return this.mQueryScopes.isEmpty();
    }

    public Element getElement() {
        Element ret = new Element("from", BasicSearchQuery.DAV_NS);
        Enumeration e = this.mQueryScopes.elements();
        while (e.hasMoreElements()) {
            QueryScope qs = (QueryScope)e.nextElement();
            Element qsElement = new Element("scope", BasicSearchQuery.DAV_NS);
            Element hrefElement = new Element("href", BasicSearchQuery.DAV_NS);
            hrefElement.setText(UrlUtils.getPath(qs.getHref()));
            Element depthElement = new Element("depth", BasicSearchQuery.DAV_NS);
            depthElement.setText(qs.getDepth());
            qsElement.addContent(hrefElement);
            qsElement.addContent(depthElement);
            if (qs.getIncludeVersions()) {
                Element versionsElement = new Element("include-versions", BasicSearchQuery.DAV_NS);
                qsElement.addContent(versionsElement);
            }
            ret.addContent(qsElement);
        }
        return ret;
    }

    public Vector getQueryScopes() {
        return this.mQueryScopes;
    }

    public void setQueryScopes(Vector scopes) {
        this.mQueryScopes = scopes;
    }

    public void addScope(QueryScope scope) {
        this.mQueryScopes.add(scope);
    }

    public void removeScope(QueryScope scope) {
        this.mQueryScopes.remove(scope);
    }

    public void clearScopes() {
        this.mQueryScopes.clear();
    }
}

