# Contributing to Font Awesome

Looking to contribute something to Font Awesome? **Here's how you can help.**

## Quick start

We only accept issues that are icon requests, bug reports, or feature requests.
Bugs must be isolated and reproducible problems that we can fix within the Font
Awesome core.

* [Request a new icon](https://github.com/FortAwesome/Font-Awesome/issues/new?title=Icon%20request:%20icon-name&template=icon-request.md)
* [Request a new feature](https://github.com/FortAwesome/Font-Awesome/issues/new??title=Feature%20request:feature-name&template=feature-request.md)
* [Submit a bug report](https://github.com/FortAwesome/Font-Awesome/issues/new?template=bug-report.md)

## Key branches

- `master` is the latest, deployed version

## Pull requests

- At the moment we are not accepting pull requests containing icons
- Pull requests that do not solve an existing issue are essentially un-prioritized–don't expect these to be addressed quickly
- The files in this repository are generated elsewhere and we do not merge PR's directly into master
- Try not to pollute your pull request with unintended changes–keep them simple and small
- Try to share which browsers your code has been tested in before submitting a pull request
