/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.sort;

import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ValueRepresentation;
import net.sf.saxon.sort.AtomicComparer;
import net.sf.saxon.sort.SortedIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Closure;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;

public class SortedTupleIterator
extends SortedIterator {
    public SortedTupleIterator(XPathContext context, SequenceIterator base, AtomicComparer[] comparators) {
        super(context, base, null, comparators);
        this.setHostLanguage(51);
    }

    protected void buildArray() throws XPathException {
        ObjectValue tupleObject;
        int allocated = 100;
        this.nodeKeys = new Object[allocated * this.recordSize];
        this.count = 0;
        while ((tupleObject = (ObjectValue)this.base.next()) != null) {
            ValueRepresentation[] tuple = (ValueRepresentation[])tupleObject.getObject();
            if (this.count == allocated) {
                Object[] nk2 = new Object[(allocated *= 2) * this.recordSize];
                System.arraycopy(this.nodeKeys, 0, nk2, 0, this.count * this.recordSize);
                this.nodeKeys = nk2;
            }
            int k = this.count * this.recordSize;
            this.nodeKeys[k] = new ObjectValue(tuple[0]);
            for (int n = 1; n <= this.comparators.length; ++n) {
                ValueRepresentation v = tuple[n];
                if (v instanceof Closure) {
                    v = ((Closure)v).reduce();
                }
                this.nodeKeys[k + n] = v instanceof EmptySequence ? null : v;
            }
            this.nodeKeys[k + this.comparators.length + 1] = new Integer(this.count);
            ++this.count;
        }
    }
}

