#ifndef _PACKETS_PRIV_H
#define _PACKETS_PRIV_H

/* packets-priv.h

   Data structures and functions internal to the packets module.

   Copyright (C) 2007, 2008, 2009, 2010, 2011, 2012, 2013 Eloy Paris

   This is part of Network Expect.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
    
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
    
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include <stdint.h>
#include <tcl.h>
#include <glib.h>
#include <dnet.h>
#include <epan/epan_dissect.h>

extern GHashTable *dissection_vars;

extern char *_pkt_varname(proto_node *, const char *);
extern void _pkt_createvar(Tcl_Interp *, const char *, Tcl_Obj *,
			       GHashTable *);
extern char *_pkt_layername(Tcl_Interp *, const char *, int);
extern char * _pkt_prepend_ns_name(const char *, const char *);

extern int _pkt_get_uint8(Tcl_Interp *, const char *, uint8_t *);
extern int _pkt_get_uint16(Tcl_Interp *, const char *, uint16_t *);
#if 0
extern int _pkt_get_list_uint16(Tcl_Interp *, const char *, int, uint16_t *);
#endif
extern int _pkt_get_ipaddr(Tcl_Interp *, const char *, ip_addr_t *);
extern int _pkt_get_boolean(Tcl_Interp *, const char *, int *);

#endif /* _PACKETS_PRIV_H */
