<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/uwsgi/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/collectors/python.d.plugin/uwsgi/metadata.yaml"
sidebar_label: "uWSGI"
learn_status: "Published"
learn_rel_path: "Data Collection/Web Servers and Web Proxies"
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# uWSGI


<img src="https://netdata.cloud/img/uwsgi.svg" width="150"/>


Plugin: python.d.plugin
Module: uwsgi

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors uWSGI metrics about requests, workers, memory and more.

It collects every metric exposed from the stats server of uWSGI, either from the `stats.socket` or from the web server's TCP/IP socket.

This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

This collector will auto-detect uWSGI instances deployed on the local host, running on port 1717, or exposing stats on socket `tmp/stats.socket`.

#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.


## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.



### Per uWSGI instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| uwsgi.requests | a dimension per worker | requests/s |
| uwsgi.tx | a dimension per worker | KiB/s |
| uwsgi.avg_rt | a dimension per worker | milliseconds |
| uwsgi.memory_rss | a dimension per worker | MiB |
| uwsgi.memory_vsz | a dimension per worker | MiB |
| uwsgi.exceptions | exceptions | exceptions |
| uwsgi.harakiris | harakiris | harakiris |
| uwsgi.respawns | respawns | respawns |



## Alerts

There are no alerts configured by default for this integration.


## Setup

### Prerequisites

#### Enable the uWSGI Stats server

Make sure that you uWSGI exposes it's metrics via a Stats server.

Source: https://uwsgi-docs.readthedocs.io/en/latest/StatsServer.html



### Configuration

#### File

The configuration file name for this integration is `python.d/uwsgi.conf`.


You can edit the configuration file using the `edit-config` script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/configure/nodes.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config python.d/uwsgi.conf
```
#### Options

There are 2 sections:

* Global variables
* One or more JOBS that can define multiple different instances to monitor.

The following options can be defined globally: priority, penalty, autodetection_retry, update_every, but can also be defined per JOB to override the global values.

Additionally, the following collapsed table contains all the options that can be configured inside a JOB definition.

Every configuration JOB starts with a `job_name` value which will appear in the dashboard, unless a `name` parameter is specified.


<details><summary>Config options</summary>

| Name | Description | Default | Required |
|:----|:-----------|:-------|:--------:|
| update_every | Sets the default data collection frequency. | 5 | False |
| priority | Controls the order of charts at the netdata dashboard. | 60000 | False |
| autodetection_retry | Sets the job re-check interval in seconds. | 0 | False |
| penalty | Indicates whether to apply penalty to update_every in case of failures. | yes | False |
| name | The JOB's name as it will appear at the dashboard (by default is the job_name) | job_name | False |
| socket | The 'path/to/uwsgistats.sock' | no | False |
| host | The host to connect to | no | False |
| port | The port to connect to | no | False |

</details>

#### Examples

##### Basic (default out-of-the-box)

A basic example configuration, one job will run at a time. Autodetect mechanism uses it by default. As all JOBs have the same name, only one can run at a time.

<details><summary>Config</summary>

```yaml
socket:
  name     : 'local'
  socket   : '/tmp/stats.socket'

localhost:
  name     : 'local'
  host     : 'localhost'
  port     : 1717

localipv4:
  name     : 'local'
  host     : '127.0.0.1'
  port     : 1717

localipv6:
  name     : 'local'
  host     : '::1'
  port     : 1717

```
</details>

##### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details><summary>Config</summary>

```yaml
local:
  name     : 'local'
  host     : 'localhost'
  port     : 1717

remote:
  name     : 'remote'
  host     : '192.0.2.1'
  port     : 1717

```
</details>



## Troubleshooting

### Debug Mode

To troubleshoot issues with the `uwsgi` collector, run the `python.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `python.d.plugin` to debug the collector:

  ```bash
  ./python.d.plugin uwsgi debug trace
  ```


